/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.logging.java;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.esapi.logging.java.ESAPICustomJavaLevel;
import org.owasp.esapi.logging.java.JavaLogLevelHandler;

public enum JavaLogLevelHandlers implements JavaLogLevelHandler
{
    SEVERE(Level.SEVERE),
    WARNING(Level.WARNING),
    INFO(Level.INFO),
    CONFIG(Level.CONFIG),
    FINE(Level.FINE),
    FINER(Level.FINER),
    FINEST(Level.FINEST),
    ALWAYS(ESAPICustomJavaLevel.ALWAYS_LEVEL),
    ERROR(ESAPICustomJavaLevel.ERROR_LEVEL);

    private final Level level;

    private JavaLogLevelHandlers(Level lvl) {
        this.level = lvl;
    }

    @Override
    public boolean isEnabled(Logger logger) {
        return logger.isLoggable(this.level);
    }

    @Override
    public void log(Logger logger, String msg) {
        logger.log(this.level, msg);
    }

    @Override
    public void log(Logger logger, String msg, Throwable th) {
        logger.log(this.level, msg, th);
    }
}

