/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.util;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import org.apache.axis2.transport.http.util.URIEncoderDecoder;

public class QueryStringParser {
    private final String queryString;
    private int paramBegin;
    private int paramEnd = -1;
    private int paramNameEnd;
    private String paramName;
    private String paramValue;

    public QueryStringParser(String queryString) {
        this.queryString = queryString;
    }

    public boolean next() {
        int idx;
        int len = this.queryString.length();
        do {
            if (this.paramEnd == len) {
                return false;
            }
            this.paramBegin = this.paramEnd == -1 ? 0 : this.paramEnd + 1;
            idx = this.queryString.indexOf(38, this.paramBegin);
            int n = this.paramEnd = idx == -1 ? len : idx;
        } while (this.paramEnd <= this.paramBegin);
        idx = this.queryString.indexOf(61, this.paramBegin);
        this.paramNameEnd = idx == -1 || idx > this.paramEnd ? this.paramEnd : idx;
        this.paramName = null;
        this.paramValue = null;
        return true;
    }

    public boolean search(Collection<String> names) {
        while (this.next()) {
            if (!names.contains(this.getName())) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        if (this.paramName == null) {
            this.paramName = this.queryString.substring(this.paramBegin, this.paramNameEnd);
        }
        return this.paramName;
    }

    public String getValue() {
        if (this.paramValue == null) {
            if (this.paramNameEnd == this.paramEnd) {
                return null;
            }
            try {
                this.paramValue = URIEncoderDecoder.decode(this.queryString.substring(this.paramNameEnd + 1, this.paramEnd));
            }
            catch (UnsupportedEncodingException ex) {
                throw new Error(ex);
            }
        }
        return this.paramValue;
    }
}

