/* Idl.java */
/* Generated By:JavaCC: Do not edit this line. Idl.java */
package org.apache.avro.compiler.idl;

import java.io.*;
import java.net.*;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.net.URL;

import org.apache.avro.Schema;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema.*;
import org.apache.avro.Protocol;
import org.apache.avro.Protocol.*;
import org.apache.avro.util.internal.Accessor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.*;

import org.apache.commons.text.StringEscapeUtils;

/**
 * Grammar to parse a higher-level language into an Avro Schema.
 *
 * Note: each instance is not thread-safe, but multiple separate
 * instances are safely independent.
 *
 * @deprecated Use the new org.apache.avro.idl.IdlReader from avro-idl instead.
 */
@Deprecated
public class Idl implements Closeable, IdlConstants {
  static JsonNodeFactory FACTORY = JsonNodeFactory.instance;
  private static final String OPTIONAL_NULLABLE_TYPE_PROPERTY = "org.apache.avro.compiler.idl.Idl.NullableType.optional";

  URI inputDir;
  ClassLoader resourceLoader = null;
  String namespace;
  Map<String,Schema> names = new LinkedHashMap<>();

  private List<String> parserWarnings = Collections.emptyList();
  /**
   * Return all warnings that were encountered while parsing.
   */
  public List<String> getWarningsAfterParsing() {
    return parserWarnings;
  }

  public Idl(File inputFile) throws IOException {
    this(new FileInputStream(inputFile), "UTF-8");
    this.inputDir = inputFile.getParentFile().toURI();
  }

  public Idl(File inputFile, ClassLoader resourceLoader) throws IOException {
    this(inputFile);
    this.resourceLoader = resourceLoader;
  }

  private static URI resourceParent(URL jar) throws IOException {
    String path = jar.toExternalForm();
    String name = path.substring(path.indexOf("!/") + 1);
    try {
      URI uri = new URI("classpath", null, name, null);
      return uri.resolve(".");
    } catch (URISyntaxException e) {
      throw new IOException("Could not handle resource import in " + jar, e);
    }
  }

  private Idl(URL input, Idl parent) throws IOException {
    this(input.openStream(), "UTF-8");
    this.inputDir = "file".equals(input.getProtocol())
      ? new File(input.getPath()).getParentFile().toURI()
      : "jar".equals(input.getProtocol())
      ?  resourceParent(input)
      : parent.inputDir;
    this.resourceLoader = parent.resourceLoader;
  }

  @SuppressWarnings("RedundantThrows")
  public void close() throws IOException {
    jj_input_stream.inputStream.close();
  }

  private ParseException error(String message, Token token) {
    return new ParseException
      (message+", at line "+token.beginLine+", column "+token.beginColumn);
  }

  private String getTextProp(String key, Map<String,JsonNode> props,
                             Token token) throws ParseException {
    JsonNode value = props.get(key);
    if (value.isTextual())
      return value.textValue();
    throw error(key+" property must be textual: "+value, token);
  }

  private List<String> getTextProps(String key, Map<String,JsonNode> props,
                             Token token) throws ParseException {
    JsonNode value = props.get(key);
    if (!value.isArray())
      throw error(key+" property must be array: "+value, token);
    List<String> values = new ArrayList<>();
    for (JsonNode n : value)
      if (n.isTextual())
        values.add(n.textValue());
      else
        throw error(key+" values must be textual: "+n, token);
    return values;
  }

  private URL findFile(String importFile) throws IOException {
    URI uri = this.inputDir.resolve(importFile);
    File file = "file".equals(uri.getScheme()) ? new File(uri.getPath()) : null;
    URL result = null;
    if (file != null && file.exists())
      result = new URL("file:" + file.getPath());
    else if (this.resourceLoader != null)
      if ("classpath".equals(uri.getScheme()))
        result = this.resourceLoader.getResource(uri.getPath().substring(1));
      else
        result = this.resourceLoader.getResource(importFile);
    if (result == null)
      throw new FileNotFoundException(importFile);
    return result;
  }

  /**
   * For "optional schemas" (recognized by the marker property the NullableType
   * production adds), ensure the null schema is in the right place.
   *
   * @param schema       a schema
   * @param defaultValue the intended default value
   * @return the schema, or an optional schema with null in the right place
   */
  private static Schema fixOptionalSchema(Schema schema, JsonNode defaultValue) {
    final Object optionalType = schema.getObjectProp(OPTIONAL_NULLABLE_TYPE_PROPERTY);
    if (optionalType != null) {
      // The schema is a union schema with 2 types: "null" and a non-"null" schema
      Schema nullSchema = schema.getTypes().get(0);
      Schema nonNullSchema = schema.getTypes().get(1);
      boolean nonNullDefault = defaultValue != null && !defaultValue.isNull();

      // Always return a new schema: this drops the marker property.
      if (nonNullDefault) {
        return Schema.createUnion(nonNullSchema, nullSchema);
      } else {
        return Schema.createUnion(nullSchema, nonNullSchema);
      }
    }
    return schema;
  }

/********************************************
 * THE AVRO IDL LANGUAGE GRAMMAR STARTS HERE *
 ********************************************/

/**
 * The input to Idl is a CompilationUnit, which is currently
 * just a single Protocol.
 */
  final public Protocol CompilationUnit() throws ParseException {Protocol p;
  DocCommentHelper.getAndClearWarnings(); // Throw away previous results.

    p = ProtocolDeclaration();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 74:{
      jj_consume_token(74);
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STUFF_TO_IGNORE:{
      jj_consume_token(STUFF_TO_IGNORE);
      break;
      }
    default:
      jj_la1[1] = jj_gen;
      ;
    }
    jj_consume_token(0);
parserWarnings = DocCommentHelper.getAndClearWarnings();
    {if ("" != null) return SchemaResolver.resolve(p);}
    throw new Error("Missing return statement in function");
}

  final private Schema NamedSchemaDeclaration(String doc, Map<String, JsonNode> props) throws ParseException {Schema s;
  String savedSpace = this.namespace;
if (props.containsKey("namespace"))
      this.namespace = getTextProp("namespace", props, token);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FIXED:{
      s = FixedDeclaration(doc);
      break;
      }
    case ENUM:{
      s = EnumDeclaration(doc);
      break;
      }
    case ERROR:
    case RECORD:{
      s = RecordDeclaration(doc);
      break;
      }
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
this.namespace = savedSpace;

   for (String key : props.keySet())
     if ("namespace".equals(key)) {               // already handled: ignore
     } else if ("aliases".equals(key)) {          // aliases
       for (String alias : getTextProps("aliases", props, token))
         s.addAlias(alias);
     } else {                                     // add all other properties
       Accessor.addProp(s, key, props.get(key));
     }
   LogicalType logicalType = LogicalTypes.fromSchemaIgnoreInvalid(s);
   if (logicalType != null)
     logicalType.addToSchema(s);

   {if ("" != null) return s;}
    throw new Error("Missing return statement in function");
}

  final public Schema UnionDefinition() throws ParseException {Schema s;
  List<Schema> schemata = new ArrayList<>();
    jj_consume_token(UNION);
    jj_consume_token(LBRACE);
    s = Type();
schemata.add(s);
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[3] = jj_gen;
        break label_1;
      }
      jj_consume_token(COMMA);
      s = Type();
schemata.add(s);
    }
    jj_consume_token(RBRACE);
{if ("" != null) return Schema.createUnion(schemata);}
    throw new Error("Missing return statement in function");
}

  final public Protocol ProtocolDeclaration() throws ParseException {String doc, name;
  Protocol p;
  Map<String, JsonNode> props = new LinkedHashMap<>();
    doc = Documentation();
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AT:{
        ;
        break;
        }
      default:
        jj_la1[4] = jj_gen;
        break label_2;
      }
      SchemaProperty(props);
    }
if (props.containsKey("namespace"))
      namespace = getTextProp("namespace", props, token);
    jj_consume_token(PROTOCOL);
    name = Identifier();
p = new Protocol(name, doc, namespace);
   for (String key : props.keySet())
     if ("namespace".equals(key)) {               // already handled: ignore
     } else {                                     // add all other properties
       Accessor.addProp(p, key, props.get(key));
     }
    ProtocolBody(p);
{if ("" != null) return p;}
    throw new Error("Missing return statement in function");
}

  final public String Documentation() throws ParseException {//noinspection ResultOfMethodCallIgnored
  getToken(1); // Parse, but don't consume, at least one token; this triggers parsing special tokens like doc comments.

{if ("" != null) return DocCommentHelper.getDoc();}
    throw new Error("Missing return statement in function");
}

  final public Schema EnumDeclaration(String doc) throws ParseException {String name;
  List<String> symbols;
  String defaultSymbol = null;
    jj_consume_token(ENUM);
    name = Identifier();
    symbols = EnumBody();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case EQUALS:{
      jj_consume_token(EQUALS);
      defaultSymbol = Identifier();
      jj_consume_token(SEMICOLON);
DocCommentHelper.clearDoc();
      break;
      }
    default:
      jj_la1[5] = jj_gen;
      ;
    }
Schema s = Schema.createEnum(name, doc, namespace, symbols, defaultSymbol);
    names.put(s.getFullName(), s);
    {if ("" != null) return s;}
    throw new Error("Missing return statement in function");
}

  final public List<String> EnumBody() throws ParseException {List<String> symbols = new ArrayList<>();
    jj_consume_token(LBRACE);
DocCommentHelper.clearDoc();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENTIFIER:
    case TICK:{
      EnumConstant(symbols);
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[6] = jj_gen;
          break label_3;
        }
        jj_consume_token(COMMA);
        EnumConstant(symbols);
      }
      break;
      }
    default:
      jj_la1[7] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
DocCommentHelper.clearDoc();
    {if ("" != null) return symbols;}
    throw new Error("Missing return statement in function");
}

  final public void EnumConstant(List<String> symbols) throws ParseException {String sym;
    sym = Identifier();
symbols.add(sym);
}

  final public void ProtocolBody(Protocol p) throws ParseException {String doc;
  Schema schema;
  Message message;
  Protocol importProtocol;
  Map<String, JsonNode> props = new LinkedHashMap<>();
    jj_consume_token(LBRACE);
DocCommentHelper.clearDoc();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ARRAY:
      case BOOLEAN:
      case DOUBLE:
      case ENUM:
      case ERROR:
      case FIXED:
      case FLOAT:
      case IMPORT:
      case INT:
      case LONG:
      case MAP:
      case BYTES:
      case STRING:
      case NULL:
      case RECORD:
      case UNION:
      case VOID:
      case DATE:
      case TIME:
      case TIMESTAMP:
      case DECIMAL:
      case BIG_DECIMAL:
      case LOCAL_TIMESTAMP:
      case UUID:
      case IDENTIFIER:
      case AT:
      case TICK:{
        ;
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        break label_4;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IMPORT:{
        jj_consume_token(IMPORT);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IDL:
        case PROTOCOL:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case IDL:{
            importProtocol = ImportIdl();
            break;
            }
          case PROTOCOL:{
            importProtocol = ImportProtocol();
            break;
            }
          default:
            jj_la1[9] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
for (Schema s : importProtocol.getTypes())
         names.put(s.getFullName(), s);
       p.getMessages().putAll(importProtocol.getMessages());
          break;
          }
        case SCHEMA:{
          schema = ImportSchema();
          break;
          }
        default:
          jj_la1[10] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
DocCommentHelper.clearDoc();
        break;
        }
      case ARRAY:
      case BOOLEAN:
      case DOUBLE:
      case ENUM:
      case ERROR:
      case FIXED:
      case FLOAT:
      case INT:
      case LONG:
      case MAP:
      case BYTES:
      case STRING:
      case NULL:
      case RECORD:
      case UNION:
      case VOID:
      case DATE:
      case TIME:
      case TIMESTAMP:
      case DECIMAL:
      case BIG_DECIMAL:
      case LOCAL_TIMESTAMP:
      case UUID:
      case IDENTIFIER:
      case AT:
      case TICK:{
        doc = Documentation();
        label_5:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case AT:{
            ;
            break;
            }
          default:
            jj_la1[11] = jj_gen;
            break label_5;
          }
          SchemaProperty(props);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ENUM:
        case ERROR:
        case FIXED:
        case RECORD:{
          schema = NamedSchemaDeclaration(doc, props);
          break;
          }
        case ARRAY:
        case BOOLEAN:
        case DOUBLE:
        case FLOAT:
        case INT:
        case LONG:
        case MAP:
        case BYTES:
        case STRING:
        case NULL:
        case UNION:
        case VOID:
        case DATE:
        case TIME:
        case TIMESTAMP:
        case DECIMAL:
        case BIG_DECIMAL:
        case LOCAL_TIMESTAMP:
        case UUID:
        case IDENTIFIER:
        case TICK:{
          message = MessageDeclaration(p, doc, props);
p.getMessages().put(message.getName(), message);
          break;
          }
        default:
          jj_la1[12] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
props.clear();
        break;
        }
      default:
        jj_la1[13] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RBRACE);
p.setTypes(names.values());
    DocCommentHelper.clearDoc();
}

  final public Protocol ImportIdl() throws ParseException {String importFile;
    jj_consume_token(IDL);
    importFile = JsonString();
    jj_consume_token(SEMICOLON);
try (Idl idl=new Idl(findFile(importFile), this)){
        {if ("" != null) return idl.CompilationUnit();}
      } catch (IOException e) {
        {if (true) throw error("Error importing "+importFile+": "+e, token);}
      }
    throw new Error("Missing return statement in function");
}

  final public Protocol ImportProtocol() throws ParseException {String importFile;
    jj_consume_token(PROTOCOL);
    importFile = JsonString();
    jj_consume_token(SEMICOLON);
try (InputStream stream=findFile(importFile).openStream()) {
        {if ("" != null) return Protocol.parse(stream);}
      } catch (IOException e) {
        {if (true) throw error("Error importing "+importFile+": "+e, token);}
      }
    throw new Error("Missing return statement in function");
}

  final public Schema ImportSchema() throws ParseException {String importFile;
    jj_consume_token(SCHEMA);
    importFile = JsonString();
    jj_consume_token(SEMICOLON);
try (InputStream stream=findFile(importFile).openStream()){
        // This usage of Schema.Parser should not be changed.
        // Remove this whole (old) IDL parser instead.
        Parser parser = new Schema.Parser();
        parser.addTypes(names.values());          // inherit names
        Schema value = parser.parse(stream);
        names = parser.getTypes();                // update names
        {if ("" != null) return value;}
      } catch (IOException e) {
        {if (true) throw error("Error importing "+importFile+": "+e, token);}
      }
    throw new Error("Missing return statement in function");
}

  final public Schema FixedDeclaration(String doc) throws ParseException {String name;
  Token sizeTok;
    jj_consume_token(FIXED);
    name = Identifier();
    jj_consume_token(LPAREN);
    sizeTok = jj_consume_token(INTEGER_LITERAL);
    jj_consume_token(RPAREN);
    jj_consume_token(SEMICOLON);
DocCommentHelper.clearDoc();
    Schema s = Schema.createFixed(name, doc, this.namespace, Integer.parseInt(sizeTok.image));
    names.put(s.getFullName(), s);
    {if ("" != null) return s;}
    throw new Error("Missing return statement in function");
}

  final public Schema RecordDeclaration(String doc) throws ParseException {String name;
  List<Field> fields = new ArrayList<>();
  boolean isError;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case RECORD:{
      jj_consume_token(RECORD);
isError = false;
      break;
      }
    case ERROR:{
      jj_consume_token(ERROR);
isError = true;
      break;
      }
    default:
      jj_la1[14] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    name = Identifier();
Schema result = Schema.createRecord(name, doc, this.namespace, isError);
    names.put(result.getFullName(), result);
    jj_consume_token(LBRACE);
DocCommentHelper.clearDoc();
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ARRAY:
      case BOOLEAN:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case MAP:
      case BYTES:
      case STRING:
      case NULL:
      case UNION:
      case DATE:
      case TIME:
      case TIMESTAMP:
      case DECIMAL:
      case BIG_DECIMAL:
      case LOCAL_TIMESTAMP:
      case UUID:
      case IDENTIFIER:
      case AT:
      case TICK:{
        ;
        break;
        }
      default:
        jj_la1[15] = jj_gen;
        break label_6;
      }
      FieldDeclaration(fields);
    }
    jj_consume_token(RBRACE);
DocCommentHelper.clearDoc();
    result.setFields(fields);
    {if ("" != null) return result;}
    throw new Error("Missing return statement in function");
}

  final private void SchemaProperty(Map<String, JsonNode> properties) throws ParseException {String key;
  JsonNode val;
    jj_consume_token(AT);
    key = PropertyName();
    jj_consume_token(LPAREN);
    val = Json();
    jj_consume_token(RPAREN);
if (properties.containsKey(key))
      {if (true) throw error("Property '" + key + "' already specified", token);}
    properties.put(key, val);
}

  final public void FieldDeclaration(List<Field> fields) throws ParseException {String defaultDoc;
  Schema type;
    defaultDoc = Documentation();
    type = Type();
    VariableDeclarator(type, defaultDoc, fields);
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[16] = jj_gen;
        break label_7;
      }
      jj_consume_token(COMMA);
      VariableDeclarator(type, defaultDoc, fields);
    }
    jj_consume_token(SEMICOLON);
DocCommentHelper.clearDoc();
}

  final public void VariableDeclarator(Schema type, String defaultDoc, List<Field> fields) throws ParseException {String doc, name;
  JsonNode defaultValue = null;
  Map<String, JsonNode> props = new LinkedHashMap<>();
    doc = Documentation();
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AT:{
        ;
        break;
        }
      default:
        jj_la1[17] = jj_gen;
        break label_8;
      }
      SchemaProperty(props);
    }
    name = Identifier();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case EQUALS:{
      jj_consume_token(EQUALS);
      defaultValue = Json();
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      ;
    }
Field.Order order = Field.Order.ASCENDING;
    for (String key : props.keySet())
      if ("order".equals(key))
        order = Field.Order.valueOf(getTextProp(key,props,token).toUpperCase());

    boolean validate = SchemaResolver.isFullyResolvedSchema(type);
    Schema fieldType = fixOptionalSchema(type, defaultValue);
    Field field = Accessor.createField(name, fieldType, doc == null ? defaultDoc : doc, defaultValue, validate, order);
    for (String key : props.keySet())
      if ("order".equals(key)) {                  // already handled: ignore
      } else if ("aliases".equals(key)) {         // aliases
        for (String alias : getTextProps("aliases", props, token))
          field.addAlias(alias);
      } else {                                    // add all other properties
        Accessor.addProp(field, key, props.get(key));
      }
    fields.add(field);
    DocCommentHelper.clearDoc();
}

  final private Message MessageDeclaration(Protocol p, String msgDoc, Map<String, JsonNode> props) throws ParseException {String name;
  Schema request;
  Schema response;
  boolean oneWay = false;
  List<Schema> errorSchemata = new ArrayList<>();
  errorSchemata.add(Protocol.SYSTEM_ERROR);
    response = ResultType();
    name = Identifier();
    request = FormalParameters();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ONEWAY:
    case THROWS:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ONEWAY:{
        jj_consume_token(ONEWAY);
oneWay = true;
        break;
        }
      case THROWS:{
        jj_consume_token(THROWS);
        ErrorList(errorSchemata);
        break;
        }
      default:
        jj_la1[19] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[20] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
DocCommentHelper.clearDoc();
    Schema errors = Schema.createUnion(errorSchemata);
    if (oneWay && response.getType() != Type.NULL)
      {if (true) throw error("One-way message'"+name+"' must return void", token);}
    {if ("" != null) return oneWay
    ? p.createMessage(name, msgDoc, props, request)
    : p.createMessage(name, msgDoc, props, request, response, errors);}
    throw new Error("Missing return statement in function");
}

  final public void ErrorList(List<Schema> errors) throws ParseException {Schema s;
    s = ReferenceType();
errors.add(s);
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[21] = jj_gen;
        break label_9;
      }
      jj_consume_token(COMMA);
      s = ReferenceType();
errors.add(s);
    }
}

  final public Schema FormalParameters() throws ParseException {List<Field> fields = new ArrayList<>();
    jj_consume_token(LPAREN);
DocCommentHelper.clearDoc();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ARRAY:
    case BOOLEAN:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case MAP:
    case BYTES:
    case STRING:
    case NULL:
    case UNION:
    case DATE:
    case TIME:
    case TIMESTAMP:
    case DECIMAL:
    case BIG_DECIMAL:
    case LOCAL_TIMESTAMP:
    case UUID:
    case IDENTIFIER:
    case AT:
    case TICK:{
      FormalParameter(fields);
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[22] = jj_gen;
          break label_10;
        }
        jj_consume_token(COMMA);
        FormalParameter(fields);
      }
      break;
      }
    default:
      jj_la1[23] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
DocCommentHelper.clearDoc();
    {if ("" != null) return Schema.createRecord(null, null, null, false, fields);}
    throw new Error("Missing return statement in function");
}

  final public void FormalParameter(List<Field> fields) throws ParseException {String doc;
  Schema type;
    doc = Documentation();
    type = Type();
    VariableDeclarator(type, doc, fields);
}

  final public Schema Type() throws ParseException {Schema s;
  Map<String, JsonNode> props = new LinkedHashMap<>();
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AT:{
        ;
        break;
        }
      default:
        jj_la1[24] = jj_gen;
        break label_11;
      }
      SchemaProperty(props);
    }
    s = UnannotatedType(props);
{if ("" != null) return s;}
    throw new Error("Missing return statement in function");
}

  final public Schema UnannotatedType(Map<String, JsonNode> props) throws ParseException {Schema s;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BOOLEAN:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case BYTES:
    case STRING:
    case NULL:
    case DATE:
    case TIME:
    case TIMESTAMP:
    case DECIMAL:
    case BIG_DECIMAL:
    case LOCAL_TIMESTAMP:
    case UUID:
    case IDENTIFIER:
    case TICK:{
      s = NullableType(props);
      break;
      }
    case ARRAY:
    case MAP:
    case UNION:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case UNION:{
        s = UnionDefinition();
        break;
        }
      case ARRAY:{
        s = ArrayType();
        break;
        }
      case MAP:{
        s = MapType();
        break;
        }
      default:
        jj_la1[25] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
// NullableType also applies properties, inside any union with null it may create.
        for (String key : props.keySet())
          Accessor.addProp(s, key, props.get(key));
        LogicalType logicalType = LogicalTypes.fromSchemaIgnoreInvalid(s);
        if (logicalType != null)
          logicalType.addToSchema(s);
      break;
      }
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return s;}
    throw new Error("Missing return statement in function");
}

  final public Schema NullableType(Map<String, JsonNode> props) throws ParseException {Schema s;
  boolean optional = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENTIFIER:
    case TICK:{
      s = ReferenceType();
if (!props.isEmpty()) { {if (true) throw error("Type references may not be annotated", token);} }
      break;
      }
    case BOOLEAN:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case BYTES:
    case STRING:
    case NULL:
    case DATE:
    case TIME:
    case TIMESTAMP:
    case DECIMAL:
    case BIG_DECIMAL:
    case LOCAL_TIMESTAMP:
    case UUID:{
      s = PrimitiveType();
      break;
      }
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case QUESTION_MARK:{
      jj_consume_token(QUESTION_MARK);
optional = true;
      break;
      }
    default:
      jj_la1[28] = jj_gen;
      ;
    }
// By applying the properties here (before creating the union), type annotations modify the optional type instead of the union.
    for (String key : props.keySet())
      Accessor.addProp(s, key, props.get(key));
    LogicalType logicalType = LogicalTypes.fromSchemaIgnoreInvalid(s);
    if (logicalType != null)
      logicalType.addToSchema(s);
    if (optional) {
      s = Schema.createUnion(Schema.create(Schema.Type.NULL), s);
      // Add a marker property to the union (it will be removed when creating fields)
      Accessor.addProp(s, OPTIONAL_NULLABLE_TYPE_PROPERTY, BooleanNode.TRUE);
    }
    {if ("" != null) return s;}
    throw new Error("Missing return statement in function");
}

  final public Schema ArrayType() throws ParseException {Schema elemSchema;
    jj_consume_token(ARRAY);
    jj_consume_token(LT);
    elemSchema = Type();
    jj_consume_token(GT);
{if ("" != null) return Schema.createArray(elemSchema);}
    throw new Error("Missing return statement in function");
}

  final public Schema MapType() throws ParseException {Schema elemSchema;
    jj_consume_token(MAP);
    jj_consume_token(LT);
    elemSchema = Type();
    jj_consume_token(GT);
{if ("" != null) return Schema.createMap(elemSchema);}
    throw new Error("Missing return statement in function");
}

/**
 * A reference to some other existing type
 */
  final public Schema ReferenceType() throws ParseException {String part;
  Token tok;
  StringBuilder sb = new StringBuilder();
    part = Identifier();
sb.append(part);
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:{
        ;
        break;
        }
      default:
        jj_la1[29] = jj_gen;
        break label_12;
      }
      jj_consume_token(DOT);
      tok = AnyIdentifier();
sb.append(".").append(tok.image);
    }
String name = sb.toString();
    if ((name.indexOf('.') == -1) && namespace != null)
      name = namespace + "." + name;
    Schema type = names.get(name);
    if (type == null)
    {
      type = SchemaResolver.unresolvedSchema(name);
    }
    {if ("" != null) return type;}
    throw new Error("Missing return statement in function");
}

  final public Schema PrimitiveType() throws ParseException {Schema s;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BOOLEAN:{
      jj_consume_token(BOOLEAN);
{if ("" != null) return Schema.create(Type.BOOLEAN);}
      break;
      }
    case BYTES:{
      jj_consume_token(BYTES);
{if ("" != null) return Schema.create(Type.BYTES);}
      break;
      }
    case INT:{
      jj_consume_token(INT);
{if ("" != null) return Schema.create(Type.INT);}
      break;
      }
    case STRING:{
      jj_consume_token(STRING);
{if ("" != null) return Schema.create(Type.STRING);}
      break;
      }
    case FLOAT:{
      jj_consume_token(FLOAT);
{if ("" != null) return Schema.create(Type.FLOAT);}
      break;
      }
    case DOUBLE:{
      jj_consume_token(DOUBLE);
{if ("" != null) return Schema.create(Type.DOUBLE);}
      break;
      }
    case LONG:{
      jj_consume_token(LONG);
{if ("" != null) return Schema.create(Type.LONG);}
      break;
      }
    case NULL:{
      jj_consume_token(NULL);
{if ("" != null) return Schema.create(Type.NULL);}
      break;
      }
    case DATE:{
      jj_consume_token(DATE);
{if ("" != null) return LogicalTypes.date().addToSchema(Schema.create(Type.INT));}
      break;
      }
    case TIME:{
      jj_consume_token(TIME);
{if ("" != null) return LogicalTypes.timeMillis().addToSchema(Schema.create(Type.INT));}
      break;
      }
    case TIMESTAMP:{
      jj_consume_token(TIMESTAMP);
{if ("" != null) return LogicalTypes.timestampMillis().addToSchema(Schema.create(Type.LONG));}
      break;
      }
    case LOCAL_TIMESTAMP:{
      jj_consume_token(LOCAL_TIMESTAMP);
{if ("" != null) return LogicalTypes.localTimestampMillis().addToSchema(Schema.create(Type.LONG));}
      break;
      }
    case DECIMAL:{
      jj_consume_token(DECIMAL);
      s = DecimalTypeProperties();
{if ("" != null) return s;}
      break;
      }
    case BIG_DECIMAL:{
      jj_consume_token(BIG_DECIMAL);
{if ("" != null) return LogicalTypes.bigDecimal().addToSchema(Schema.create(Type.BYTES));}
      break;
      }
    case UUID:{
      jj_consume_token(UUID);
{if ("" != null) return LogicalTypes.uuid().addToSchema(Schema.create(Type.STRING));}
      break;
      }
    default:
      jj_la1[30] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public Schema DecimalTypeProperties() throws ParseException {int precision;
  int scale;
    jj_consume_token(LPAREN);
precision = Json().asInt();
    jj_consume_token(COMMA);
scale = Json().asInt();
    jj_consume_token(RPAREN);
{if ("" != null) return LogicalTypes.decimal(precision, scale).addToSchema(Schema.create(Type.BYTES));}
    throw new Error("Missing return statement in function");
}

/**
 * Result types are like other types, except we provide "void" as
 * an alias of "null"
 */
  final public Schema ResultType() throws ParseException {Schema schema;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case VOID:{
      jj_consume_token(VOID);
{if ("" != null) return Schema.create(Type.NULL);}
      break;
      }
    case ARRAY:
    case BOOLEAN:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case MAP:
    case BYTES:
    case STRING:
    case NULL:
    case UNION:
    case DATE:
    case TIME:
    case TIMESTAMP:
    case DECIMAL:
    case BIG_DECIMAL:
    case LOCAL_TIMESTAMP:
    case UUID:
    case IDENTIFIER:
    case TICK:{
      schema = UnannotatedType(Collections.emptyMap());
{if ("" != null) return schema;}
      break;
      }
    default:
      jj_la1[31] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public String PropertyName() throws ParseException {Token t;
  String s;
  StringBuilder name = new StringBuilder();
    s = Identifier();
name.append(s);
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:
      case DASH:{
        ;
        break;
        }
      default:
        jj_la1[32] = jj_gen;
        break label_13;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DASH:{
        t = jj_consume_token(DASH);
name.append(t.image);
        s = Identifier();
name.append(s);
        break;
        }
      case DOT:{
        t = jj_consume_token(DOT);
name.append(t.image);
        s = Identifier();
name.append(s);
        break;
        }
      default:
        jj_la1[33] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return name.toString();}
    throw new Error("Missing return statement in function");
}

  final public String Identifier() throws ParseException {Token t;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENTIFIER:{
      t = jj_consume_token(IDENTIFIER);
{if ("" != null) return t.image;}
      break;
      }
    case TICK:{
      jj_consume_token(TICK);
      t = AnyIdentifier();
      jj_consume_token(TICK);
{if ("" != null) return t.image;}
      break;
      }
    default:
      jj_la1[34] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public Token AnyIdentifier() throws ParseException {Token t;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ARRAY:{
      t = jj_consume_token(ARRAY);
      break;
      }
    case BOOLEAN:{
      t = jj_consume_token(BOOLEAN);
      break;
      }
    case DOUBLE:{
      t = jj_consume_token(DOUBLE);
      break;
      }
    case ENUM:{
      t = jj_consume_token(ENUM);
      break;
      }
    case ERROR:{
      t = jj_consume_token(ERROR);
      break;
      }
    case FALSE:{
      t = jj_consume_token(FALSE);
      break;
      }
    case FIXED:{
      t = jj_consume_token(FIXED);
      break;
      }
    case FLOAT:{
      t = jj_consume_token(FLOAT);
      break;
      }
    case IDL:{
      t = jj_consume_token(IDL);
      break;
      }
    case IMPORT:{
      t = jj_consume_token(IMPORT);
      break;
      }
    case INT:{
      t = jj_consume_token(INT);
      break;
      }
    case LONG:{
      t = jj_consume_token(LONG);
      break;
      }
    case MAP:{
      t = jj_consume_token(MAP);
      break;
      }
    case ONEWAY:{
      t = jj_consume_token(ONEWAY);
      break;
      }
    case BYTES:{
      t = jj_consume_token(BYTES);
      break;
      }
    case STRING:{
      t = jj_consume_token(STRING);
      break;
      }
    case NULL:{
      t = jj_consume_token(NULL);
      break;
      }
    case PROTOCOL:{
      t = jj_consume_token(PROTOCOL);
      break;
      }
    case RECORD:{
      t = jj_consume_token(RECORD);
      break;
      }
    case SCHEMA:{
      t = jj_consume_token(SCHEMA);
      break;
      }
    case THROWS:{
      t = jj_consume_token(THROWS);
      break;
      }
    case TRUE:{
      t = jj_consume_token(TRUE);
      break;
      }
    case UNION:{
      t = jj_consume_token(UNION);
      break;
      }
    case UUID:{
      t = jj_consume_token(UUID);
      break;
      }
    case VOID:{
      t = jj_consume_token(VOID);
      break;
      }
    case DATE:{
      t = jj_consume_token(DATE);
      break;
      }
    case TIME:{
      t = jj_consume_token(TIME);
      break;
      }
    case TIMESTAMP:{
      t = jj_consume_token(TIMESTAMP);
      break;
      }
    case LOCAL_TIMESTAMP:{
      t = jj_consume_token(LOCAL_TIMESTAMP);
      break;
      }
    case DECIMAL:{
      t = jj_consume_token(DECIMAL);
      break;
      }
    case BIG_DECIMAL:{
      t = jj_consume_token(BIG_DECIMAL);
      break;
      }
    case IDENTIFIER:{
      t = jj_consume_token(IDENTIFIER);
      break;
      }
    default:
      jj_la1[35] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new Error("Missing return statement in function");
}

  final private JsonNode Json() throws ParseException {String s; Token t; JsonNode n;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STRING_LITERAL:{
      s = JsonString();
n = new TextNode(s);
      break;
      }
    case INTEGER_LITERAL:{
      t = jj_consume_token(INTEGER_LITERAL);
long longValue = Long.parseLong(t.image);
  int intValue = (int)longValue;
  if (intValue == longValue)
    n = new IntNode(intValue);
  else
    n = new LongNode(longValue);
      break;
      }
    case FLOATING_POINT_LITERAL:{
      t = jj_consume_token(FLOATING_POINT_LITERAL);
n=new DoubleNode(Double.parseDouble(t.image));
      break;
      }
    case LBRACE:{
      n = JsonObject();
      break;
      }
    case LBRACK:{
      n = JsonArray();
      break;
      }
    case TRUE:{
      jj_consume_token(TRUE);
n = BooleanNode.TRUE;
      break;
      }
    case FALSE:{
      jj_consume_token(FALSE);
n = BooleanNode.FALSE;
      break;
      }
    case NULL:{
      jj_consume_token(NULL);
n = NullNode.instance;
      break;
      }
    default:
      jj_la1[36] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return n;}
    throw new Error("Missing return statement in function");
}

  final public String JsonString() throws ParseException {Token t;
    t = jj_consume_token(STRING_LITERAL);
String betweenQuotes = t.image.substring(1, t.image.length() - 1);
    {if ("" != null) return StringEscapeUtils.unescapeJava(betweenQuotes);}
    throw new Error("Missing return statement in function");
}

  final private JsonNode JsonObject() throws ParseException {ObjectNode o = FACTORY.objectNode();
    jj_consume_token(LBRACE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STRING_LITERAL:{
      JsonFields(o);
      break;
      }
    default:
      jj_la1[37] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
{if ("" != null) return o;}
    throw new Error("Missing return statement in function");
}

  final private void JsonFields(ObjectNode o) throws ParseException {
    JsonPair(o);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      JsonFields(o);
      break;
      }
    default:
      jj_la1[38] = jj_gen;
      ;
    }
}

  final private void JsonPair(ObjectNode o) throws ParseException {String name;
  JsonNode value;
    name = JsonString();
    jj_consume_token(COLON);
    value = Json();
o.set(name, value);
}

  final private JsonNode JsonArray() throws ParseException {ArrayNode a = FACTORY.arrayNode();
    jj_consume_token(LBRACK);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FALSE:
    case NULL:
    case TRUE:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case LBRACE:
    case LBRACK:{
      JsonElements(a);
      break;
      }
    default:
      jj_la1[39] = jj_gen;
      ;
    }
    jj_consume_token(RBRACK);
{if ("" != null) return a;}
    throw new Error("Missing return statement in function");
}

  final private void JsonElements(ArrayNode a) throws ParseException {JsonNode element;
    element = Json();
a.add(element);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      JsonElements(a);
      break;
      }
    default:
      jj_la1[40] = jj_gen;
      ;
    }
}

  /** Generated Token Manager. */
  public IdlTokenManager token_source;
  JavaCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[41];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x0,0x0,0x80058000,0x0,0x0,0x0,0x0,0x0,0xb5edf000,0x40100000,0x48100000,0x0,0xb5cdf000,0xb5edf000,0x80010000,0x35c87000,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x35c87000,0x0,0x1001000,0x35c87000,0x34c86000,0x0,0x0,0x34c86000,0x35c87000,0x0,0x0,0x0,0xfffff000,0x20020000,0x0,0x0,0x20020000,0x0,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x4007fc,0x0,0x0,0x0,0x4007fc,0x4007fc,0x0,0x4007f4,0x0,0x0,0x0,0x1,0x1,0x0,0x0,0x4007f4,0x0,0x4,0x4007f4,0x4007f0,0x0,0x0,0x7f0,0x4007fc,0x0,0x0,0x400000,0x4007ff,0x28208802,0x200000,0x0,0x28208802,0x0,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0x400,0x800,0x0,0x2,0x4,0x8,0x2,0x200,0x204,0x0,0x0,0x4,0x200,0x204,0x0,0x204,0x2,0x4,0x8,0x0,0x0,0x2,0x2,0x204,0x4,0x0,0x200,0x200,0x40,0x10,0x0,0x200,0x30,0x30,0x200,0x0,0x0,0x0,0x2,0x0,0x2,};
	}

  /** Constructor with InputStream. */
  public Idl(java.io.InputStream stream) {
	  this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public Idl(java.io.InputStream stream, String encoding) {
	 try { jj_input_stream = new JavaCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
	 token_source = new IdlTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 41; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
	  ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
	 try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 41; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public Idl(java.io.Reader stream) {
	 jj_input_stream = new JavaCharStream(stream, 1, 1);
	 token_source = new IdlTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 41; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new JavaCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new IdlTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 41; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public Idl(IdlTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 41; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(IdlTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 41; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[76];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 41; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		   if ((jj_la1_2[i] & (1<<j)) != 0) {
			 la1tokens[64+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 76; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage);
  }

  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
