/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.jdbc.core;

import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Period;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public enum ADBDatatype {
    TINYINT(1, "int8", JDBCType.TINYINT, Byte.class),
    SMALLINT(2, "int16", JDBCType.SMALLINT, Short.class),
    INTEGER(3, "int32", JDBCType.INTEGER, Integer.class),
    BIGINT(4, "int64", JDBCType.BIGINT, Long.class),
    FLOAT(11, "float", JDBCType.REAL, Float.class),
    DOUBLE(12, "double", JDBCType.DOUBLE, Double.class),
    STRING(13, "string", JDBCType.VARCHAR, String.class),
    MISSING(14, "missing", JDBCType.OTHER, Void.class),
    BOOLEAN(15, "boolean", JDBCType.BOOLEAN, Boolean.class),
    DATETIME(16, "datetime", JDBCType.TIMESTAMP, Timestamp.class),
    DATE(17, "date", JDBCType.DATE, Date.class),
    TIME(18, "time", JDBCType.TIME, Time.class),
    DURATION(19, "duration", JDBCType.OTHER, String.class),
    ARRAY(22, "array", JDBCType.OTHER, List.class),
    MULTISET(23, "multiset", JDBCType.OTHER, List.class),
    OBJECT(24, "object", JDBCType.OTHER, Map.class),
    ANY(29, "any", JDBCType.OTHER, String.class),
    YEARMONTHDURATION(36, "year-month-duration", JDBCType.OTHER, Period.class),
    DAYTIMEDURATION(37, "day-time-duration", JDBCType.OTHER, Duration.class),
    UUID(38, "uuid", JDBCType.OTHER, UUID.class),
    NULL(41, "null", JDBCType.NULL, Void.class);

    private static final ADBDatatype[] BY_TYPE_TAG;
    private static final Map<String, ADBDatatype> BY_TYPE_NAME;
    private final byte typeTag;
    private final String typeName;
    private final JDBCType jdbcType;
    private final Class<?> javaClass;

    private ADBDatatype(int typeTag, String typeName, JDBCType jdbcType, Class<?> javaClass) {
        this.typeTag = (byte)typeTag;
        this.typeName = Objects.requireNonNull(typeName);
        this.jdbcType = Objects.requireNonNull(jdbcType);
        this.javaClass = Objects.requireNonNull(javaClass);
    }

    public byte getTypeTag() {
        return this.typeTag;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public JDBCType getJdbcType() {
        return this.jdbcType;
    }

    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    public String toString() {
        return this.getTypeName();
    }

    public boolean isDerived() {
        return this == OBJECT || this.isList();
    }

    public boolean isList() {
        return this == ARRAY || this == MULTISET;
    }

    public boolean isNullOrMissing() {
        return this == NULL || this == MISSING;
    }

    public static ADBDatatype findByTypeTag(byte typeTag) {
        return typeTag >= 0 && typeTag < BY_TYPE_TAG.length ? BY_TYPE_TAG[typeTag] : null;
    }

    public static ADBDatatype findByTypeName(String typeName) {
        return BY_TYPE_NAME.get(typeName);
    }

    private static int findMaxTypeTag(ADBDatatype[] allTypes) {
        int maxTypeTag = 0;
        for (ADBDatatype type : allTypes) {
            if (type.typeTag < 0) {
                throw new IllegalStateException(type.getTypeName());
            }
            maxTypeTag = Math.max(type.typeTag, maxTypeTag);
        }
        return maxTypeTag;
    }

    public static String getDerivedRecordName(ADBDatatype type) {
        switch (type) {
            case OBJECT: {
                return "Record";
            }
            case ARRAY: {
                return "OrderedList";
            }
            case MULTISET: {
                return "UnorderedList";
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)type));
    }

    static {
        ADBDatatype[] allTypes = ADBDatatype.values();
        ADBDatatype[] byTypeTag = new ADBDatatype[ADBDatatype.findMaxTypeTag(allTypes) + 1];
        HashMap<String, ADBDatatype> byTypeName = new HashMap<String, ADBDatatype>();
        ADBDatatype[] aDBDatatypeArray = allTypes;
        int n = aDBDatatypeArray.length;
        for (int i = 0; i < n; ++i) {
            ADBDatatype t;
            byTypeTag[t.typeTag] = t = aDBDatatypeArray[i];
            byTypeName.put(t.typeName, t);
        }
        BY_TYPE_TAG = byTypeTag;
        BY_TYPE_NAME = byTypeName;
    }
}

