/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.resource;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.asterix.app.resource.PlanStage;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ForwardOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.MaterializeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SinkOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SwitchOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteOperator;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class PlanStagesGenerator
implements ILogicalOperatorVisitor<Void, Void> {
    private static final int JOIN_NON_BLOCKING_INPUT = 0;
    private static final int JOIN_BLOCKING_INPUT = 1;
    private static final int JOIN_NUM_INPUTS = 2;
    private static final int FORWARD_NON_BLOCKING_INPUT = 0;
    private static final int FORWARD_BLOCKING_INPUT = 1;
    private static final int FORWARD_NUM_INPUTS = 2;
    private final Set<ILogicalOperator> visitedOperators = new HashSet<ILogicalOperator>();
    private final LinkedList<ILogicalOperator> pendingMultiStageOperators = new LinkedList();
    private final List<PlanStage> stages = new ArrayList<PlanStage>();
    private PlanStage currentStage = new PlanStage(++this.stageCounter);
    private int stageCounter;

    public PlanStagesGenerator() {
        this.stages.add(this.currentStage);
    }

    public Void visitAggregateOperator(AggregateOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitRunningAggregateOperator(RunningAggregateOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitGroupByOperator(GroupByOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitLimitOperator(LimitOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitInnerJoinOperator(InnerJoinOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitLeftOuterJoinOperator(LeftOuterJoinOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitNestedTupleSourceOperator(NestedTupleSourceOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitOrderOperator(OrderOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitAssignOperator(AssignOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitSelectOperator(SelectOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitDelegateOperator(DelegateOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitProjectOperator(ProjectOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitReplicateOperator(ReplicateOperator op, Void arg) throws AlgebricksException {
        if (!this.visitedOperators.contains(op)) {
            this.visitedOperators.add((ILogicalOperator)op);
            this.visit((ILogicalOperator)op);
        } else {
            this.merge((ILogicalOperator)op);
        }
        return null;
    }

    public Void visitSplitOperator(SplitOperator op, Void arg) throws AlgebricksException {
        if (!this.visitedOperators.contains(op)) {
            this.visitedOperators.add((ILogicalOperator)op);
            this.visit((ILogicalOperator)op);
        } else {
            this.merge((ILogicalOperator)op);
        }
        return null;
    }

    public Void visitSwitchOperator(SwitchOperator op, Void arg) throws AlgebricksException {
        throw new NotImplementedException();
    }

    public Void visitMaterializeOperator(MaterializeOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitScriptOperator(ScriptOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitSubplanOperator(SubplanOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitSinkOperator(SinkOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitUnionOperator(UnionAllOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitIntersectOperator(IntersectOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitUnnestOperator(UnnestOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitLeftOuterUnnestOperator(LeftOuterUnnestOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitUnnestMapOperator(UnnestMapOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitDataScanOperator(DataSourceScanOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitDistinctOperator(DistinctOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitExchangeOperator(ExchangeOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitWriteOperator(WriteOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitDistributeResultOperator(DistributeResultOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitInsertDeleteUpsertOperator(InsertDeleteUpsertOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitIndexInsertDeleteUpsertOperator(IndexInsertDeleteUpsertOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitTokenizeOperator(TokenizeOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitForwardOperator(ForwardOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public Void visitWindowOperator(WindowOperator op, Void arg) throws AlgebricksException {
        this.visit((ILogicalOperator)op);
        return null;
    }

    public List<PlanStage> getStages() {
        return this.stages;
    }

    private void visit(ILogicalOperator op) throws AlgebricksException {
        this.addToStage(op);
        if (!this.pendingMultiStageOperators.isEmpty()) {
            ILogicalOperator firstPending = this.pendingMultiStageOperators.pop();
            this.visitMultiStageOp(firstPending);
        }
    }

    private void visitMultiStageOp(ILogicalOperator multiStageOp) throws AlgebricksException {
        PlanStage blockingOpStage = new PlanStage(++this.stageCounter);
        blockingOpStage.getOperators().add(multiStageOp);
        this.stages.add(blockingOpStage);
        this.currentStage = blockingOpStage;
        switch (multiStageOp.getOperatorTag()) {
            case INNERJOIN: 
            case LEFTOUTERJOIN: {
                ILogicalOperator newStageOperator = this.getInputAt(multiStageOp, 1, 2);
                newStageOperator.accept((ILogicalOperatorVisitor)this, null);
                break;
            }
            case GROUP: 
            case ORDER: {
                this.visitInputs(multiStageOp);
                break;
            }
            case FORWARD: {
                ILogicalOperator newStageOp = this.getInputAt(multiStageOp, 1, 2);
                newStageOp.accept((ILogicalOperatorVisitor)this, null);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized blocking operator: " + multiStageOp.getOperatorTag());
            }
        }
    }

    private void addToStage(ILogicalOperator op) throws AlgebricksException {
        this.currentStage.getOperators().add(op);
        switch (op.getOperatorTag()) {
            case INNERJOIN: 
            case LEFTOUTERJOIN: {
                this.pendingMultiStageOperators.add(op);
                ILogicalOperator joinNonBlockingInput = this.getInputAt(op, 0, 2);
                joinNonBlockingInput.accept((ILogicalOperatorVisitor)this, null);
                break;
            }
            case GROUP: {
                if (this.isBlockingGroupBy((GroupByOperator)op)) {
                    this.pendingMultiStageOperators.add(op);
                    return;
                }
                this.visitInputs(op);
                break;
            }
            case ORDER: {
                this.pendingMultiStageOperators.add(op);
                break;
            }
            case FORWARD: {
                this.pendingMultiStageOperators.add(op);
                ILogicalOperator nonBlockingInput = this.getInputAt(op, 0, 2);
                nonBlockingInput.accept((ILogicalOperatorVisitor)this, null);
                break;
            }
            default: {
                this.visitInputs(op);
            }
        }
    }

    private void visitInputs(ILogicalOperator op) throws AlgebricksException {
        if (this.isMaterialized(op)) {
            return;
        }
        for (Mutable inputOpRef : op.getInputs()) {
            ((ILogicalOperator)inputOpRef.getValue()).accept((ILogicalOperatorVisitor)this, null);
        }
    }

    private boolean isBlockingGroupBy(GroupByOperator op) {
        return op.getPhysicalOperator().getOperatorTag() == PhysicalOperatorTag.EXTERNAL_GROUP_BY || op.getPhysicalOperator().getOperatorTag() == PhysicalOperatorTag.SORT_GROUP_BY;
    }

    private boolean isMaterialized(ILogicalOperator op) {
        for (Mutable inputOpRef : op.getInputs()) {
            AbstractReplicateOperator replicateOperator;
            ILogicalOperator inputOp = (ILogicalOperator)inputOpRef.getValue();
            LogicalOperatorTag inputOpTag = inputOp.getOperatorTag();
            if (inputOpTag != LogicalOperatorTag.REPLICATE && inputOpTag != LogicalOperatorTag.SPLIT || !(replicateOperator = (AbstractReplicateOperator)inputOp).isMaterialized(op)) continue;
            return true;
        }
        return false;
    }

    private ILogicalOperator getInputAt(ILogicalOperator op, int inputIndex, int numInputs) {
        List inputs = op.getInputs();
        int inSize = inputs.size();
        if (inSize != numInputs) {
            throw new IllegalStateException("Op must have exactly " + numInputs + " inputs. Current inputs: " + inSize);
        }
        if (inputIndex >= inSize) {
            throw new IllegalArgumentException("invalid input index for operator");
        }
        return (ILogicalOperator)((Mutable)inputs.get(inputIndex)).getValue();
    }

    private void merge(ILogicalOperator op) {
        for (PlanStage stage : this.stages) {
            if (stage == this.currentStage || !stage.getOperators().contains(op)) continue;
            stage.getOperators().addAll(this.currentStage.getOperators());
            this.stages.remove(this.currentStage);
            this.currentStage = stage;
            break;
        }
    }
}

