/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.message;

import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.context.IndexInfo;
import org.apache.asterix.common.messaging.api.INcAddressedMessage;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobId;

public class EnableMergeMessage
implements INcAddressedMessage {
    private static final long serialVersionUID = 1L;
    private final JobId jobId;
    private final int datasetId;

    public EnableMergeMessage(JobId jobId, int datasetId) {
        this.jobId = jobId;
        this.datasetId = datasetId;
    }

    public void handle(INcApplicationContext appCtx) throws HyracksDataException, InterruptedException {
        IDatasetLifecycleManager datasetLifecycleManager = appCtx.getDatasetLifecycleManager();
        for (IndexInfo indexInfo : datasetLifecycleManager.getDatasetInfo(this.datasetId).getIndexes().values()) {
            if (!indexInfo.getIndex().isPrimaryIndex()) continue;
            indexInfo.getIndex().getMergePolicy().diskComponentAdded(indexInfo.getIndex(), false);
        }
    }

    public String toString() {
        return "EnableMergeMessage{jobId=" + this.jobId + ", datasetId=" + this.datasetId + "}";
    }
}

