/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.lazy;

import org.apache.asterix.om.lazy.AbstractLazyVisitablePointable;
import org.apache.asterix.om.lazy.FlatLazyVisitablePointable;
import org.apache.asterix.om.lazy.ILazyVisitablePointableVisitor;
import org.apache.asterix.om.lazy.RecordLazyVisitablePointable;
import org.apache.asterix.om.lazy.VariableListLazyVisitablePointable;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class GenericLazyVisitablePointable
extends AbstractLazyVisitablePointable {
    private RecordLazyVisitablePointable object;
    private VariableListLazyVisitablePointable array;
    private VariableListLazyVisitablePointable multiset;
    private FlatLazyVisitablePointable flat;
    private AbstractLazyVisitablePointable current;

    public GenericLazyVisitablePointable() {
        super(true);
    }

    @Override
    public final byte getSerializedTypeTag() {
        return this.current.getSerializedTypeTag();
    }

    @Override
    public final ATypeTag getTypeTag() {
        return this.current.getTypeTag();
    }

    @Override
    public <R, T> R accept(ILazyVisitablePointableVisitor<R, T> visitor, T arg) throws HyracksDataException {
        switch (this.current.getTypeTag()) {
            case OBJECT: {
                return visitor.visit(this.object, arg);
            }
            case ARRAY: {
                return visitor.visit(this.array, arg);
            }
            case MULTISET: {
                return visitor.visit(this.multiset, arg);
            }
        }
        return visitor.visit(this.flat, arg);
    }

    @Override
    void init(byte[] data, int offset, int length) {
        ATypeTag typeTag = ATypeTag.VALUE_TYPE_MAPPING[data[offset]];
        AbstractLazyVisitablePointable visitable = this.getOrCreateVisitablePointable(typeTag);
        visitable.set(data, offset, length);
        this.current = visitable;
    }

    private AbstractLazyVisitablePointable getOrCreateVisitablePointable(ATypeTag typeTag) {
        switch (typeTag) {
            case OBJECT: {
                this.object = this.object == null ? new RecordLazyVisitablePointable(true) : this.object;
                return this.object;
            }
            case ARRAY: {
                this.array = this.array == null ? new VariableListLazyVisitablePointable(true, DefaultOpenFieldType.NESTED_OPEN_AORDERED_LIST_TYPE) : this.array;
                return this.array;
            }
            case MULTISET: {
                this.multiset = this.multiset == null ? new VariableListLazyVisitablePointable(true, DefaultOpenFieldType.NESTED_OPEN_AUNORDERED_LIST_TYPE) : this.multiset;
                return this.multiset;
            }
        }
        this.flat = this.flat == null ? new FlatLazyVisitablePointable(true, ATypeTag.ANY) : this.flat;
        return this.flat;
    }
}

