/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl.filter;

import org.apache.orc.OrcFilterContext;
import org.apache.orc.impl.filter.Selected;
import org.apache.orc.impl.filter.VectorFilter;
import org.apache.orc.storage.ql.exec.vector.ColumnVector;

public class IsNotNullFilter
implements VectorFilter {
    private final String colName;

    public IsNotNullFilter(String colName) {
        this.colName = colName;
    }

    @Override
    public void filter(OrcFilterContext fc, Selected bound, Selected selOut) {
        ColumnVector[] branch = fc.findColumnVector(this.colName);
        ColumnVector v = branch[branch.length - 1];
        boolean noNulls = OrcFilterContext.noNulls(branch);
        if (noNulls || v.isRepeating && !OrcFilterContext.isNull(branch, 0)) {
            selOut.selectAll(bound);
        } else if (!v.isRepeating) {
            int currSize = 0;
            for (int i = 0; i < bound.selSize; ++i) {
                int rowIdx = bound.sel[i];
                if (OrcFilterContext.isNull(branch, rowIdx)) continue;
                selOut.sel[currSize++] = rowIdx;
            }
            selOut.selSize = currSize;
        }
    }
}

