/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DotFormatBuilder {
    private final StringBuilder stringBuilder;
    private final Set<Node> nodes;
    private final List<Edge> edges = new ArrayList<Edge>();

    public DotFormatBuilder(StringValue graphName) {
        this.nodes = new HashSet<Node>();
        this.stringBuilder = new StringBuilder();
        this.stringBuilder.append("digraph ").append(graphName).append(" {\n").append("rankdir=BT;\n");
        this.stringBuilder.append("node [style=\"rounded,filled\",shape=box];\n");
    }

    public String getDotDocument() {
        for (Edge edge : this.edges) {
            this.stringBuilder.append(edge);
        }
        for (Node node : this.nodes) {
            this.stringBuilder.append(node);
        }
        this.stringBuilder.append("\n}");
        return this.stringBuilder.toString();
    }

    public Node createNode(StringValue nodeId, StringValue nodeLabel) {
        Node node = new Node(nodeId, nodeLabel);
        for (Node existingNode : this.nodes) {
            if (!node.equals(existingNode)) continue;
            existingNode.setNodeLabel(nodeLabel);
            return existingNode;
        }
        this.nodes.add(node);
        return node;
    }

    public Edge createEdge(Node source, Node destination) {
        if (source == null || destination == null || !this.nodes.contains(source) || !this.nodes.contains(destination)) {
            return null;
        }
        Edge newEdge = new Edge(source, destination);
        this.edges.add(newEdge);
        return newEdge;
    }

    public class Edge {
        private final Node source;
        private final Node destination;
        private final HashMap<String, AttributeValue> attributes = new HashMap();

        private Edge(Node source, Node destination) {
            this.source = source;
            this.destination = destination;
        }

        public Edge setLabel(StringValue edgeLabel) {
            if (edgeLabel != null) {
                this.attributes.put("label", edgeLabel);
            }
            return this;
        }

        public Edge setColor(Color color) {
            if (color != null) {
                this.attributes.put("color", color);
            }
            return this;
        }

        public Edge setDashed() {
            this.attributes.put("style", Style.DASHED);
            return this;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Edge)) {
                return false;
            }
            Edge otherEdge = (Edge)other;
            return this.source.equals(otherEdge.source) && this.destination.equals(otherEdge.destination);
        }

        public int hashCode() {
            return this.source.hashCode() ^ this.destination.hashCode();
        }

        public String toString() {
            StringBuilder edgeString = new StringBuilder();
            edgeString.append(this.source.getNodeId()).append("->").append(this.destination.getNodeId()).append(" [");
            this.attributes.forEach((key, value) -> edgeString.append((String)key).append("=").append(value).append(","));
            if (edgeString.charAt(edgeString.length() - 1) == ',') {
                edgeString.deleteCharAt(edgeString.length() - 1);
            }
            edgeString.append("];\n");
            return edgeString.toString();
        }
    }

    public class Node {
        private final StringValue nodeId;
        private HashMap<String, AttributeValue> attributes = new HashMap();

        private Node(StringValue nodeId, StringValue nodeLabel) {
            this.nodeId = nodeId;
            this.setNodeLabel(nodeLabel);
        }

        public StringValue getNodeId() {
            return this.nodeId;
        }

        public AttributeValue getNodeLabel() {
            return this.attributes.get("label");
        }

        public Node setNodeLabel(StringValue nodeLabel) {
            if (nodeLabel != null) {
                this.attributes.put("label", nodeLabel);
            }
            return this;
        }

        public Node setFillColor(Color color) {
            if (color != null) {
                this.attributes.put("color", color);
            }
            return this;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Node)) {
                return false;
            }
            Node otherNode = (Node)other;
            return this.nodeId.getValue().equals(otherNode.nodeId.getValue());
        }

        public int hashCode() {
            return this.nodeId.getValue().hashCode();
        }

        public String toString() {
            StringBuilder nodeString = new StringBuilder();
            nodeString.append(this.nodeId).append(" [");
            this.attributes.forEach((key, value) -> nodeString.append((String)key).append("=").append(value).append(","));
            if (nodeString.charAt(nodeString.length() - 1) == ',') {
                nodeString.deleteCharAt(nodeString.length() - 1);
            }
            nodeString.append("];\n");
            return nodeString.toString();
        }
    }

    public static final class StringValue
    extends AttributeValue {
        private StringValue(String value) {
            super(value);
        }

        public static StringValue of(String value) {
            String newValue = value;
            if (value == null) {
                newValue = "";
            }
            newValue = newValue.replace("\n", "\\n");
            return new StringValue("\"" + newValue.replace("\"", "'").trim() + "\"");
        }
    }

    private static final class Attribute {
        private static final String COLOR = "color";
        private static final String LABEL = "label";
        private static final String STYLE = "style";

        private Attribute() {
        }
    }

    public static final class Style
    extends AttributeValue {
        public static final Style DASHED = new Style("dashed");

        private Style(String style) {
            super(style);
        }
    }

    public static final class Color
    extends AttributeValue {
        public static final Color RED = new Color("red");
        public static final Color SKYBLUE = new Color("skyblue");
        public static final Color BLUE = new Color("blue");

        private Color(String color) {
            super(color);
        }
    }

    public static abstract class AttributeValue {
        private final String value;

        private AttributeValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

