/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.util.Set;
import org.apache.asterix.common.cluster.PartitioningProperties;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.SecondaryIndexOperationsHelper;
import org.apache.asterix.runtime.utils.RuntimeUtils;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraintHelper;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.jobgen.impl.ConnectorPolicyAssignmentPolicy;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.connectors.IConnectorPolicyAssignmentPolicy;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.storage.am.common.api.IIndexBuilderFactory;
import org.apache.hyracks.storage.am.common.build.IndexBuilderFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexCreateOperatorDescriptor;
import org.apache.hyracks.storage.am.common.dataflow.IndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexDropOperatorDescriptor;
import org.apache.hyracks.storage.am.lsm.common.dataflow.LSMTreeIndexCompactOperatorDescriptor;

public abstract class SecondaryTreeIndexOperationsHelper
extends SecondaryIndexOperationsHelper {
    protected SecondaryTreeIndexOperationsHelper(Dataset dataset, Index index, MetadataProvider metadataProvider, SourceLocation sourceLoc) throws AlgebricksException {
        super(dataset, index, metadataProvider, sourceLoc);
    }

    @Override
    public JobSpecification buildCreationJobSpec() throws AlgebricksException {
        JobSpecification spec = RuntimeUtils.createJobSpecification((ICcApplicationContext)this.metadataProvider.getApplicationContext());
        PartitioningProperties partitioningProperties = this.metadataProvider.getPartitioningProperties(this.dataset);
        int[][] computeStorageMap = partitioningProperties.getComputeStorageMap();
        IndexBuilderFactory[][] indexBuilderFactories = DatasetUtil.getIndexBuilderFactories(this.dataset, this.metadataProvider, this.index, this.itemType, this.metaType, this.secondaryFileSplitProvider, this.mergePolicyFactory, this.mergePolicyProperties, computeStorageMap);
        IndexCreateOperatorDescriptor secondaryIndexCreateOp = new IndexCreateOperatorDescriptor((IOperatorDescriptorRegistry)spec, (IIndexBuilderFactory[][])indexBuilderFactories, computeStorageMap);
        secondaryIndexCreateOp.setSourceLocation(this.sourceLoc);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)secondaryIndexCreateOp, (AlgebricksPartitionConstraint)this.secondaryPartitionConstraint);
        spec.addRoot((IOperatorDescriptor)secondaryIndexCreateOp);
        spec.setConnectorPolicyAssignmentPolicy((IConnectorPolicyAssignmentPolicy)new ConnectorPolicyAssignmentPolicy());
        return spec;
    }

    @Override
    public JobSpecification buildDropJobSpec(Set<IndexDropOperatorDescriptor.DropOption> options) throws AlgebricksException {
        return SecondaryTreeIndexOperationsHelper.buildDropJobSpecImpl(this.dataset, this.index, options, this.metadataProvider, this.sourceLoc);
    }

    static JobSpecification buildDropJobSpecImpl(Dataset dataset, Index index, Set<IndexDropOperatorDescriptor.DropOption> dropOptions, MetadataProvider metadataProvider, SourceLocation sourceLoc) throws AlgebricksException {
        JobSpecification spec = RuntimeUtils.createJobSpecification((ICcApplicationContext)metadataProvider.getApplicationContext());
        PartitioningProperties partitioningProperties = metadataProvider.getPartitioningProperties(dataset, index.getIndexName());
        IndexDataflowHelperFactory dataflowHelperFactory = new IndexDataflowHelperFactory(metadataProvider.getStorageComponentProvider().getStorageManager(), partitioningProperties.getSplitsProvider());
        IndexDropOperatorDescriptor btreeDrop = new IndexDropOperatorDescriptor((IOperatorDescriptorRegistry)spec, (IIndexDataflowHelperFactory)dataflowHelperFactory, dropOptions, partitioningProperties.getComputeStorageMap());
        btreeDrop.setSourceLocation(sourceLoc);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)btreeDrop, (AlgebricksPartitionConstraint)partitioningProperties.getConstraints());
        spec.addRoot((IOperatorDescriptor)btreeDrop);
        return spec;
    }

    @Override
    public JobSpecification buildCompactJobSpec() throws AlgebricksException {
        JobSpecification spec = RuntimeUtils.createJobSpecification((ICcApplicationContext)this.metadataProvider.getApplicationContext());
        PartitioningProperties partitioningProperties = this.metadataProvider.getPartitioningProperties(this.dataset, this.index.getIndexName());
        IndexDataflowHelperFactory dataflowHelperFactory = new IndexDataflowHelperFactory(this.metadataProvider.getStorageComponentProvider().getStorageManager(), partitioningProperties.getSplitsProvider());
        LSMTreeIndexCompactOperatorDescriptor compactOp = new LSMTreeIndexCompactOperatorDescriptor((IOperatorDescriptorRegistry)spec, (IIndexDataflowHelperFactory)dataflowHelperFactory, partitioningProperties.getComputeStorageMap());
        compactOp.setSourceLocation(this.sourceLoc);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)compactOp, (AlgebricksPartitionConstraint)this.secondaryPartitionConstraint);
        spec.addRoot((IOperatorDescriptor)compactOp);
        spec.setConnectorPolicyAssignmentPolicy((IConnectorPolicyAssignmentPolicy)new ConnectorPolicyAssignmentPolicy());
        return spec;
    }

    protected int[] createPkFieldPermutationForBulkLoadOp(int[] fieldsPermutation, int numSecondaryKeyFields) {
        int[] pkFieldPermutation = new int[this.numPrimaryKeys];
        for (int i = 0; i < pkFieldPermutation.length; ++i) {
            pkFieldPermutation[i] = fieldsPermutation[numSecondaryKeyFields + i];
        }
        return pkFieldPermutation;
    }
}

