/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.util.Calendar;
import org.apache.asterix.metadata.bootstrap.DatabaseEntity;
import org.apache.asterix.metadata.entities.Database;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class DatabaseTupleTranslator
extends AbstractTupleTranslator<Database> {
    private final DatabaseEntity databaseEntity;
    private AMutableInt32 aInt32;

    protected DatabaseTupleTranslator(boolean getTuple, DatabaseEntity databaseEntity) {
        super(getTuple, databaseEntity.getIndex(), databaseEntity.payloadPosition());
        this.databaseEntity = databaseEntity;
        if (getTuple) {
            this.aInt32 = new AMutableInt32(-1);
        }
    }

    @Override
    protected Database createMetadataEntityFromARecord(ARecord databaseRecord) throws AlgebricksException {
        String databaseName = ((AString)databaseRecord.getValueByPos(this.databaseEntity.databaseNameIndex())).getStringValue();
        boolean isSystemDatabase = ((ABoolean)databaseRecord.getValueByPos(this.databaseEntity.systemDatabaseIndex())).getBoolean();
        int pendingOp = ((AInt32)databaseRecord.getValueByPos(this.databaseEntity.pendingOpIndex())).getIntegerValue();
        return new Database(databaseName, isSystemDatabase, pendingOp);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(Database database) throws HyracksDataException {
        this.tupleBuilder.reset();
        this.aString.setValue(database.getDatabaseName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(this.databaseEntity.getRecordType());
        this.fieldValue.reset();
        this.aString.setValue(database.getDatabaseName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.databaseEntity.databaseNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.booleanSerde.serialize((Object)(database.isSystemDatabase() ? ABoolean.TRUE : ABoolean.FALSE), this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.databaseEntity.systemDatabaseIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(Calendar.getInstance().getTime().toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.databaseEntity.timestampIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aInt32.setValue(database.getPendingOp());
        this.int32Serde.serialize((Object)this.aInt32, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.databaseEntity.pendingOpIndex(), (IValueReference)this.fieldValue);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }
}

