/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.declared;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.MetadataConstants;
import org.apache.asterix.common.utils.IdentifierUtil;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.DatasetDataSource;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.entities.FullTextConfigMetadataEntity;
import org.apache.asterix.metadata.entities.FullTextFilterMetadataEntity;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.entities.NodeGroup;
import org.apache.asterix.metadata.entities.Synonym;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.ProjectionFiltrationTypeUtil;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.properties.DefaultNodeGroupDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;

public class MetadataManagerUtil {
    private MetadataManagerUtil() {
        throw new AssertionError((Object)"This util class should not be initialized.");
    }

    public static IAType findType(MetadataTransactionContext mdTxnCtx, String database, DataverseName dataverseName, String typeName) throws AlgebricksException {
        Datatype type = MetadataManagerUtil.findTypeEntity(mdTxnCtx, database, dataverseName, typeName);
        return type != null ? type.getDatatype() : null;
    }

    public static IAType findTypeForDatasetWithoutType(IAType itemType, IAType metaItemType, Dataset dataset) throws AlgebricksException {
        InternalDatasetDetails dsDetails;
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL && (dsDetails = (InternalDatasetDetails)dataset.getDatasetDetails()).isDatasetWithoutTypeSpecification()) {
            return MetadataManagerUtil.findType(dsDetails.getPrimaryKey(), dsDetails.getPrimaryKeyType());
        }
        return itemType;
    }

    private static IAType findType(List<List<String>> primaryKeys, List<IAType> primaryKeyTypes) throws AlgebricksException {
        return ProjectionFiltrationTypeUtil.getRecordTypeWithFieldTypes(primaryKeys, primaryKeyTypes);
    }

    public static Datatype findTypeEntity(MetadataTransactionContext mdTxnCtx, String database, DataverseName dataverseName, String typeName) throws AlgebricksException {
        if (database == null || dataverseName == null || typeName == null) {
            return null;
        }
        Datatype type = MetadataManager.INSTANCE.getDatatype(mdTxnCtx, database, dataverseName, typeName);
        if (type == null) {
            throw new AsterixException(ErrorCode.UNKNOWN_TYPE, new Serializable[]{dataverseName + "." + typeName});
        }
        return type;
    }

    public static ARecordType findOutputRecordType(MetadataTransactionContext mdTxnCtx, String database, DataverseName dataverseName, String outputRecordType) throws AlgebricksException {
        if (outputRecordType == null) {
            return null;
        }
        if (database == null) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, new Serializable[]{"Cannot declare output-record-type with no database"});
        }
        if (dataverseName == null) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, new Serializable[]{"Cannot declare output-record-type with no " + IdentifierUtil.dataverse()});
        }
        IAType type = MetadataManagerUtil.findType(mdTxnCtx, database, dataverseName, outputRecordType);
        if (!(type instanceof ARecordType)) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, new Serializable[]{"Type " + outputRecordType + " is not a record type!"});
        }
        return (ARecordType)type;
    }

    public static DatasourceAdapter getAdapter(MetadataTransactionContext mdTxnCtx, String database, DataverseName dataverseName, String adapterName) throws AlgebricksException {
        DatasourceAdapter adapter = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, "System", MetadataConstants.METADATA_DATAVERSE_NAME, adapterName);
        if (adapter == null) {
            adapter = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, database, dataverseName, adapterName);
        }
        return adapter;
    }

    public static Dataset findDataset(MetadataTransactionContext mdTxnCtx, String database, DataverseName dataverseName, String datasetName, boolean includingViews) throws AlgebricksException {
        Dataset dataset = MetadataManager.INSTANCE.getDataset(mdTxnCtx, database, dataverseName, datasetName);
        if (!includingViews && dataset != null && dataset.getDatasetType() == DatasetConfig.DatasetType.VIEW) {
            return null;
        }
        return dataset;
    }

    public static Dataset findDataset(MetadataTransactionContext mdTxnCtx, String database, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        return MetadataManagerUtil.findDataset(mdTxnCtx, database, dataverseName, datasetName, false);
    }

    public static Dataset findExistingDataset(MetadataTransactionContext mdTxnCtx, String database, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        Dataset dataset = MetadataManagerUtil.findDataset(mdTxnCtx, database, dataverseName, datasetName);
        if (dataset == null) {
            throw new AsterixException(ErrorCode.UNKNOWN_DATASET_IN_DATAVERSE, new Serializable[]{datasetName, dataverseName});
        }
        return dataset;
    }

    public static INodeDomain findNodeDomain(IClusterStateManager clusterStateManager, MetadataTransactionContext mdTxnCtx, String nodeGroupName) throws AlgebricksException {
        NodeGroup nodeGroup = MetadataManager.INSTANCE.getNodegroup(mdTxnCtx, nodeGroupName);
        ArrayList<String> partitions = new ArrayList<String>();
        for (String location : nodeGroup.getNodeNames()) {
            int numPartitions = clusterStateManager.getNodePartitionsCount(location);
            for (int i = 0; i < numPartitions; ++i) {
                partitions.add(location);
            }
        }
        return new DefaultNodeGroupDomain(partitions);
    }

    public static List<String> findNodes(MetadataTransactionContext mdTxnCtx, String nodeGroupName) throws AlgebricksException {
        return MetadataManager.INSTANCE.getNodegroup(mdTxnCtx, nodeGroupName).getNodeNames();
    }

    public static Feed findFeed(MetadataTransactionContext mdTxnCtx, String database, DataverseName dataverseName, String feedName) throws AlgebricksException {
        return MetadataManager.INSTANCE.getFeed(mdTxnCtx, database, dataverseName, feedName);
    }

    public static FeedConnection findFeedConnection(MetadataTransactionContext mdTxnCtx, String database, DataverseName dataverseName, String feedName, String datasetName) throws AlgebricksException {
        return MetadataManager.INSTANCE.getFeedConnection(mdTxnCtx, database, dataverseName, feedName, datasetName);
    }

    public static FeedPolicyEntity findFeedPolicy(MetadataTransactionContext mdTxnCtx, String database, DataverseName dataverseName, String policyName) throws AlgebricksException {
        return MetadataManager.INSTANCE.getFeedPolicy(mdTxnCtx, database, dataverseName, policyName);
    }

    public static Synonym findSynonym(MetadataTransactionContext mdTxnCtx, String database, DataverseName dataverseName, String synonymName) throws AlgebricksException {
        return MetadataManager.INSTANCE.getSynonym(mdTxnCtx, database, dataverseName, synonymName);
    }

    public static FullTextConfigMetadataEntity findFullTextConfigDescriptor(MetadataTransactionContext mdTxnCtx, String database, DataverseName dataverseName, String ftConfigName) throws AlgebricksException {
        if (Strings.isNullOrEmpty((String)ftConfigName)) {
            return FullTextConfigMetadataEntity.getDefaultFullTextConfigMetadataEntity();
        }
        return MetadataManager.INSTANCE.getFullTextConfig(mdTxnCtx, database, dataverseName, ftConfigName);
    }

    public static FullTextFilterMetadataEntity findFullTextFilterDescriptor(MetadataTransactionContext mdTxnCtx, String database, DataverseName dataverseName, String ftFilterName) throws AlgebricksException {
        return MetadataManager.INSTANCE.getFullTextFilter(mdTxnCtx, database, dataverseName, ftFilterName);
    }

    public static List<Index> getDatasetIndexes(MetadataTransactionContext mdTxnCtx, String database, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        return MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, database, dataverseName, datasetName);
    }

    public static DataSource findDataSource(IClusterStateManager clusterStateManager, MetadataTransactionContext mdTxnCtx, DataSourceId id) throws AlgebricksException {
        return MetadataManagerUtil.lookupSourceInMetadata(clusterStateManager, mdTxnCtx, id);
    }

    public static DataSource lookupSourceInMetadata(IClusterStateManager clusterStateManager, MetadataTransactionContext mdTxnCtx, DataSourceId id) throws AlgebricksException {
        byte datasourceType;
        Dataset dataset = MetadataManagerUtil.findDataset(mdTxnCtx, id.getDatabaseName(), id.getDataverseName(), id.getDatasourceName());
        if (dataset == null) {
            throw new AsterixException(ErrorCode.UNKNOWN_DATASET_IN_DATAVERSE, new Serializable[]{id.getDatasourceName(), id.getDataverseName()});
        }
        switch (dataset.getDatasetType()) {
            case INTERNAL: {
                datasourceType = 0;
                break;
            }
            case EXTERNAL: {
                datasourceType = 1;
                break;
            }
            default: {
                throw new AsterixException(ErrorCode.UNKNOWN_DATASET_IN_DATAVERSE, new Serializable[]{id.getDatasourceName(), id.getDataverseName()});
            }
        }
        IAType itemType = MetadataManagerUtil.findType(mdTxnCtx, dataset.getItemTypeDatabaseName(), dataset.getItemTypeDataverseName(), dataset.getItemTypeName());
        IAType metaItemType = MetadataManagerUtil.findType(mdTxnCtx, dataset.getMetaItemTypeDatabaseName(), dataset.getMetaItemTypeDataverseName(), dataset.getMetaItemTypeName());
        itemType = MetadataManagerUtil.findTypeForDatasetWithoutType(itemType, metaItemType, dataset);
        INodeDomain domain = MetadataManagerUtil.findNodeDomain(clusterStateManager, mdTxnCtx, dataset.getNodeGroupName());
        return new DatasetDataSource(id, dataset, itemType, metaItemType, datasourceType, dataset.getDatasetDetails(), domain);
    }
}

