/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.messaging;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.exceptions.ReplicationException;
import org.apache.asterix.common.storage.IIndexCheckpointManager;
import org.apache.asterix.common.storage.IIndexCheckpointManagerProvider;
import org.apache.asterix.common.storage.ResourceReference;
import org.apache.asterix.replication.api.IReplicaTask;
import org.apache.asterix.replication.api.IReplicationWorker;
import org.apache.asterix.replication.management.NetworkingUtil;
import org.apache.asterix.replication.messaging.ReplicationProtocol;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IFileHandle;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.control.nc.io.FileHandle;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplicateFileTask
implements IReplicaTask {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String file;
    private final long size;
    private final boolean indexMetadata;
    private final String masterNodeId;

    public ReplicateFileTask(String file, long size, boolean indexMetadata, String masterNodeId) {
        this.file = file;
        this.size = size;
        this.indexMetadata = indexMetadata;
        this.masterNodeId = masterNodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(INcApplicationContext appCtx, IReplicationWorker worker) {
        try {
            LOGGER.debug("attempting to receive file {} from master", (Object)this);
            IIOManager ioManager = appCtx.getIoManager();
            FileReference localPath = ioManager.resolve(this.file);
            FileReference resourceDir = localPath.getParent();
            ioManager.makeDirectories(resourceDir);
            if (this.indexMetadata) {
                ioManager.cleanDirectory(resourceDir);
                ((PersistentLocalResourceRepository)appCtx.getLocalResourceRepository()).invalidateResource(ResourceReference.of((String)this.file).getRelativePath().toString());
            }
            FileReference maskPath = resourceDir.getChild(".mask_" + localPath.getName());
            ioManager.create(maskPath);
            ioManager.create(localPath);
            FileHandle fileHandle = (FileHandle)ioManager.open(localPath, IIOManager.FileReadWriteMode.READ_WRITE, IIOManager.FileSyncMode.METADATA_ASYNC_DATA_ASYNC);
            try (FileChannel fileChannel = fileHandle.getFileChannel();){
                fileHandle.setLength(this.size);
                NetworkingUtil.downloadFile(fileChannel, worker.getChannel());
                ioManager.sync((IFileHandle)fileHandle, true);
            }
            finally {
                ioManager.close((IFileHandle)fileHandle);
            }
            if (this.indexMetadata) {
                this.initIndexCheckpoint(appCtx);
            }
            ioManager.delete(maskPath);
            LOGGER.debug("received file {} from master", (Object)localPath);
            ReplicationProtocol.sendAck(worker.getChannel(), worker.getReusableBuffer());
        }
        catch (IOException e) {
            throw new ReplicationException((Throwable)e);
        }
    }

    private void initIndexCheckpoint(INcApplicationContext appCtx) throws HyracksDataException {
        ResourceReference indexRef = ResourceReference.of((String)this.file);
        IIndexCheckpointManagerProvider checkpointManagerProvider = appCtx.getIndexCheckpointManagerProvider();
        IIndexCheckpointManager indexCheckpointManager = checkpointManagerProvider.get(indexRef);
        long currentLSN = appCtx.getTransactionSubsystem().getLogManager().getAppendLSN();
        indexCheckpointManager.delete();
        indexCheckpointManager.init(-1L, currentLSN, LSMComponentId.EMPTY_INDEX_LAST_COMPONENT_ID.getMaxId(), this.masterNodeId);
        LOGGER.info(() -> "Checkpoint index: " + indexRef);
    }

    @Override
    public ReplicationProtocol.ReplicationRequestType getMessageType() {
        return ReplicationProtocol.ReplicationRequestType.REPLICATE_RESOURCE_FILE;
    }

    @Override
    public void serialize(OutputStream out) throws HyracksDataException {
        try {
            DataOutputStream dos = new DataOutputStream(out);
            dos.writeUTF(this.file);
            dos.writeLong(this.size);
            dos.writeBoolean(this.indexMetadata);
            boolean hasMaster = this.masterNodeId != null;
            dos.writeBoolean(hasMaster);
            if (hasMaster) {
                dos.writeUTF(this.masterNodeId);
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static ReplicateFileTask create(DataInput input) throws IOException {
        String s = input.readUTF();
        long i = input.readLong();
        boolean isMetadata = input.readBoolean();
        boolean hasMaster = input.readBoolean();
        String masterNodeId = hasMaster ? input.readUTF() : null;
        return new ReplicateFileTask(s, i, isMetadata, masterNodeId);
    }

    public String toString() {
        return "ReplicateFileTask{file='" + this.file + "', size=" + this.size + ", indexMetadata=" + this.indexMetadata + "}";
    }
}

