/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.common.IIndexAccessParameters;

public class ConstantMergePolicy
implements ILSMMergePolicy {
    private int numComponents;
    private int[][] binomial;

    @Override
    public void diskComponentAdded(ILSMIndex index, boolean fullMergeIsRequested) throws HyracksDataException {
        ArrayList<ILSMDiskComponent> immutableComponents = new ArrayList<ILSMDiskComponent>(index.getDiskComponents());
        if (!this.areComponentsReadableWritableState(immutableComponents)) {
            return;
        }
        if (fullMergeIsRequested) {
            ILSMIndexAccessor accessor = index.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
            accessor.scheduleFullMerge();
            return;
        }
        this.scheduleMerge(index);
    }

    private boolean scheduleMerge(ILSMIndex index) throws HyracksDataException {
        Optional<Long> latestSeq = ((AbstractLSMIndex)index).getLatestDiskComponentSequence();
        if (!latestSeq.isPresent()) {
            return false;
        }
        int numFlushes = latestSeq.get().intValue() + 1;
        ArrayList<ILSMDiskComponent> immutableComponents = new ArrayList<ILSMDiskComponent>(index.getDiskComponents());
        Collections.reverse(immutableComponents);
        int size = immutableComponents.size();
        int depth = 0;
        while (this.treeDepth(depth) < numFlushes) {
            ++depth;
        }
        int mergedIndex = this.binomialIndex(depth, Math.min(depth, this.numComponents) - 1, numFlushes - this.treeDepth(depth - 1) - 1);
        if (mergedIndex == size - 1) {
            return false;
        }
        long mergeSize = 0L;
        ArrayList<ILSMDiskComponent> mergableComponents = new ArrayList<ILSMDiskComponent>();
        for (int i = mergedIndex; i < immutableComponents.size(); ++i) {
            mergeSize += ((ILSMDiskComponent)immutableComponents.get(i)).getComponentSize();
            mergableComponents.add((ILSMDiskComponent)immutableComponents.get(i));
        }
        Collections.reverse(mergableComponents);
        ILSMIndexAccessor accessor = index.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
        accessor.scheduleMerge(mergableComponents);
        return true;
    }

    private int treeDepth(int d) {
        if (d < 0) {
            return 0;
        }
        return this.treeDepth(d - 1) + this.binomialChoose(d + Math.min(d, this.numComponents) - 1, d);
    }

    private int binomialIndex(int d, int h, int t) {
        if (t < 0 || t > this.binomialChoose(d + h, h)) {
            throw new IllegalStateException("Illegal binomial values");
        }
        if (t == 0) {
            return 0;
        }
        if (t < this.binomialChoose(d + h - 1, h)) {
            return this.binomialIndex(d - 1, h, t);
        }
        return this.binomialIndex(d, h - 1, t - this.binomialChoose(d + h - 1, h)) + 1;
    }

    private int binomialChoose(int n, int k) {
        if (k < 0 || k > n) {
            return 0;
        }
        if (k == 0 || k == n) {
            return 1;
        }
        if (this.binomial == null || this.binomial.length <= n) {
            this.binomial = new int[n + 1][n + 1];
            for (int r = 0; r <= n; ++r) {
                for (int c = 0; c <= r; ++c) {
                    this.binomial[r][c] = c == 0 || c == r ? 1 : this.binomial[r - 1][c - 1] + this.binomial[r - 1][c];
                }
            }
        }
        return this.binomial[n][k];
    }

    private boolean areComponentsReadableWritableState(List<ILSMDiskComponent> immutableComponents) {
        for (ILSMComponent iLSMComponent : immutableComponents) {
            if (iLSMComponent.getState() == ILSMComponent.ComponentState.READABLE_UNWRITABLE) continue;
            return false;
        }
        return true;
    }

    @Override
    public void configure(Map<String, String> properties) {
        this.numComponents = Integer.parseInt(properties.get("num-components"));
    }

    @Override
    public boolean isMergeLagging(ILSMIndex index) throws HyracksDataException {
        List<ILSMDiskComponent> immutableComponents = index.getDiskComponents();
        return this.isMergeOngoing(immutableComponents);
    }

    private boolean isMergeOngoing(List<ILSMDiskComponent> immutableComponents) {
        int size = immutableComponents.size();
        for (int i = 0; i < size; ++i) {
            if (immutableComponents.get(i).getState() != ILSMComponent.ComponentState.READABLE_MERGING) continue;
            return true;
        }
        return false;
    }
}

