/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.values.reader.value;

import java.io.IOException;
import org.apache.asterix.column.bytes.decoder.ParquetPlainFixedLengthValuesReader;
import org.apache.asterix.column.bytes.stream.in.AbstractBytesInputStream;
import org.apache.asterix.column.values.reader.value.AbstractValueReader;
import org.apache.asterix.om.types.ATypeTag;

public final class FloatValueReader
extends AbstractValueReader {
    private final ParquetPlainFixedLengthValuesReader floatReader = new ParquetPlainFixedLengthValuesReader(4);
    private float nextValue;

    @Override
    public void init(AbstractBytesInputStream in, int tupleCount) throws IOException {
        this.floatReader.initFromPage(in);
    }

    @Override
    public void nextValue() {
        this.nextValue = this.floatReader.readFloat();
    }

    @Override
    public float getFloat() {
        return this.nextValue;
    }

    @Override
    public ATypeTag getTypeTag() {
        return ATypeTag.FLOAT;
    }

    @Override
    public int compareTo(AbstractValueReader o) {
        return Float.compare(this.nextValue, o.getFloat());
    }
}

