/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs.parquet;

import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.input.filter.embedder.IExternalFilterValueEmbedder;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.AsterixParquetRuntimeException;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.MapredParquetInputFormat;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.ParquetReadSupport;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.util.LogRedactionUtil;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;

public class ParquetRecordReaderWrapper
implements RecordReader<Void, VoidPointable> {
    private final ParquetRecordReader<IValueReference> realReader;
    private final long splitLen;
    private final VoidPointable valueContainer;
    private boolean firstRecord;
    private boolean eof;

    public ParquetRecordReaderWrapper(org.apache.hadoop.mapred.InputSplit oldSplit, JobConf oldJobConf, Reporter reporter, IExternalFilterValueEmbedder valueEmbedder) throws IOException {
        this.splitLen = oldSplit.getLength();
        try {
            ReadSupport readSupport = ParquetInputFormat.getReadSupportInstance((Configuration)oldJobConf);
            ParquetReadSupport parquetReadSupport = (ParquetReadSupport)readSupport;
            parquetReadSupport.setValueEmbedder(valueEmbedder);
            this.realReader = new ParquetRecordReader(readSupport, ParquetInputFormat.getFilter((Configuration)oldJobConf));
            if (oldSplit instanceof MapredParquetInputFormat.ParquetInputSplitWrapper) {
                this.realReader.initialize((InputSplit)((MapredParquetInputFormat.ParquetInputSplitWrapper)oldSplit).realSplit, (Configuration)oldJobConf, reporter);
            } else if (oldSplit instanceof FileSplit) {
                this.realReader.initialize((InputSplit)((FileSplit)oldSplit), (Configuration)oldJobConf, reporter);
            } else {
                throw RuntimeDataException.create((ErrorCode)ErrorCode.INVALID_PARQUET_FILE, (Serializable[])new Serializable[]{LogRedactionUtil.userData((String)oldSplit.toString()), "invalid file split"});
            }
            valueEmbedder.setPath(this.getPath(oldSplit));
            this.valueContainer = new VoidPointable();
            this.firstRecord = false;
            this.eof = false;
            if (this.realReader.nextKeyValue()) {
                this.firstRecord = true;
                this.valueContainer.set((IValueReference)this.realReader.getCurrentValue());
            } else {
                this.eof = true;
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        catch (AsterixParquetRuntimeException | HyracksDataException e) {
            throw e;
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().contains("not a Parquet file")) {
                throw RuntimeDataException.create((ErrorCode)ErrorCode.INVALID_PARQUET_FILE, (Serializable[])new Serializable[]{LogRedactionUtil.userData((String)this.getPath(oldSplit)), "not a Parquet file"});
            }
            throw RuntimeDataException.create((Throwable)e);
        }
    }

    private String getPath(org.apache.hadoop.mapred.InputSplit split) {
        if (split instanceof FileSplit) {
            return ((FileSplit)split).getPath().toString();
        }
        if (split instanceof MapredParquetInputFormat.ParquetInputSplitWrapper) {
            return ((MapredParquetInputFormat.ParquetInputSplitWrapper)split).realSplit.getPath().toString();
        }
        return split.toString();
    }

    public void close() throws IOException {
        this.realReader.close();
    }

    public Void createKey() {
        return null;
    }

    public VoidPointable createValue() {
        return this.valueContainer;
    }

    public long getPos() throws IOException {
        return (long)((float)this.splitLen * this.getProgress());
    }

    public float getProgress() throws IOException {
        try {
            return this.realReader.getProgress();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public boolean next(Void key, VoidPointable value) throws IOException {
        if (this.eof) {
            return false;
        }
        if (this.firstRecord) {
            this.firstRecord = false;
            value.set((IValueReference)this.valueContainer);
            return true;
        }
        try {
            if (this.realReader.nextKeyValue()) {
                if (value != null) {
                    value.set((IValueReference)this.realReader.getCurrentValue());
                }
                return true;
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        this.eof = true;
        return false;
    }
}

