/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.RequiredTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3.model.S3Response;
import software.amazon.awssdk.services.s3.model.SessionCredentials;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSessionResponse
extends S3Response
implements ToCopyableBuilder<Builder, CreateSessionResponse> {
    private static final SdkField<SessionCredentials> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Credentials").getter(CreateSessionResponse.getter(CreateSessionResponse::credentials)).setter(CreateSessionResponse.setter(Builder::credentials)).constructor(SessionCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").unmarshallLocationName("Credentials").build(), RequiredTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_FIELD));
    private final SessionCredentials credentials;

    private CreateSessionResponse(BuilderImpl builder) {
        super(builder);
        this.credentials = builder.credentials;
    }

    public final SessionCredentials credentials() {
        return this.credentials;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSessionResponse)) {
            return false;
        }
        CreateSessionResponse other = (CreateSessionResponse)((Object)obj);
        return Objects.equals(this.credentials(), other.credentials());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSessionResponse").add("Credentials", (Object)this.credentials()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSessionResponse, T> g) {
        return obj -> g.apply((CreateSessionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3Response.BuilderImpl
    implements Builder {
        private SessionCredentials credentials;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSessionResponse model) {
            super(model);
            this.credentials(model.credentials);
        }

        public final SessionCredentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        public final void setCredentials(SessionCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(SessionCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @Override
        public CreateSessionResponse build() {
            return new CreateSessionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends S3Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSessionResponse> {
        public Builder credentials(SessionCredentials var1);

        default public Builder credentials(Consumer<SessionCredentials.Builder> credentials) {
            return this.credentials((SessionCredentials)((SessionCredentials.Builder)SessionCredentials.builder().applyMutation(credentials)).build());
        }
    }
}

