/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.asterix.builders.ArrayListFactory;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.functions.IFunctionTypeInferer;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.PointableAllocator;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.container.IObjectFactory;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.asterix.om.util.container.ListObjectPool;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.CastTypeEvaluator;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.accessors.UTF8StringBinaryComparatorFactory;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class ArrayStarDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new ArrayStarDescriptor();
        }

        public IFunctionTypeInferer createFunctionTypeInferer() {
            return FunctionTypeInferers.SET_ARGUMENT_TYPE;
        }
    };
    private IAType inputListType;

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ARRAY_STAR;
    }

    public void setImmutableStates(Object ... states) {
        this.inputListType = (IAType)states[0];
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) throws AlgebricksException {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new ArrayStarEval(args, ctx);
            }
        };
    }

    public class ArrayStarEval
    implements IScalarEvaluator {
        private final IBinaryComparator binaryStrComp = UTF8StringBinaryComparatorFactory.INSTANCE.createBinaryComparator();
        private final UTF8StringComparator comp = new UTF8StringComparator();
        private final ArrayBackedValueStorage storage = new ArrayBackedValueStorage();
        private final IScalarEvaluator listEval;
        private final IPointable list;
        private final IPointable tempList;
        private final IPointable object = new VoidPointable();
        private final CastTypeEvaluator caster;
        private final ListAccessor listAccessor;
        private final RecordBuilder recordBuilder;
        private final IAsterixListBuilder listBuilder;
        private final PointableAllocator pointableAllocator;
        private final List<FieldNameToValues> fieldNameToValuesList;
        private final PriorityQueue<FieldNameToValues> tempMinHeap;
        private final IObjectPool<List<IVisitablePointable>, ATypeTag> arrayListAllocator;
        private final IObjectPool<FieldNameToValues, ATypeTag> fieldNameToValuesAllocator;

        public ArrayStarEval(IScalarEvaluatorFactory[] args, IEvaluatorContext ctx) throws HyracksDataException {
            this.list = new VoidPointable();
            this.tempList = new VoidPointable();
            this.listEval = args[0].createScalarEvaluator(ctx);
            this.caster = new CastTypeEvaluator();
            this.listAccessor = new ListAccessor();
            this.recordBuilder = new RecordBuilder();
            this.listBuilder = new OrderedListBuilder();
            this.pointableAllocator = new PointableAllocator();
            this.fieldNameToValuesList = new ArrayList<FieldNameToValues>();
            this.tempMinHeap = new PriorityQueue<IValueReference>(this.comp);
            this.arrayListAllocator = new ListObjectPool((IObjectFactory)new ArrayListFactory());
            this.fieldNameToValuesAllocator = new ListObjectPool((IObjectFactory)new FieldNameToValuesAllocator());
        }

        public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
            this.storage.reset();
            this.listEval.evaluate(tuple, this.tempList);
            if (PointableHelper.checkAndSetMissingOrNull(result, this.tempList)) {
                return;
            }
            ATypeTag listTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.tempList.getByteArray()[this.tempList.getStartOffset()]);
            if (listTag != ATypeTag.ARRAY) {
                PointableHelper.setNull(result);
                return;
            }
            try {
                this.caster.resetAndAllocate((IAType)DefaultOpenFieldType.NESTED_OPEN_AORDERED_LIST_TYPE, ArrayStarDescriptor.this.inputListType, this.listEval);
                this.caster.cast(this.tempList, this.list);
                this.tempMinHeap.clear();
                this.fieldNameToValuesList.clear();
                this.listAccessor.reset(this.list.getByteArray(), this.list.getStartOffset());
                int numObjects = this.listAccessor.size();
                for (int objectIndex = 0; objectIndex < numObjects; ++objectIndex) {
                    this.listAccessor.getOrWriteItem(objectIndex, this.object, this.storage);
                    this.processObject(this.object, objectIndex, numObjects);
                }
                if (this.fieldNameToValuesList.isEmpty()) {
                    PointableHelper.setMissing(result);
                    return;
                }
                for (int i = 0; i < this.fieldNameToValuesList.size(); ++i) {
                    this.tempMinHeap.add(this.fieldNameToValuesList.get(i));
                }
                this.recordBuilder.reset(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
                this.recordBuilder.init();
                while (!this.tempMinHeap.isEmpty()) {
                    FieldNameToValues fieldNameToValues = this.tempMinHeap.poll();
                    this.listBuilder.reset((AbstractCollectionType)DefaultOpenFieldType.NESTED_OPEN_AORDERED_LIST_TYPE);
                    for (int k = 0; k < fieldNameToValues.values.size(); ++k) {
                        IVisitablePointable oneValue = fieldNameToValues.values.get(k);
                        if (oneValue == null) {
                            this.listBuilder.addItem((IValueReference)PointableHelper.NULL_REF);
                            continue;
                        }
                        this.listBuilder.addItem((IValueReference)oneValue);
                    }
                    this.storage.reset();
                    this.listBuilder.write(this.storage.getDataOutput(), true);
                    this.recordBuilder.addField((IValueReference)fieldNameToValues.fieldName, (IValueReference)this.storage);
                }
                this.storage.reset();
                this.recordBuilder.write(this.storage.getDataOutput(), true);
                result.set((IValueReference)this.storage);
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            finally {
                this.pointableAllocator.reset();
                this.arrayListAllocator.reset();
                this.fieldNameToValuesAllocator.reset();
                this.caster.deallocatePointables();
            }
        }

        private void processObject(IPointable object, int objectIndex, int numObjects) throws HyracksDataException {
            if (object.getByteArray()[object.getStartOffset()] == ATypeTag.SERIALIZED_RECORD_TYPE_TAG) {
                ARecordVisitablePointable record = this.pointableAllocator.allocateRecordValue((IAType)DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
                record.set(object.getByteArray(), object.getStartOffset(), object.getLength());
                List fieldNames = record.getFieldNames();
                List fieldValues = record.getFieldValues();
                for (int j = 0; j < fieldNames.size(); ++j) {
                    List values;
                    IVisitablePointable fieldName = (IVisitablePointable)fieldNames.get(j);
                    FieldNameToValues fieldNameToValues = this.findField(fieldName, this.fieldNameToValuesList, this.binaryStrComp);
                    if (fieldNameToValues == null) {
                        fieldNameToValues = (FieldNameToValues)this.fieldNameToValuesAllocator.allocate(null);
                        values = (List)this.arrayListAllocator.allocate(null);
                        this.clear(values, numObjects);
                        fieldNameToValues.fieldName = fieldName;
                        fieldNameToValues.values = values;
                        this.fieldNameToValuesList.add(fieldNameToValues);
                    } else {
                        values = fieldNameToValues.values;
                    }
                    values.set(objectIndex, (IVisitablePointable)((IVisitablePointable)fieldValues.get(j)));
                }
            }
        }

        private void clear(List<IVisitablePointable> values, int numObjects) {
            values.clear();
            for (int i = 1; i <= numObjects; ++i) {
                values.add(null);
            }
        }

        private FieldNameToValues findField(IVisitablePointable fieldName, List<FieldNameToValues> fieldNamesList, IBinaryComparator strComp) throws HyracksDataException {
            for (int i = 0; i < fieldNamesList.size(); ++i) {
                FieldNameToValues anotherFieldName = fieldNamesList.get(i);
                if (!PointableHelper.isEqual((IValueReference)fieldName, (IValueReference)anotherFieldName.fieldName, strComp)) continue;
                return anotherFieldName;
            }
            return null;
        }
    }

    protected class FieldNameToValuesAllocator
    implements IObjectFactory<FieldNameToValues, ATypeTag> {
        protected FieldNameToValuesAllocator() {
        }

        public FieldNameToValues create(ATypeTag arg) {
            return new FieldNameToValues();
        }
    }

    protected class FieldNameToValues
    implements IValueReference {
        private IVisitablePointable fieldName;
        private List<IVisitablePointable> values;

        protected FieldNameToValues() {
        }

        public byte[] getByteArray() {
            return this.fieldName.getByteArray();
        }

        public int getStartOffset() {
            return this.fieldName.getStartOffset();
        }

        public int getLength() {
            return this.fieldName.getLength();
        }
    }

    public class UTF8StringComparator
    implements Comparator<IValueReference> {
        private final IBinaryComparator comp = UTF8StringBinaryComparatorFactory.INSTANCE.createBinaryComparator();

        @Override
        public int compare(IValueReference val1, IValueReference val2) {
            try {
                return PointableHelper.compareStringBinValues(val1, val2, this.comp);
            }
            catch (HyracksDataException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

