/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.file.datalake.implementation.FileSystemsImpl;
import com.azure.storage.file.datalake.implementation.PathsImpl;
import com.azure.storage.file.datalake.implementation.ServicesImpl;

public final class AzureDataLakeStorageRestAPIImpl {
    private final String url;
    private final String resource;
    private final String version;
    private final String fileSystem;
    private final String path;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final ServicesImpl services;
    private final FileSystemsImpl fileSystems;
    private final PathsImpl paths;

    public String getUrl() {
        return this.url;
    }

    public String getResource() {
        return this.resource;
    }

    public String getVersion() {
        return this.version;
    }

    public String getFileSystem() {
        return this.fileSystem;
    }

    public String getPath() {
        return this.path;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public ServicesImpl getServices() {
        return this.services;
    }

    public FileSystemsImpl getFileSystems() {
        return this.fileSystems;
    }

    public PathsImpl getPaths() {
        return this.paths;
    }

    AzureDataLakeStorageRestAPIImpl(String url, String resource, String version, String fileSystem, String path) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), url, resource, version, fileSystem, path);
    }

    AzureDataLakeStorageRestAPIImpl(HttpPipeline httpPipeline, String url, String resource, String version, String fileSystem, String path) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), url, resource, version, fileSystem, path);
    }

    AzureDataLakeStorageRestAPIImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String url, String resource, String version, String fileSystem, String path) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.url = url;
        this.resource = resource;
        this.version = version;
        this.fileSystem = fileSystem;
        this.path = path;
        this.services = new ServicesImpl(this);
        this.fileSystems = new FileSystemsImpl(this);
        this.paths = new PathsImpl(this);
    }
}

