/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.asterix.api.http.server.AbstractNCUdfServlet;
import org.apache.asterix.app.message.CreateLibraryRequestMessage;
import org.apache.asterix.app.message.DropLibraryRequestMessage;
import org.apache.asterix.app.message.InternalRequestResponse;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.api.IReceptionist;
import org.apache.asterix.common.api.IRequestReference;
import org.apache.asterix.common.functions.ExternalFunctionLanguage;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.common.messaging.api.INCMessageBroker;
import org.apache.asterix.common.messaging.api.MessageFuture;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.external.util.ExternalLibraryUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.hyracks.util.JSONUtil;
import org.apache.hyracks.util.file.FileUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NCUdfApiServlet
extends AbstractNCUdfServlet {
    protected final IReceptionist receptionist;
    protected Path workingDir;
    protected String sysAuthHeader;
    private ILibraryManager libraryManager;
    private int timeout;
    private static final Logger LOGGER = LogManager.getLogger();

    public NCUdfApiServlet(ConcurrentMap<String, Object> ctx, String[] paths, IApplicationContext appCtx, HttpScheme httpServerProtocol, int httpServerPort) {
        super(ctx, paths, appCtx, httpServerProtocol, httpServerPort);
        this.receptionist = appCtx.getReceptionist();
        this.timeout = appCtx.getExternalProperties().getLibraryDeployTimeout();
    }

    public void init() throws IOException {
        this.appCtx = (INcApplicationContext)this.plainAppCtx;
        this.libraryManager = this.appCtx.getLibraryManager();
        this.srvCtx = this.appCtx.getServiceContext();
        this.workingDir = Paths.get(this.appCtx.getLibraryManager().getDistributionDir().getAbsolutePath(), new String[0]).normalize();
        this.initAuth();
        this.initStorage();
    }

    protected void initAuth() {
        this.sysAuthHeader = (String)this.ctx.get("org.apache.asterix.SYS_AUTH_HEADER");
    }

    protected void initStorage() throws IOException {
        if (Files.isDirectory(this.workingDir, new LinkOption[0])) {
            try {
                FileUtils.cleanDirectory((File)this.workingDir.toFile());
            }
            catch (IOException e) {
                LOGGER.warn("Could not clean directory: " + this.workingDir, (Throwable)e);
            }
        } else {
            Files.deleteIfExists(this.workingDir);
            FileUtil.forceMkdirs((File)this.workingDir.toFile());
        }
    }

    protected Map<String, String> additionalHttpHeadersFromRequest(IServletRequest request) {
        return Collections.emptyMap();
    }

    private void doCreate(DataverseName dataverseName, String libraryName, ExternalFunctionLanguage language, String hash, URI downloadURI, boolean replaceIfExists, String sysAuthHeader, IRequestReference requestReference, IServletRequest request) throws Exception {
        INCMessageBroker ncMb = (INCMessageBroker)this.srvCtx.getMessageBroker();
        MessageFuture responseFuture = ncMb.registerMessageFuture();
        CreateLibraryRequestMessage req = new CreateLibraryRequestMessage(this.srvCtx.getNodeId(), responseFuture.getFutureId(), dataverseName, libraryName, language, hash, downloadURI, replaceIfExists, sysAuthHeader, requestReference, this.additionalHttpHeadersFromRequest(request));
        this.sendMessage(req, responseFuture);
    }

    private void doDrop(DataverseName dataverseName, String libraryName, boolean replaceIfExists, IRequestReference requestReference, IServletRequest request) throws Exception {
        INCMessageBroker ncMb = (INCMessageBroker)this.srvCtx.getMessageBroker();
        MessageFuture responseFuture = ncMb.registerMessageFuture();
        DropLibraryRequestMessage req = new DropLibraryRequestMessage(this.srvCtx.getNodeId(), responseFuture.getFutureId(), dataverseName, libraryName, replaceIfExists, requestReference, this.additionalHttpHeadersFromRequest(request));
        this.sendMessage(req, responseFuture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(ICcAddressedMessage requestMessage, MessageFuture responseFuture) throws Exception {
        InternalRequestResponse responseMsg;
        INCMessageBroker ncMb = (INCMessageBroker)this.srvCtx.getMessageBroker();
        try {
            ncMb.sendMessageToPrimaryCC(requestMessage);
            responseMsg = (InternalRequestResponse)responseFuture.get((long)this.timeout, TimeUnit.SECONDS);
        }
        finally {
            ncMb.deregisterMessageFuture(responseFuture.getFutureId());
        }
        Throwable err = responseMsg.getError();
        if (err != null) {
            if (err instanceof Error) {
                throw (Error)err;
            }
            if (err instanceof Exception) {
                throw (Exception)err;
            }
            throw new Exception(err.toString(), err);
        }
    }

    protected void get(IServletRequest request, IServletResponse response) throws Exception {
        String localPath = this.localPath(request);
        try {
            if (localPath.equals("/") || localPath.equals("")) {
                Map dvToLibHashes = ExternalLibraryUtils.produceLibraryListing((ILibraryManager)this.libraryManager);
                ArrayList libraryList = new ArrayList();
                for (Map.Entry dvAndLibs : dvToLibHashes.entrySet()) {
                    for (Map.Entry libsInDv : ((Map)dvAndLibs.getValue()).entrySet()) {
                        HashMap<String, Object> libraryEntry = new HashMap<String, Object>();
                        libraryEntry.put(this.getDataverseKey(), ((DataverseName)dvAndLibs.getKey()).getCanonicalForm());
                        libraryEntry.put("name", libsInDv.getKey());
                        libraryEntry.put("hash_md5", libsInDv.getValue());
                        libraryList.add(libraryEntry);
                    }
                }
                JsonNode libraryListing = OBJECT_MAPPER.valueToTree(libraryList);
                response.setStatus(HttpResponseStatus.OK);
                HttpUtil.setContentType((IServletResponse)response, (String)"application/json", (IServletRequest)request);
                PrintWriter responseWriter = response.writer();
                JSONUtil.writeNode((Writer)responseWriter, (JsonNode)libraryListing);
                responseWriter.flush();
            } else if (this.localPath(request).startsWith("/dist")) {
                localPath = this.localPath(request).substring("/dist".length());
                while (localPath.startsWith("/")) {
                    localPath = localPath.substring(1);
                }
                if (localPath.isEmpty()) {
                    response.setStatus(HttpResponseStatus.BAD_REQUEST);
                    return;
                }
                Path filePath = this.workingDir.resolve(localPath).normalize();
                if (!filePath.startsWith(this.workingDir)) {
                    response.setStatus(HttpResponseStatus.BAD_REQUEST);
                    return;
                }
                this.readFromFile(filePath, response, "application/octet-stream", null);
            } else {
                response.setStatus(HttpResponseStatus.NOT_FOUND);
            }
        }
        catch (Exception e) {
            this.writeException(e, response);
            LOGGER.error("Error reading library", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleModification(IServletRequest request, IServletResponse response, LibraryOperation op) {
        FullHttpRequest httpRequest = request.getHttpRequest();
        Path libraryTempFile = null;
        FileOutputStream libTmpOut = null;
        HttpPostRequestDecoder requestDecoder = null;
        String localPath = this.localPath(request);
        try {
            Pair<DataverseName, String> dvAndName = this.decodeDvAndLibFromLocalPath(localPath);
            IRequestReference requestReference = this.receptionist.welcome(request);
            if (op == LibraryOperation.UPSERT) {
                requestDecoder = new HttpPostRequestDecoder((HttpRequest)httpRequest);
                AbstractNCUdfServlet.LibraryUploadData uploadData = this.decodeMultiPartLibraryOptions(requestDecoder);
                ExternalFunctionLanguage language = uploadData.type;
                String fileExt = FilenameUtils.getExtension((String)uploadData.fileUpload.getFilename());
                libraryTempFile = Files.createTempFile(this.workingDir, "lib_", "." + fileExt, new FileAttribute[0]);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Created temporary file " + libraryTempFile + " for library " + ((DataverseName)dvAndName.getFirst()).getCanonicalForm() + "." + (String)dvAndName.getSecond());
                }
                MessageDigest digest = MessageDigest.getInstance("MD5");
                libTmpOut = new FileOutputStream(libraryTempFile.toFile());
                try (DigestOutputStream os = new DigestOutputStream(libTmpOut, digest);
                     ByteBufInputStream ui = new ByteBufInputStream(uploadData.fileUpload.getByteBuf());){
                    IOUtils.copyLarge((InputStream)ui, (OutputStream)os);
                }
                URI downloadURI = this.createDownloadURI(libraryTempFile);
                this.doCreate((DataverseName)dvAndName.getFirst(), (String)dvAndName.getSecond(), language, ExternalLibraryUtils.digestToHexString((MessageDigest)digest), downloadURI, true, this.sysAuthHeader, requestReference, request);
            } else if (op == LibraryOperation.DELETE) {
                this.doDrop((DataverseName)dvAndName.getFirst(), (String)dvAndName.getSecond(), false, requestReference, request);
            }
            response.setStatus(HttpResponseStatus.OK);
            PrintWriter responseWriter = response.writer();
            String emptyJson = "{}";
            responseWriter.write(emptyJson);
            responseWriter.flush();
        }
        catch (Exception e) {
            this.writeException(e, response);
            LOGGER.info("Error modifying library", (Throwable)e);
        }
        finally {
            if (requestDecoder != null) {
                requestDecoder.destroy();
            }
            try {
                if (libraryTempFile != null) {
                    if (libTmpOut != null) {
                        libTmpOut.close();
                    }
                    Files.deleteIfExists(libraryTempFile);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Could not delete temporary file " + libraryTempFile, (Throwable)e);
            }
        }
    }

    private void writeException(Exception e, IServletResponse response) {
        response.setStatus(this.toHttpErrorStatus(e));
        PrintWriter responseWriter = response.writer();
        Map<String, String> error = Collections.singletonMap("error", e.getMessage());
        String errorJson = "";
        try {
            errorJson = OBJECT_MAPPER.writeValueAsString(error);
        }
        catch (JsonProcessingException ex) {
            responseWriter.write("{ \"error\": \"Unable to process error message!\" }");
        }
        responseWriter.write(errorJson);
        responseWriter.flush();
    }

    protected boolean isRequestPermitted(IServletRequest request, IServletResponse response) throws IOException {
        if (!this.isRequestOnLoopback(request)) {
            this.rejectForbidden(response);
            return false;
        }
        return true;
    }

    protected boolean isRequestOnLoopback(IServletRequest request) {
        if (request.getLocalAddress() != null && request.getRemoteAddress() != null) {
            InetAddress local = request.getLocalAddress().getAddress();
            InetAddress remote = request.getRemoteAddress().getAddress();
            return remote.isLoopbackAddress() && local.isLoopbackAddress();
        }
        return false;
    }

    protected void rejectForbidden(IServletResponse response) throws IOException {
        this.sendError(response, "application/json", HttpResponseStatus.FORBIDDEN, "{ \"error\": \"Forbidden\" }");
    }

    protected void post(IServletRequest request, IServletResponse response) throws IOException {
        if (this.isRequestPermitted(request, response)) {
            this.handleModification(request, response, LibraryOperation.UPSERT);
        }
    }

    protected void delete(IServletRequest request, IServletResponse response) throws IOException {
        if (this.isRequestPermitted(request, response)) {
            this.handleModification(request, response, LibraryOperation.DELETE);
        }
    }

    private static enum LibraryOperation {
        UPSERT,
        DELETE;

    }
}

