/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.external.api.IExternalLangIPCProto;
import org.apache.asterix.external.api.ILibraryEvaluator;
import org.apache.asterix.external.library.PythonLibraryEvaluatorId;
import org.apache.asterix.om.functions.IExternalFunctionInfo;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.std.base.AbstractStateObject;

public abstract class AbstractLibrarySocketEvaluator
extends AbstractStateObject
implements ILibraryEvaluator {
    protected IExternalLangIPCProto proto;
    protected TaskAttemptId task;
    protected IWarningCollector warningCollector;
    protected SourceLocation sourceLoc;

    public AbstractLibrarySocketEvaluator(JobId jobId, PythonLibraryEvaluatorId evaluatorId, TaskAttemptId task, IWarningCollector warningCollector, SourceLocation sourceLoc) {
        super(jobId, (Object)evaluatorId);
        this.task = task;
        this.warningCollector = warningCollector;
        this.sourceLoc = sourceLoc;
    }

    @Override
    public long initialize(IExternalFunctionInfo finfo) throws IOException, AsterixException {
        String fn;
        String clazz;
        List externalIdents = finfo.getExternalIdentifier();
        String packageModule = (String)externalIdents.get(0);
        String externalIdent1 = (String)externalIdents.get(1);
        int idx = externalIdent1.lastIndexOf(46);
        if (idx >= 0) {
            clazz = externalIdent1.substring(0, idx);
            fn = externalIdent1.substring(idx + 1);
        } else {
            clazz = null;
            fn = externalIdent1;
        }
        return this.proto.init(packageModule, clazz, fn);
    }

    @Override
    public ByteBuffer call(long id, IAType[] argTypes, IValueReference[] valueReferences, boolean nullCall) throws IOException {
        ByteBuffer ret;
        block2: {
            ret = null;
            try {
                ret = this.proto.call(id, argTypes, valueReferences, nullCall);
            }
            catch (AsterixException e) {
                if (!this.warningCollector.shouldWarn()) break block2;
                this.warningCollector.warn(Warning.of((SourceLocation)this.sourceLoc, (IError)ErrorCode.EXTERNAL_UDF_EXCEPTION, (Serializable[])new Serializable[]{e.getMessage()}));
            }
        }
        return ret;
    }

    @Override
    public ByteBuffer callMulti(long id, ArrayBackedValueStorage arguments, int numTuples) throws IOException {
        ByteBuffer ret;
        block2: {
            ret = null;
            try {
                ret = this.proto.callMulti(id, arguments, numTuples);
            }
            catch (AsterixException e) {
                if (!this.warningCollector.shouldWarn()) break block2;
                this.warningCollector.warn(Warning.of((SourceLocation)this.sourceLoc, (IError)ErrorCode.EXTERNAL_UDF_EXCEPTION, (Serializable[])new Serializable[]{e.getMessage()}));
            }
        }
        return ret;
    }
}

