/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.ipc;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.external.api.IExternalLangIPCProto;
import org.apache.asterix.external.ipc.MessageType;
import org.apache.asterix.external.ipc.PythonMessageBuilder;
import org.apache.asterix.external.library.msgpack.MsgPackPointableVisitor;
import org.apache.asterix.om.pointables.PointableAllocator;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.core.buffer.ArrayBufferInput;
import org.msgpack.core.buffer.MessageBufferInput;

public abstract class AbstractPythonIPCProto {
    public static final int HEADER_SIZE_LEN_INCLUSIVE = 21;
    protected final PythonMessageBuilder messageBuilder;
    protected final DataOutputStream sockOut;
    protected final ArrayBufferInput unpackerInput;
    protected final MessageUnpacker unpacker;
    protected final ArrayBackedValueStorage argsStorage;
    protected final PointableAllocator pointableAllocator;
    protected final MsgPackPointableVisitor pointableVisitor;
    private final ByteBuffer headerBuffer = ByteBuffer.allocate(21);
    protected ByteBuffer recvBuffer = ByteBuffer.allocate(32768);
    protected long routeId;
    protected Pair<ByteBuffer, Exception> bufferBox;
    protected long maxFunctionId;

    public AbstractPythonIPCProto(OutputStream sockOut) {
        this.messageBuilder = new PythonMessageBuilder();
        this.sockOut = new DataOutputStream(sockOut);
        this.maxFunctionId = 0L;
        this.unpackerInput = new ArrayBufferInput(new byte[0]);
        this.unpacker = MessagePack.newDefaultUnpacker((MessageBufferInput)this.unpackerInput);
        this.argsStorage = new ArrayBackedValueStorage();
        this.pointableAllocator = new PointableAllocator();
        this.pointableVisitor = new MsgPackPointableVisitor();
    }

    public void helo() throws IOException, AsterixException {
        this.recvBuffer.clear();
        this.recvBuffer.position(0);
        this.recvBuffer.limit(0);
        this.messageBuilder.reset();
        this.messageBuilder.hello();
        this.sendHeader(this.routeId, this.messageBuilder.getLength());
        this.sendMsg();
        this.receiveMsg();
        if (this.getResponseType() != MessageType.HELO) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.ILLEGAL_STATE, (Serializable[])new Serializable[]{"Expected HELO, recieved " + this.getResponseType().name()});
        }
    }

    public long init(String module, String clazz, String fn) throws IOException, AsterixException {
        long functionId = this.maxFunctionId++;
        this.recvBuffer.clear();
        this.recvBuffer.position(0);
        this.recvBuffer.limit(0);
        this.messageBuilder.reset();
        this.messageBuilder.init(module, clazz, fn);
        this.sendHeader(functionId, this.messageBuilder.getLength());
        this.sendMsg();
        this.receiveMsg();
        if (this.getResponseType() != MessageType.INIT_RSP) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.ILLEGAL_STATE, (Serializable[])new Serializable[]{"Expected INIT_RSP, recieved " + this.getResponseType().name()});
        }
        return functionId;
    }

    public ByteBuffer call(long functionId, IAType[] argTypes, IValueReference[] argValues, boolean nullCall) throws IOException, AsterixException {
        this.recvBuffer.clear();
        this.recvBuffer.position(0);
        this.recvBuffer.limit(0);
        this.messageBuilder.reset();
        this.argsStorage.reset();
        for (int i = 0; i < argTypes.length; ++i) {
            IExternalLangIPCProto.visitValueRef(argTypes[i], this.argsStorage.getDataOutput(), argValues[i], this.pointableAllocator, this.pointableVisitor, nullCall);
        }
        int len = this.argsStorage.getLength() + 5;
        this.sendHeader(functionId, len);
        this.messageBuilder.call(argValues.length, len);
        this.sendMsg(this.argsStorage);
        this.receiveMsg();
        if (this.getResponseType() != MessageType.CALL_RSP) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.ILLEGAL_STATE, (Serializable[])new Serializable[]{"Expected CALL_RSP, recieved " + this.getResponseType().name()});
        }
        return this.recvBuffer;
    }

    public ByteBuffer callMulti(long key, ArrayBackedValueStorage args, int numTuples) throws IOException, AsterixException {
        this.recvBuffer.clear();
        this.recvBuffer.position(0);
        this.recvBuffer.limit(0);
        this.messageBuilder.reset();
        int len = args.getLength() + 4;
        this.sendHeader(key, len);
        this.messageBuilder.callMulti(0, numTuples);
        this.sendMsg(args);
        this.receiveMsg();
        if (this.getResponseType() != MessageType.CALL_RSP) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.ILLEGAL_STATE, (Serializable[])new Serializable[]{"Expected CALL_RSP, recieved " + this.getResponseType().name()});
        }
        return this.recvBuffer;
    }

    public void quit() throws HyracksDataException {
        this.messageBuilder.quit();
    }

    public abstract void receiveMsg() throws IOException, AsterixException;

    public void sendHeader(long key, int msgLen) throws IOException {
        this.headerBuffer.clear();
        this.headerBuffer.position(0);
        this.headerBuffer.putInt(21 + msgLen);
        this.headerBuffer.putLong(key);
        this.headerBuffer.putLong(this.routeId);
        this.headerBuffer.put((byte)0);
        this.sockOut.write(this.headerBuffer.array(), 0, 21);
        this.sockOut.flush();
    }

    public void sendMsg(ArrayBackedValueStorage content) throws IOException {
        this.sockOut.write(this.messageBuilder.getBuf().array(), this.messageBuilder.getBuf().arrayOffset(), this.messageBuilder.getBuf().position());
        this.sockOut.write(content.getByteArray(), content.getStartOffset(), content.getLength());
        this.sockOut.flush();
    }

    public void sendMsg() throws IOException {
        this.sockOut.write(this.messageBuilder.getBuf().array(), this.messageBuilder.getBuf().arrayOffset(), this.messageBuilder.getBuf().position());
        this.sockOut.flush();
    }

    public MessageType getResponseType() {
        return this.messageBuilder.type;
    }

    public long getRouteId() {
        return this.routeId;
    }

    public DataOutputStream getSockOut() {
        return this.sockOut;
    }
}

