/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.work;

import java.util.Map;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.nc.Joblet;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CleanupJobletWork
extends AbstractWork {
    private static final Logger LOGGER = LogManager.getLogger();
    private final NodeControllerService ncs;
    private final JobId jobId;
    private final JobStatus status;

    public CleanupJobletWork(NodeControllerService ncs, JobId jobId, JobStatus status) {
        this.ncs = ncs;
        this.jobId = jobId;
        this.status = status;
    }

    public void run() {
        LOGGER.debug("cleaning up {}", (Object)this.jobId);
        this.ncs.removeJobParameterByteStore(this.jobId);
        this.ncs.getPartitionManager().jobCompleted(this.jobId, this.status);
        Map<JobId, Joblet> jobletMap = this.ncs.getJobletMap();
        Joblet joblet = jobletMap.remove(this.jobId);
        if (joblet != null) {
            joblet.cleanup(this.status);
        }
    }

    public String toString() {
        return this.getName() + " jobId:" + this.jobId + ", status:" + this.status;
    }

    public Level logLevel() {
        return Level.TRACE;
    }
}

