/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public enum S3AEncryptionMethods {
    NONE("", false, false),
    SSE_S3("AES256", true, false),
    SSE_KMS("SSE-KMS", true, false),
    SSE_C("SSE-C", true, true),
    CSE_KMS("CSE-KMS", false, true),
    CSE_CUSTOM("CSE-CUSTOM", false, true);

    static final String UNKNOWN_ALGORITHM = "Unknown encryption algorithm ";
    private final String method;
    private final boolean serverSide;
    private final boolean requiresSecret;

    private S3AEncryptionMethods(String method, boolean serverSide, boolean requiresSecret) {
        this.method = method;
        this.serverSide = serverSide;
        this.requiresSecret = requiresSecret;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isServerSide() {
        return this.serverSide;
    }

    public boolean requiresSecret() {
        return this.requiresSecret;
    }

    public static S3AEncryptionMethods getMethod(String name) throws IOException {
        if (StringUtils.isBlank((CharSequence)name)) {
            return NONE;
        }
        for (S3AEncryptionMethods v : S3AEncryptionMethods.values()) {
            if (!v.getMethod().equalsIgnoreCase(name)) continue;
            return v;
        }
        throw new IOException(UNKNOWN_ALGORITHM + name);
    }
}

