/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionConstants;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.FalseLiteral;
import org.apache.asterix.lang.common.literal.TrueLiteral;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.struct.OperatorType;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.expression.CaseExpression;
import org.apache.asterix.lang.sqlpp.util.SqlppRewriteUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppExpressionScopingVisitor;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.PredicateCardinalityAnnotation;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class OperatorExpressionVisitor
extends AbstractSqlppExpressionScopingVisitor {
    public OperatorExpressionVisitor(LangRewritingContext context) {
        super(context);
    }

    @Override
    public Expression visit(OperatorExpr operatorExpr, ILangExpression arg) throws CompilationException {
        ArrayList<Expression> newExprList = new ArrayList<Expression>();
        for (Expression expr : operatorExpr.getExprList()) {
            newExprList.add((Expression)expr.accept((ILangVisitor)this, (Object)operatorExpr));
        }
        operatorExpr.setExprList(newExprList);
        OperatorType opType = (OperatorType)operatorExpr.getOpList().get(0);
        switch (opType) {
            case LIKE: 
            case NOT_LIKE: {
                return this.processLikeOperator(operatorExpr, opType);
            }
            case IN: 
            case NOT_IN: {
                return this.processInOperator(operatorExpr, opType);
            }
            case CONCAT: {
                return this.processConcatOperator(operatorExpr);
            }
            case BETWEEN: 
            case NOT_BETWEEN: {
                return this.processBetweenOperator(operatorExpr, opType);
            }
            case DISTINCT: 
            case NOT_DISTINCT: {
                return this.processDistinctOperator(operatorExpr, opType);
            }
        }
        return operatorExpr;
    }

    private Expression processLikeOperator(OperatorExpr operatorExpr, OperatorType opType) {
        CallExpr likeExpr = new CallExpr(new FunctionSignature(BuiltinFunctions.STRING_LIKE), operatorExpr.getExprList());
        likeExpr.addHints(operatorExpr.getHints());
        likeExpr.setSourceLocation(operatorExpr.getSourceLocation());
        switch (opType) {
            case LIKE: {
                return likeExpr;
            }
            case NOT_LIKE: {
                CallExpr notLikeExpr = new CallExpr(new FunctionSignature(BuiltinFunctions.NOT), new ArrayList<CallExpr>(Collections.singletonList(likeExpr)));
                notLikeExpr.setSourceLocation(operatorExpr.getSourceLocation());
                return notLikeExpr;
            }
        }
        throw new IllegalArgumentException(String.valueOf(opType));
    }

    private Expression processInOperator(OperatorExpr operatorExpr, OperatorType opType) {
        VariableExpr bindingVar = new VariableExpr(this.context.newVariable());
        bindingVar.setSourceLocation(operatorExpr.getSourceLocation());
        Expression itemExpr = (Expression)operatorExpr.getExprList().get(0);
        Expression collectionExpr = (Expression)operatorExpr.getExprList().get(1);
        OperatorExpr comparison = new OperatorExpr();
        comparison.addOperand(itemExpr);
        comparison.addOperand((Expression)bindingVar);
        comparison.setCurrentop(true);
        comparison.addHints(operatorExpr.getHints());
        comparison.setSourceLocation(operatorExpr.getSourceLocation());
        if (opType == OperatorType.IN) {
            comparison.addOperator(OperatorType.EQ);
            QuantifiedExpression quantExpr = new QuantifiedExpression(QuantifiedExpression.Quantifier.SOME, new ArrayList<QuantifiedPair>(Collections.singletonList(new QuantifiedPair(bindingVar, collectionExpr))), (Expression)comparison);
            quantExpr.setSourceLocation(operatorExpr.getSourceLocation());
            return quantExpr;
        }
        comparison.addOperator(OperatorType.NEQ);
        QuantifiedExpression quantExpr = new QuantifiedExpression(QuantifiedExpression.Quantifier.EVERY, new ArrayList<QuantifiedPair>(Collections.singletonList(new QuantifiedPair(bindingVar, collectionExpr))), (Expression)comparison);
        quantExpr.setSourceLocation(operatorExpr.getSourceLocation());
        return quantExpr;
    }

    private Expression processConcatOperator(OperatorExpr operatorExpr) {
        CallExpr callExpr = new CallExpr(new FunctionSignature(FunctionConstants.ASTERIX_DV, "concat", 1), operatorExpr.getExprList());
        callExpr.setSourceLocation(operatorExpr.getSourceLocation());
        return callExpr;
    }

    private List<IExpressionAnnotation> removeSelectivityHints(OperatorExpr expr) {
        if (expr.hasHints()) {
            ArrayList<IExpressionAnnotation> copyHintsExceptSelectivity = new ArrayList<IExpressionAnnotation>();
            for (IExpressionAnnotation h : expr.getHints()) {
                if (h.getClass().equals(PredicateCardinalityAnnotation.class)) continue;
                copyHintsExceptSelectivity.add(h);
            }
            return copyHintsExceptSelectivity;
        }
        return expr.getHints();
    }

    private Expression processBetweenOperator(OperatorExpr operatorExpr, OperatorType opType) throws CompilationException {
        Expression target = (Expression)operatorExpr.getExprList().get(0);
        Expression left = (Expression)operatorExpr.getExprList().get(1);
        Expression right = (Expression)operatorExpr.getExprList().get(2);
        Expression leftComparison = this.createOperatorExpression(OperatorType.GE, target, left, operatorExpr.getHints(), operatorExpr.getSourceLocation());
        Expression targetCopy = (Expression)SqlppRewriteUtil.deepCopy((ILangExpression)target);
        Expression rightComparison = this.createOperatorExpression(OperatorType.LE, targetCopy, right, this.removeSelectivityHints(operatorExpr), operatorExpr.getSourceLocation());
        Expression andExpr = this.createOperatorExpression(OperatorType.AND, leftComparison, rightComparison, null, operatorExpr.getSourceLocation());
        switch (opType) {
            case BETWEEN: {
                return andExpr;
            }
            case NOT_BETWEEN: {
                CallExpr callExpr = new CallExpr(new FunctionSignature(BuiltinFunctions.NOT), new ArrayList<Expression>(Collections.singletonList(andExpr)));
                callExpr.setSourceLocation(operatorExpr.getSourceLocation());
                return callExpr;
            }
        }
        throw new IllegalArgumentException(String.valueOf(opType));
    }

    private Expression processDistinctOperator(OperatorExpr operatorExpr, OperatorType opType) throws CompilationException {
        Expression lhs = (Expression)operatorExpr.getExprList().get(0);
        Expression rhs = (Expression)operatorExpr.getExprList().get(1);
        Expression lhsEqRhs = this.createOperatorExpression(OperatorType.EQ, lhs, rhs, operatorExpr.getHints(), operatorExpr.getSourceLocation());
        CallExpr lhsIsNull = new CallExpr(new FunctionSignature(BuiltinFunctions.IS_NULL), new ArrayList<Expression>(Collections.singletonList((Expression)SqlppRewriteUtil.deepCopy((ILangExpression)lhs))));
        lhsIsNull.setSourceLocation(operatorExpr.getSourceLocation());
        CallExpr rhsIsNull = new CallExpr(new FunctionSignature(BuiltinFunctions.IS_NULL), new ArrayList<Expression>(Collections.singletonList((Expression)SqlppRewriteUtil.deepCopy((ILangExpression)rhs))));
        rhsIsNull.setSourceLocation(operatorExpr.getSourceLocation());
        CallExpr lhsIsMissing = new CallExpr(new FunctionSignature(BuiltinFunctions.IS_MISSING), new ArrayList<Expression>(Collections.singletonList((Expression)SqlppRewriteUtil.deepCopy((ILangExpression)lhs))));
        lhsIsMissing.setSourceLocation(operatorExpr.getSourceLocation());
        CallExpr rhsIsMissing = new CallExpr(new FunctionSignature(BuiltinFunctions.IS_MISSING), new ArrayList<Expression>(Collections.singletonList((Expression)SqlppRewriteUtil.deepCopy((ILangExpression)rhs))));
        rhsIsMissing.setSourceLocation(operatorExpr.getSourceLocation());
        Expression bothAreNull = this.createOperatorExpression(OperatorType.AND, (Expression)lhsIsNull, (Expression)rhsIsNull, null, operatorExpr.getSourceLocation());
        Expression bothAreMissing = this.createOperatorExpression(OperatorType.AND, (Expression)lhsIsMissing, (Expression)rhsIsMissing, null, operatorExpr.getSourceLocation());
        Expression bothAreNullOrMissing = this.createOperatorExpression(OperatorType.OR, bothAreNull, bothAreMissing, null, operatorExpr.getSourceLocation());
        Expression eqOrNullOrMissing = this.createOperatorExpression(OperatorType.OR, lhsEqRhs, bothAreNullOrMissing, null, operatorExpr.getSourceLocation());
        CaseExpression caseExpr = new CaseExpression((Expression)new LiteralExpr((Literal)TrueLiteral.INSTANCE), new ArrayList<Expression>(Collections.singletonList(eqOrNullOrMissing)), new ArrayList<LiteralExpr>(Collections.singletonList(new LiteralExpr((Literal)TrueLiteral.INSTANCE))), (Expression)new LiteralExpr((Literal)FalseLiteral.INSTANCE));
        caseExpr.setSourceLocation(operatorExpr.getSourceLocation());
        switch (opType) {
            case NOT_DISTINCT: {
                return caseExpr;
            }
            case DISTINCT: {
                CallExpr callExpr = new CallExpr(new FunctionSignature(BuiltinFunctions.NOT), new ArrayList<CaseExpression>(Collections.singletonList(caseExpr)));
                callExpr.setSourceLocation(operatorExpr.getSourceLocation());
                return callExpr;
            }
        }
        throw new IllegalArgumentException(String.valueOf(opType));
    }

    private Expression createOperatorExpression(OperatorType opType, Expression lhs, Expression rhs, List<IExpressionAnnotation> hints, SourceLocation sourceLoc) {
        OperatorExpr comparison = new OperatorExpr();
        comparison.addOperand(lhs);
        comparison.addOperand(rhs);
        comparison.addOperator(opType);
        comparison.setSourceLocation(sourceLoc);
        if (hints != null) {
            for (IExpressionAnnotation hint : hints) {
                comparison.addHint(hint);
            }
        }
        return comparison;
    }
}

