/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.ipc.security;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Optional;
import org.apache.hyracks.api.network.INetworkSecurityConfig;

public class NetworkSecurityConfig
implements INetworkSecurityConfig {
    private static final long serialVersionUID = 2L;
    private static final char[] INTEGRITY_PASSWORD = NetworkSecurityConfig.class.getName().toCharArray();
    private final boolean sslEnabled;
    private final File keyStoreFile;
    private final File trustStoreFile;
    private final String keyStorePassword;
    private transient KeyStore keyStore;
    private transient KeyStore trustStore;

    private NetworkSecurityConfig(boolean sslEnabled, String keyStoreFile, String keyStorePassword, String trustStoreFile, KeyStore keyStore, KeyStore trustStore) {
        this.sslEnabled = sslEnabled;
        this.keyStoreFile = keyStoreFile != null ? new File(keyStoreFile) : null;
        this.keyStorePassword = keyStorePassword;
        this.trustStoreFile = trustStoreFile != null ? new File(trustStoreFile) : null;
        this.keyStore = keyStore;
        this.trustStore = trustStore;
    }

    public static NetworkSecurityConfig of(boolean sslEnabled, String keyStoreFile, String keyStorePassword, String trustStoreFile) {
        return new NetworkSecurityConfig(sslEnabled, keyStoreFile, keyStorePassword, trustStoreFile, null, null);
    }

    public static NetworkSecurityConfig of(boolean sslEnabled, KeyStore keyStore, String keyStorePassword, KeyStore trustStore) {
        return new NetworkSecurityConfig(sslEnabled, null, keyStorePassword, null, keyStore, trustStore);
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public File getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    public File getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public Optional<InetAddress> getRMIBindAddress() {
        return Optional.empty();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.writeStore(this.keyStore, out);
        this.writeStore(this.trustStore, out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.keyStore = this.readStore(in);
        this.trustStore = this.readStore(in);
    }

    private void writeStore(KeyStore keyStore, ObjectOutputStream out) throws IOException {
        if (keyStore == null) {
            out.writeUTF("");
            return;
        }
        out.writeUTF(keyStore.getType());
        try {
            keyStore.store(out, INTEGRITY_PASSWORD);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalStateException(e);
        }
    }

    private KeyStore readStore(ObjectInputStream in) throws IOException {
        String keyStoreType = in.readUTF();
        if (keyStoreType.isEmpty()) {
            return null;
        }
        try {
            KeyStore store = KeyStore.getInstance(keyStoreType);
            store.load(in, INTEGRITY_PASSWORD);
            return store;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalStateException(e);
        }
    }
}

