/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class PullSelectOutOfSpatialJoin
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.INNERJOIN) {
            return false;
        }
        AbstractBinaryJoinOperator join = (AbstractBinaryJoinOperator)op;
        if (op.getPhysicalOperator().getOperatorTag() != PhysicalOperatorTag.SPATIAL_JOIN) {
            return false;
        }
        ILogicalExpression expr = (ILogicalExpression)join.getCondition().getValue();
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression fexp = (AbstractFunctionCallExpression)expr;
        FunctionIdentifier fi = fexp.getFunctionIdentifier();
        if (!fi.equals((Object)AlgebricksBuiltinFunctions.AND)) {
            return false;
        }
        ArrayList<Mutable<ILogicalExpression>> spatialVarVarComps = new ArrayList<Mutable<ILogicalExpression>>();
        ArrayList<Mutable<ILogicalExpression>> otherPredicates = new ArrayList<Mutable<ILogicalExpression>>();
        for (Mutable arg : fexp.getArguments()) {
            if (this.isSpatialVarVar((ILogicalExpression)arg.getValue(), join, context)) {
                spatialVarVarComps.add(arg);
                continue;
            }
            otherPredicates.add((Mutable<ILogicalExpression>)arg);
        }
        if (spatialVarVarComps.isEmpty() || otherPredicates.isEmpty()) {
            return false;
        }
        ILogicalExpression pulledCond = this.makeCondition(otherPredicates, context, op);
        SelectOperator select = new SelectOperator((Mutable)new MutableObject((Object)pulledCond));
        select.setSourceLocation(op.getSourceLocation());
        ILogicalExpression newJoinCond = this.makeCondition(spatialVarVarComps, context, op);
        join.getCondition().setValue((Object)newJoinCond);
        select.getInputs().add(new MutableObject((Object)join));
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)select);
        select.recomputeSchema();
        opRef.setValue((Object)select);
        return true;
    }

    private ILogicalExpression makeCondition(List<Mutable<ILogicalExpression>> predList, IOptimizationContext context, AbstractLogicalOperator op) {
        if (predList.size() > 1) {
            IFunctionInfo finfo = context.getMetadataProvider().lookupFunction(AlgebricksBuiltinFunctions.AND);
            ScalarFunctionCallExpression conditionExpr = new ScalarFunctionCallExpression(finfo, predList);
            conditionExpr.setSourceLocation(op.getSourceLocation());
            return conditionExpr;
        }
        return (ILogicalExpression)predList.get(0).getValue();
    }

    private boolean isSpatialVarVar(ILogicalExpression expr, AbstractBinaryJoinOperator join, IOptimizationContext context) throws AlgebricksException {
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)expr;
        if (!f.getFunctionIdentifier().equals((Object)BuiltinFunctions.SPATIAL_INTERSECT)) {
            return false;
        }
        IVariableTypeEnvironment typeEnvironment = join.computeInputTypeEnvironment((ITypingContext)context);
        IAType leftType = (IAType)context.getExpressionTypeComputer().getType((ILogicalExpression)((Mutable)f.getArguments().get(0)).getValue(), context.getMetadataProvider(), typeEnvironment);
        IAType rightType = (IAType)context.getExpressionTypeComputer().getType((ILogicalExpression)((Mutable)f.getArguments().get(1)).getValue(), context.getMetadataProvider(), typeEnvironment);
        if (leftType.getTypeTag() != BuiltinType.ARECTANGLE.getTypeTag() || rightType.getTypeTag() != BuiltinType.ARECTANGLE.getTypeTag()) {
            return false;
        }
        ILogicalExpression e1 = (ILogicalExpression)((Mutable)f.getArguments().get(0)).getValue();
        if (e1.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            return false;
        }
        ILogicalExpression e2 = (ILogicalExpression)((Mutable)f.getArguments().get(1)).getValue();
        return e2.getExpressionTag() == LogicalExpressionTag.VARIABLE;
    }
}

