/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.control;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hyracks.api.control.CcId;

public class CcIdPartitionedLongFactory {
    private static final int CC_BITS = 16;
    public static final int ID_BITS = 48;
    public static final long MAX_ID = 0xFFFFFFFFFFFFL;
    private final CcId ccId;
    private final AtomicLong id;

    public CcIdPartitionedLongFactory(CcId ccId) {
        this.ccId = ccId;
        this.id = new AtomicLong(ccId.toLongMask());
    }

    protected long nextId() {
        return this.id.getAndUpdate(prev -> {
            if ((prev & 0xFFFFFFFFFFFFL) == 0xFFFFFFFFFFFFL) {
                return prev ^ 0xFFFFFFFFFFFFL;
            }
            return prev + 1L;
        });
    }

    protected long maxId() {
        long next = this.id.get();
        if ((next & 0xFFFFFFFFFFFFL) == 0L) {
            return next | 0xFFFFFFFFFFFFL;
        }
        return next - 1L;
    }

    protected void ensureMinimumId(long id) {
        if ((id & 0xFFFF000000000000L) != this.ccId.toLongMask()) {
            throw new IllegalArgumentException("cannot change ccId as part of ensureMinimumId() (was: " + Long.toHexString(this.id.get()) + ", given: " + Long.toHexString(id));
        }
        this.id.updateAndGet(current -> Math.max(current, id));
    }

    public CcId getCcId() {
        return this.ccId;
    }
}

