/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.sync;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.storage.IIndexCheckpointManager;
import org.apache.asterix.common.storage.IndexCheckpoint;
import org.apache.asterix.common.storage.ResourceReference;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.replication.api.PartitionReplica;
import org.apache.asterix.replication.messaging.DeletePartitionTask;
import org.apache.asterix.replication.messaging.PartitionResourcesListResponse;
import org.apache.asterix.replication.messaging.PartitionResourcesListTask;
import org.apache.asterix.replication.messaging.ReplicationProtocol;
import org.apache.asterix.replication.sync.FileSynchronizer;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.network.ISocketChannel;
import org.apache.hyracks.storage.am.lsm.common.impls.IndexComponentFileReference;
import org.apache.hyracks.storage.common.LocalResource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplicaFilesSynchronizer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PartitionReplica replica;
    private final INcApplicationContext appCtx;
    private final boolean deltaRecovery;

    public ReplicaFilesSynchronizer(INcApplicationContext appCtx, PartitionReplica replica, boolean deltaRecovery) {
        this.appCtx = appCtx;
        this.replica = replica;
        this.deltaRecovery = deltaRecovery;
    }

    public void sync() throws IOException {
        int partition = this.replica.getIdentifier().getPartition();
        if (!this.deltaRecovery) {
            this.deletePartitionFromReplica(partition);
        }
        LOGGER.trace("getting replica files");
        PartitionResourcesListResponse replicaResourceResponse = this.getReplicaFiles(partition);
        LOGGER.trace("got replica files");
        Map<ResourceReference, Long> resourceReferenceLongMap = this.getValidReplicaResources(replicaResourceResponse.getPartitionReplicatedResources(), replicaResourceResponse.isOrigin());
        Set<String> deletedReplicaFiles = this.cleanupReplicaInvalidResources(replicaResourceResponse, resourceReferenceLongMap);
        PersistentLocalResourceRepository localResourceRepository = (PersistentLocalResourceRepository)this.appCtx.getLocalResourceRepository();
        IReplicationStrategy replicationStrategy = this.appCtx.getReplicationManager().getReplicationStrategy();
        Set<String> masterFiles = localResourceRepository.getPartitionReplicatedFiles(partition, replicationStrategy).stream().map(StoragePathUtil::getFileRelativePath).collect(Collectors.toSet());
        LOGGER.trace("got master partition files");
        HashSet<String> replicaFiles = new HashSet<String>(replicaResourceResponse.getFiles());
        replicaFiles.removeAll(deletedReplicaFiles);
        this.syncMissingFiles(replicaFiles, masterFiles);
        this.deleteReplicaExtraFiles(replicaFiles, masterFiles);
    }

    private void deletePartitionFromReplica(int partitionId) throws IOException {
        DeletePartitionTask deletePartitionTask = new DeletePartitionTask(partitionId);
        ReplicationProtocol.sendTo(this.replica, deletePartitionTask);
        ReplicationProtocol.waitForAck(this.replica);
    }

    private void deleteReplicaExtraFiles(Set<String> replicaFiles, Set<String> masterFiles) {
        List<String> replicaInvalidFiles = replicaFiles.stream().filter(file -> !masterFiles.contains(file)).collect(Collectors.toList());
        if (!replicaInvalidFiles.isEmpty()) {
            LOGGER.debug("deleting files not on current master {} on replica {}", replicaInvalidFiles, (Object)this.replica.getIdentifier());
            this.deleteInvalidFiles(replicaInvalidFiles);
        }
    }

    private void syncMissingFiles(Set<String> replicaFiles, Set<String> masterFiles) {
        List<String> replicaMissingFiles = masterFiles.stream().filter(file -> !replicaFiles.contains(file)).collect(Collectors.toList());
        if (!replicaMissingFiles.isEmpty()) {
            LOGGER.debug("replicating missing files {} on replica {}", replicaMissingFiles, (Object)this.replica.getIdentifier());
            this.replicateMissingFiles(replicaMissingFiles);
        }
    }

    private void replicateMissingFiles(List<String> files) {
        FileSynchronizer sync = new FileSynchronizer(this.appCtx, this.replica);
        files.sort(String::compareTo);
        int missingFilesCount = files.size();
        for (int i = 0; i < missingFilesCount; ++i) {
            String file = files.get(i);
            sync.replicate(file);
            this.replica.setSyncProgress(((double)i + 1.0) / (double)missingFilesCount);
        }
    }

    private void deleteInvalidFiles(List<String> files) {
        FileSynchronizer sync = new FileSynchronizer(this.appCtx, this.replica);
        files.sort(String::compareTo);
        Collections.reverse(files);
        files.forEach(sync::delete);
        LOGGER.debug("completed invalid files deletion");
    }

    private long getResourceMasterValidSeq(ResourceReference rr) throws HyracksDataException {
        IIndexCheckpointManager iIndexCheckpointManager = this.appCtx.getIndexCheckpointManagerProvider().get(rr);
        int checkpointCount = iIndexCheckpointManager.getCheckpointCount();
        if (checkpointCount > 0) {
            IndexCheckpoint latest = iIndexCheckpointManager.getLatest();
            long masterValidSeq = latest.getMasterValidSeq();
            LOGGER.info("setting resource {} valid component seq to {}", (Object)rr, (Object)masterValidSeq);
            return masterValidSeq;
        }
        return -1L;
    }

    private Set<String> cleanupReplicaInvalidResources(PartitionResourcesListResponse replicaResourceResponse, Map<ResourceReference, Long> validReplicaResources) {
        HashSet<String> invalidFiles = new HashSet<String>();
        for (String replicaResPath : replicaResourceResponse.getFiles()) {
            ResourceReference replicaRes = ResourceReference.of((String)replicaResPath);
            if (!validReplicaResources.containsKey(replicaRes)) {
                LOGGER.debug("replica invalid file {} to be deleted", (Object)replicaRes.getFileRelativePath());
                invalidFiles.add(replicaResPath);
                continue;
            }
            if (!replicaResourceResponse.isOrigin() || replicaRes.isMetadataResource()) continue;
            Long masterValidSeq = validReplicaResources.get(replicaRes);
            IndexComponentFileReference componentFileReference = IndexComponentFileReference.of((String)replicaRes.getName());
            if (componentFileReference.getSequenceStart() <= masterValidSeq && componentFileReference.getSequenceEnd() <= masterValidSeq) continue;
            LOGGER.debug("will ask replica {} to delete file {} based on valid master valid seq {}", (Object)this.replica.getIdentifier(), (Object)replicaResPath, (Object)masterValidSeq);
            invalidFiles.add(replicaResPath);
        }
        if (!invalidFiles.isEmpty()) {
            LOGGER.debug("will delete the following files from replica {}", invalidFiles);
            this.deleteInvalidFiles(new ArrayList<String>(invalidFiles));
        }
        return invalidFiles;
    }

    private PartitionResourcesListResponse getReplicaFiles(int partition) throws IOException {
        PartitionResourcesListTask replicaFilesRequest = new PartitionResourcesListTask(partition);
        ISocketChannel channel = this.replica.getChannel();
        ByteBuffer reusableBuffer = this.replica.getReusableBuffer();
        ReplicationProtocol.sendTo(this.replica, replicaFilesRequest);
        return (PartitionResourcesListResponse)ReplicationProtocol.read(channel, reusableBuffer);
    }

    private Map<ResourceReference, Long> getValidReplicaResources(Map<String, Long> partitionReplicatedResources, boolean origin) throws HyracksDataException {
        HashMap<ResourceReference, Long> resource2ValidSeqMap = new HashMap<ResourceReference, Long>();
        for (Map.Entry<String, Long> resourceEntry : partitionReplicatedResources.entrySet()) {
            ResourceReference rr = ResourceReference.of((String)resourceEntry.getKey());
            PersistentLocalResourceRepository localResourceRepository = (PersistentLocalResourceRepository)this.appCtx.getLocalResourceRepository();
            LocalResource localResource = localResourceRepository.get(rr.getRelativePath().toString());
            if (localResource == null) continue;
            if (localResource.getId() != resourceEntry.getValue().longValue()) {
                LOGGER.info("replica has resource {} but with different resource id; ours {}, theirs {}", (Object)rr, (Object)localResource.getId(), (Object)resourceEntry.getValue());
                continue;
            }
            long resourceMasterValidSeq = origin ? this.getResourceMasterValidSeq(rr) : Integer.MAX_VALUE;
            resource2ValidSeqMap.put(rr, resourceMasterValidSeq);
        }
        return resource2ValidSeqMap;
    }
}

