/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.common.ArgumentUtils;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractStringStringStringIntEval
implements IScalarEvaluator {
    private final IEvaluatorContext ctx;
    private final IScalarEvaluator eval0;
    private final IScalarEvaluator eval1;
    private final IScalarEvaluator eval2;
    private final IScalarEvaluator eval3;
    final IPointable argPtrFirst = new VoidPointable();
    final IPointable argPtrSecond = new VoidPointable();
    final IPointable argPtrThird = new VoidPointable();
    final IPointable argPtrFourth = new VoidPointable();
    private final UTF8StringPointable strPtr1st = new UTF8StringPointable();
    private final UTF8StringPointable strPtr2nd = new UTF8StringPointable();
    private final UTF8StringPointable strPtr3rd = new UTF8StringPointable();
    private final AMutableInt32 mutableInt = new AMutableInt32(0);
    ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    DataOutput dout = this.resultStorage.getDataOutput();
    protected final FunctionIdentifier funcID;
    protected final SourceLocation sourceLoc;

    AbstractStringStringStringIntEval(IEvaluatorContext context, IScalarEvaluatorFactory eval0, IScalarEvaluatorFactory eval1, IScalarEvaluatorFactory eval2, IScalarEvaluatorFactory eval3, FunctionIdentifier funcID, SourceLocation sourceLoc) throws HyracksDataException {
        this.ctx = context;
        this.sourceLoc = sourceLoc;
        this.eval0 = eval0.createScalarEvaluator(context);
        this.eval1 = eval1.createScalarEvaluator(context);
        this.eval2 = eval2.createScalarEvaluator(context);
        this.eval3 = eval3.createScalarEvaluator(context);
        this.funcID = funcID;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.eval0.evaluate(tuple, this.argPtrFirst);
        this.eval1.evaluate(tuple, this.argPtrSecond);
        this.eval2.evaluate(tuple, this.argPtrThird);
        this.eval3.evaluate(tuple, this.argPtrFourth);
        if (PointableHelper.checkAndSetMissingOrNull(result, this.argPtrFirst, this.argPtrSecond, this.argPtrThird, this.argPtrFourth)) {
            return;
        }
        byte[] bytes0 = this.argPtrFirst.getByteArray();
        int start0 = this.argPtrFirst.getStartOffset();
        int len0 = this.argPtrFirst.getLength();
        byte[] bytes1 = this.argPtrSecond.getByteArray();
        int start1 = this.argPtrSecond.getStartOffset();
        int len1 = this.argPtrSecond.getLength();
        byte[] bytes2 = this.argPtrThird.getByteArray();
        int start2 = this.argPtrThird.getStartOffset();
        int len2 = this.argPtrThird.getLength();
        byte[] bytes3 = this.argPtrFourth.getByteArray();
        int start3 = this.argPtrFourth.getStartOffset();
        if (!this.checkStringsAndWarn(bytes0[start0], bytes1[start1], bytes2[start2])) {
            PointableHelper.setNull(result);
            return;
        }
        if (!ArgumentUtils.setInteger(this.ctx, this.sourceLoc, this.funcID, 3, bytes3, start3, this.mutableInt)) {
            PointableHelper.setNull(result);
            return;
        }
        int int4th = this.mutableInt.getIntegerValue();
        this.strPtr1st.set(bytes0, start0 + 1, len0 - 1);
        this.strPtr2nd.set(bytes1, start1 + 1, len1 - 1);
        this.strPtr3rd.set(bytes2, start2 + 1, len2 - 1);
        this.resultStorage.reset();
        this.process(this.strPtr1st, this.strPtr2nd, this.strPtr3rd, int4th, result);
    }

    protected abstract void process(UTF8StringPointable var1, UTF8StringPointable var2, UTF8StringPointable var3, int var4, IPointable var5) throws HyracksDataException;

    private boolean checkStringsAndWarn(byte actualType0, byte actualType1, byte actualType2) {
        return this.checkAndWarn(0, actualType0) && this.checkAndWarn(1, actualType1) && this.checkAndWarn(2, actualType2);
    }

    private boolean checkAndWarn(int argIdx, byte actualType) {
        if (actualType != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.ctx, (SourceLocation)this.sourceLoc, (FunctionIdentifier)this.funcID, (byte)actualType, (int)argIdx, (ATypeTag)ATypeTag.STRING);
            return false;
        }
        return true;
    }
}

