/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.storage;

import java.net.InetSocketAddress;
import org.apache.hyracks.util.NetworkUtil;

public class ReplicaIdentifier {
    private final int partition;
    private final String id;
    private volatile InetSocketAddress location;

    private ReplicaIdentifier(int partition, InetSocketAddress location) {
        this.partition = partition;
        this.location = location;
        this.id = partition + "@" + location.getHostString() + ":" + location.getPort();
    }

    public static ReplicaIdentifier of(int partition, InetSocketAddress location) {
        return new ReplicaIdentifier(partition, location);
    }

    public int getPartition() {
        return this.partition;
    }

    public InetSocketAddress getLocation() {
        return this.location;
    }

    public InetSocketAddress refreshLocation() {
        this.location = NetworkUtil.refresh((InetSocketAddress)this.location);
        return this.location;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicaIdentifier that = (ReplicaIdentifier)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id;
    }
}

