/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library.msgpack;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.util.encoding.VarLenIntEncoderDecoder;
import org.apache.hyracks.util.string.UTF8StringUtil;
import org.msgpack.core.MessagePack;

public class MessageUnpackerToADM {
    public static void unpack(ByteBuffer in, ByteBuffer out, boolean tagged) throws HyracksDataException {
        byte tag = -64;
        if (in != null) {
            tag = in.get();
        }
        if (MessagePack.Code.isFixStr((byte)tag)) {
            MessageUnpackerToADM.unpackStr(in, out, tag ^ 0xFFFFFFA0, tagged);
        } else if (MessagePack.Code.isFixInt((byte)tag)) {
            if (tagged) {
                out.put(ATypeTag.SERIALIZED_INT8_TYPE_TAG);
            }
            if (MessagePack.Code.isPosFixInt((byte)tag)) {
                out.put(tag);
            } else if (MessagePack.Code.isNegFixInt((byte)tag)) {
                out.put(tag);
            }
        } else if (MessagePack.Code.isFixedArray((byte)tag)) {
            MessageUnpackerToADM.unpackArray(in, out, tag ^ 0xFFFFFF90);
        } else if (MessagePack.Code.isFixedMap((byte)tag)) {
            MessageUnpackerToADM.unpackMap(in, out, tag ^ 0xFFFFFF80);
        } else {
            switch (tag) {
                case -61: {
                    out.put(ATypeTag.SERIALIZED_BOOLEAN_TYPE_TAG);
                    out.put((byte)1);
                    break;
                }
                case -62: {
                    out.put(ATypeTag.SERIALIZED_BOOLEAN_TYPE_TAG);
                    out.put((byte)0);
                    break;
                }
                case -64: {
                    out.put(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
                    break;
                }
                case -52: {
                    MessageUnpackerToADM.unpackUByte(in, out, tagged);
                    break;
                }
                case -51: {
                    MessageUnpackerToADM.unpackUShort(in, out, tagged);
                    break;
                }
                case -50: {
                    MessageUnpackerToADM.unpackUInt(in, out, tagged);
                    break;
                }
                case -49: {
                    MessageUnpackerToADM.unpackULong(in, out, tagged);
                    break;
                }
                case -48: {
                    MessageUnpackerToADM.unpackByte(in, out, tagged);
                    break;
                }
                case -47: {
                    MessageUnpackerToADM.unpackShort(in, out, tagged);
                    break;
                }
                case -46: {
                    MessageUnpackerToADM.unpackInt(in, out, tagged);
                    break;
                }
                case -45: {
                    MessageUnpackerToADM.unpackLong(in, out, tagged);
                    break;
                }
                case -54: {
                    MessageUnpackerToADM.unpackFloat(in, out, tagged);
                    break;
                }
                case -53: {
                    MessageUnpackerToADM.unpackDouble(in, out, tagged);
                    break;
                }
                case -39: {
                    MessageUnpackerToADM.unpackStr(in, out, Byte.toUnsignedInt(in.get()), tagged);
                    break;
                }
                case -38: {
                    MessageUnpackerToADM.unpackStr(in, out, Short.toUnsignedInt(in.getShort()), tagged);
                    break;
                }
                case -37: {
                    MessageUnpackerToADM.unpackStr(in, out, Integer.toUnsignedLong(in.getInt()), tagged);
                    break;
                }
                case -36: {
                    MessageUnpackerToADM.unpackArray(in, out, Short.toUnsignedInt(in.getShort()));
                    break;
                }
                case -35: {
                    MessageUnpackerToADM.unpackArray(in, out, Integer.toUnsignedLong(in.getInt()));
                    break;
                }
                case -34: {
                    MessageUnpackerToADM.unpackMap(in, out, Short.toUnsignedInt(in.getShort()));
                    break;
                }
                case -33: {
                    MessageUnpackerToADM.unpackMap(in, out, (int)Integer.toUnsignedLong(in.getInt()));
                    break;
                }
                default: {
                    throw HyracksDataException.create((Throwable)AsterixException.create((ErrorCode)ErrorCode.PARSER_ADM_DATA_PARSER_CAST_ERROR, (Serializable[])new Serializable[]{"msgpack tag " + tag + " ", "to an ADM type"}));
                }
            }
        }
    }

    public static void unpackByte(ByteBuffer in, ByteBuffer out, boolean tagged) {
        if (tagged) {
            out.put(ATypeTag.SERIALIZED_INT8_TYPE_TAG);
        }
        out.put(in.get());
    }

    public static void unpackShort(ByteBuffer in, ByteBuffer out, boolean tagged) {
        if (tagged) {
            out.put(ATypeTag.SERIALIZED_INT16_TYPE_TAG);
        }
        out.putShort(in.getShort());
    }

    public static void unpackInt(ByteBuffer in, ByteBuffer out, boolean tagged) {
        if (tagged) {
            out.put(ATypeTag.SERIALIZED_INT32_TYPE_TAG);
        }
        out.putInt(in.getInt());
    }

    public static void unpackLong(ByteBuffer in, ByteBuffer out, boolean tagged) {
        if (tagged) {
            out.put(ATypeTag.SERIALIZED_INT64_TYPE_TAG);
        }
        out.putLong(in.getLong());
    }

    public static void unpackUByte(ByteBuffer in, ByteBuffer out, boolean tagged) {
        if (tagged) {
            out.put(ATypeTag.SERIALIZED_INT16_TYPE_TAG);
        }
        out.putShort((short)(in.get() & 0xFF));
    }

    public static void unpackUShort(ByteBuffer in, ByteBuffer out, boolean tagged) {
        if (tagged) {
            out.put(ATypeTag.SERIALIZED_INT32_TYPE_TAG);
        }
        out.putInt(in.getShort() & 0xFFFF);
    }

    public static void unpackUInt(ByteBuffer in, ByteBuffer out, boolean tagged) {
        if (tagged) {
            out.put(ATypeTag.SERIALIZED_INT64_TYPE_TAG);
        }
        out.putLong((long)in.getInt() & 0xFFFFFFFFL);
    }

    public static void unpackULong(ByteBuffer in, ByteBuffer out, boolean tagged) {
        long val;
        if (tagged) {
            out.put(ATypeTag.SERIALIZED_INT64_TYPE_TAG);
        }
        if ((val = in.getLong()) < 0L) {
            throw new IllegalArgumentException("Integer overflow");
        }
        out.putLong(val);
    }

    public static void unpackFloat(ByteBuffer in, ByteBuffer out, boolean tagged) {
        if (tagged) {
            out.put(ATypeTag.SERIALIZED_FLOAT_TYPE_TAG);
        }
        out.putFloat(in.getFloat());
    }

    public static void unpackDouble(ByteBuffer in, ByteBuffer out, boolean tagged) {
        if (tagged) {
            out.put(ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG);
        }
        out.putDouble(in.getDouble());
    }

    public static void unpackArray(ByteBuffer in, ByteBuffer out, long uLen) throws HyracksDataException {
        int i;
        if (uLen > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Array is too long");
        }
        int count = (int)uLen;
        int offs = out.position();
        out.put(ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG);
        out.put(ATypeTag.ANY.serialize());
        int asxLenPos = out.position();
        out.putInt(-1);
        out.putInt(count);
        int slotStartOffs = out.position() + out.arrayOffset();
        for (i = 0; i < count; ++i) {
            out.putInt(65535);
        }
        for (i = 0; i < count; ++i) {
            out.putInt(slotStartOffs + i * 4, out.position() - offs);
            MessageUnpackerToADM.unpack(in, out, true);
        }
        int totalLen = out.position() - offs;
        out.putInt(asxLenPos, totalLen);
    }

    public static void unpackMap(ByteBuffer in, ByteBuffer out, int count) throws HyracksDataException {
        int i;
        int startOffs = out.position();
        out.put(ATypeTag.SERIALIZED_RECORD_TYPE_TAG);
        int totalSizeOffs = out.position();
        out.putInt(-1);
        out.put((byte)1);
        int openPartOffs = out.position();
        out.putInt(-1);
        out.putInt(openPartOffs, out.position() - startOffs);
        out.putInt(count);
        int offsetAryPos = out.position();
        int offsetArySz = count * 2;
        for (i = 0; i < offsetArySz; ++i) {
            out.putInt(-559038737);
        }
        for (i = 0; i < count; ++i) {
            int offs = out.position() + out.arrayOffset();
            int relOffs = offs - startOffs;
            MessageUnpackerToADM.unpack(in, out, false);
            int hash = UTF8StringUtil.hash((byte[])out.array(), (int)offs);
            out.putInt(offsetAryPos, hash);
            out.putInt(offsetAryPos += 4, relOffs);
            offsetAryPos += 4;
            MessageUnpackerToADM.unpack(in, out, true);
        }
        out.putInt(totalSizeOffs, out.position() - startOffs);
    }

    public static void unpackStr(ByteBuffer in, ByteBuffer out, long uLen, boolean tag) {
        if (tag) {
            out.put(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
        }
        if (Long.compareUnsigned(uLen, Integer.MAX_VALUE) > 0) {
            throw new UnsupportedOperationException("String is too long");
        }
        int len = (int)uLen;
        int strLen = UTF8StringUtil.getStringLength((byte[])in.array(), (int)(in.position() + in.arrayOffset()), (int)len);
        int adv = VarLenIntEncoderDecoder.encode((int)strLen, (byte[])out.array(), (int)(out.position() + out.arrayOffset()));
        out.position(out.position() + adv);
        System.arraycopy(in.array(), in.arrayOffset() + in.position(), out.array(), out.arrayOffset() + out.position(), len);
        out.position(out.position() + len);
        in.position(in.position() + len);
    }
}

