/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.asterix.common.functions.ExternalFunctionLanguage;
import org.apache.asterix.common.library.ILibrary;
import org.apache.asterix.external.library.ExternalLibraryClassLoader;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JavaLibrary
implements ILibrary {
    private final ExternalLibraryClassLoader cl;
    private static final Logger LOGGER = LogManager.getLogger();

    public JavaLibrary(File libDir) throws HyracksDataException, MalformedURLException {
        FilenameFilter jarFileFilter = (dir, name) -> name.endsWith(".jar");
        String[] jarsInLibDir = libDir.list(jarFileFilter);
        if (jarsInLibDir.length > 1) {
            throw new HyracksDataException("Incorrect library structure: found multiple library jars");
        }
        if (jarsInLibDir.length <= 0) {
            throw new HyracksDataException("Incorrect library structure: could not find library jar");
        }
        File libJar = new File(libDir, jarsInLibDir[0]);
        File libDependencyDir = new File(libDir.getAbsolutePath() + File.separator + "lib");
        int numDependencies = 1;
        String[] libraryDependencies = null;
        if (libDependencyDir.exists()) {
            libraryDependencies = libDependencyDir.list(jarFileFilter);
            numDependencies += libraryDependencies.length;
        }
        ClassLoader parentClassLoader = JavaLibrary.class.getClassLoader();
        URL[] urls = new URL[numDependencies];
        int count = 0;
        urls[count++] = libJar.toURI().toURL();
        if (libraryDependencies != null && libraryDependencies.length > 0) {
            for (String dependency : libraryDependencies) {
                File file = new File(libDependencyDir + File.separator + dependency);
                urls[count++] = file.toURI().toURL();
            }
        }
        this.cl = new ExternalLibraryClassLoader(urls, parentClassLoader);
    }

    public ExternalFunctionLanguage getLanguage() {
        return ExternalFunctionLanguage.JAVA;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public void close() {
        try {
            if (this.cl != null) {
                this.cl.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("Couldn't close classloader", (Throwable)e);
        }
    }
}

