/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.context.Scope;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.Sql92AggregateFunctionVisitor;
import org.apache.asterix.lang.sqlpp.util.SqlppRewriteUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppExpressionScopingVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class SqlppGroupByAggregationSugarVisitor
extends AbstractSqlppExpressionScopingVisitor {
    private final Collection<VarIdentifier> externalVars;

    public SqlppGroupByAggregationSugarVisitor(LangRewritingContext context, Collection<VarIdentifier> externalVars) {
        super(context);
        this.externalVars = externalVars;
    }

    @Override
    public Expression visit(SelectBlock selectBlock, ILangExpression arg) throws CompilationException {
        Set<VariableExpr> outerVars = this.scopeChecker.getCurrentScope().getLiveVariables().keySet();
        FromClause fromClause = selectBlock.getFromClause();
        if (selectBlock.hasFromClause()) {
            fromClause.accept(this, arg);
        }
        if (selectBlock.hasLetWhereClauses()) {
            for (AbstractClause letWhereClause : selectBlock.getLetWhereList()) {
                letWhereClause.accept((ILangVisitor)this, (Object)arg);
            }
        }
        if (selectBlock.hasGroupbyClause()) {
            SelectExpression parentSelectExpression;
            Map preGroupAnnotatedVars = this.scopeChecker.getCurrentScope().getLiveVariables();
            Set<VariableExpr> preGroupVars = preGroupAnnotatedVars.keySet();
            GroupbyClause groupbyClause = selectBlock.getGroupbyClause();
            groupbyClause.accept((ILangVisitor)this, (Object)arg);
            List<VariableExpr> groupByBindingVars = SqlppVariableUtil.getBindingVariables(groupbyClause);
            VariableExpr groupVar = groupbyClause.getGroupVar();
            if (!groupbyClause.hasGroupFieldList()) {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, groupbyClause.getSourceLocation(), new Serializable[0]);
            }
            Map<VariableExpr, Identifier> groupVarFieldMap = SqlppGroupByAggregationSugarVisitor.createGroupVarFieldMap(groupbyClause.getGroupFieldList());
            Set<VariableExpr> preGroupMappedVars = groupVarFieldMap.keySet();
            Set preGroupContextVars = Scope.findVariablesAnnotatedBy(preGroupMappedVars, (Scope.SymbolAnnotation)AbstractSqlppExpressionScopingVisitor.SqlppVariableAnnotation.CONTEXT_VARIABLE, (Map)preGroupAnnotatedVars, (SourceLocation)groupbyClause.getSourceLocation());
            Set<VariableExpr> preGroupUnmappedVars = this.getUnmappedVariables(preGroupVars, preGroupMappedVars, outerVars);
            HashSet<VariableExpr> freeVariables = new HashSet<VariableExpr>();
            HashSet<VariableExpr> freeVariablesInGbyLets = new HashSet<VariableExpr>();
            if (selectBlock.hasLetHavingClausesAfterGroupby()) {
                block5: for (AbstractClause letHavingClause : selectBlock.getLetHavingListAfterGroupby()) {
                    letHavingClause.accept((ILangVisitor)this, (Object)arg);
                    this.rewriteExpressionUsingGroupVariable((ILangExpression)letHavingClause, groupVar, groupVarFieldMap, preGroupContextVars, preGroupUnmappedVars, outerVars);
                    switch (letHavingClause.getClauseType()) {
                        case LET_CLAUSE: {
                            LetClause letClause = (LetClause)letHavingClause;
                            Set<VariableExpr> freeVariablesInClause = SqlppVariableUtil.getFreeVariables((ILangExpression)letClause.getBindingExpr());
                            freeVariablesInClause.removeAll(groupByBindingVars);
                            freeVariablesInGbyLets.addAll(freeVariablesInClause);
                            groupByBindingVars.add(letClause.getVarExpr());
                            continue block5;
                        }
                        case HAVING_CLAUSE: {
                            freeVariables.addAll(SqlppVariableUtil.getFreeVariables((ILangExpression)letHavingClause));
                            continue block5;
                        }
                    }
                    throw new IllegalStateException(String.valueOf(letHavingClause.getClauseType()));
                }
            }
            if (!(parentSelectExpression = (SelectExpression)arg).getSelectSetOperation().hasRightInputs()) {
                if (parentSelectExpression.hasOrderby()) {
                    OrderbyClause orderbyClause = parentSelectExpression.getOrderbyClause();
                    orderbyClause.accept((ILangVisitor)this, (Object)arg);
                    this.rewriteExpressionUsingGroupVariable((ILangExpression)orderbyClause, groupVar, groupVarFieldMap, preGroupContextVars, preGroupUnmappedVars, outerVars);
                    freeVariables.addAll(SqlppVariableUtil.getFreeVariables((ILangExpression)orderbyClause));
                }
                if (parentSelectExpression.hasLimit()) {
                    LimitClause limitClause = parentSelectExpression.getLimitClause();
                    limitClause.accept((ILangVisitor)this, (Object)arg);
                    this.rewriteExpressionUsingGroupVariable((ILangExpression)limitClause, groupVar, groupVarFieldMap, preGroupContextVars, preGroupUnmappedVars, outerVars);
                    freeVariables.addAll(SqlppVariableUtil.getFreeVariables((ILangExpression)limitClause));
                }
            }
            SelectClause selectClause = selectBlock.getSelectClause();
            selectClause.accept(this, arg);
            this.rewriteExpressionUsingGroupVariable((ILangExpression)selectClause, groupVar, groupVarFieldMap, preGroupContextVars, preGroupUnmappedVars, outerVars);
            freeVariables.addAll(SqlppVariableUtil.getFreeVariables((ILangExpression)selectClause));
            freeVariables.removeAll(groupByBindingVars);
            freeVariables.addAll(freeVariablesInGbyLets);
            this.removeExternalVariables(freeVariables);
            if (!groupbyClause.isGroupAll()) {
                Set decorVars = this.scopeChecker.getCurrentScope().getLiveVariables().keySet();
                decorVars.removeAll(groupByBindingVars);
                if (!decorVars.containsAll(freeVariables)) {
                    throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, groupbyClause.getSourceLocation(), new Serializable[]{decorVars + ":" + freeVariables});
                }
                decorVars.retainAll(freeVariables);
                if (!decorVars.isEmpty()) {
                    ArrayList<GbyVariableExpressionPair> decorList = new ArrayList<GbyVariableExpressionPair>();
                    if (groupbyClause.hasDecorList()) {
                        decorList.addAll(groupbyClause.getDecorPairList());
                    }
                    for (VariableExpr var : decorVars) {
                        decorList.add(new GbyVariableExpressionPair((VariableExpr)SqlppRewriteUtil.deepCopy((ILangExpression)var), (Expression)SqlppRewriteUtil.deepCopy((ILangExpression)var)));
                    }
                    groupbyClause.setDecorPairList(decorList);
                }
            }
        } else {
            selectBlock.getSelectClause().accept(this, arg);
        }
        return null;
    }

    private void removeExternalVariables(Collection<VariableExpr> freeVariables) {
        if (!this.externalVars.isEmpty()) {
            freeVariables.removeIf(ve -> this.externalVars.contains(ve.getVar()));
        }
    }

    static Map<VariableExpr, Identifier> createGroupVarFieldMap(List<Pair<Expression, Identifier>> fieldList) {
        HashMap<VariableExpr, Identifier> fieldVars = new HashMap<VariableExpr, Identifier>();
        for (Pair<Expression, Identifier> p : fieldList) {
            if (((Expression)p.first).getKind() != Expression.Kind.VARIABLE_EXPRESSION) continue;
            fieldVars.put((VariableExpr)p.first, (Identifier)p.second);
        }
        return fieldVars;
    }

    private Set<VariableExpr> getUnmappedVariables(Set<VariableExpr> preGroupByVars, Set<VariableExpr> preGroupByMappedVars, Set<VariableExpr> outerVars) {
        HashSet<VariableExpr> result = new HashSet<VariableExpr>(preGroupByVars);
        result.removeAll(preGroupByMappedVars);
        result.removeAll(outerVars);
        return result;
    }

    private void rewriteExpressionUsingGroupVariable(ILangExpression expr, VariableExpr groupVar, Map<VariableExpr, Identifier> groupVarFieldMap, Set<VariableExpr> preGroupContextVars, Set<VariableExpr> preGroupUnmappedVars, Set<VariableExpr> outerVars) throws CompilationException {
        Sql92AggregateFunctionVisitor visitor = new Sql92AggregateFunctionVisitor(this.context, groupVar, groupVarFieldMap, preGroupContextVars, preGroupUnmappedVars, outerVars);
        expr.accept((ILangVisitor)visitor, null);
    }
}

