/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.geo.evaluators.functions;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCMultiPolygon;
import com.esri.core.geometry.ogc.OGCPolygon;
import org.apache.asterix.geo.evaluators.functions.AbstractSTSingleGeometryDescriptor;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class STNRingsDescriptor
extends AbstractSTSingleGeometryDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new STNRingsDescriptor();
        }
    };

    @Override
    protected Object evaluateOGCGeometry(OGCGeometry geometry) throws HyracksDataException {
        if (geometry instanceof OGCPolygon) {
            return ((OGCPolygon)geometry).numInteriorRing() + 1;
        }
        if (geometry instanceof OGCMultiPolygon) {
            OGCMultiPolygon polygon = (OGCMultiPolygon)geometry;
            int numGeometries = polygon.numGeometries();
            int count = 0;
            for (int i = 1; i < numGeometries + 1; ++i) {
                if (!(polygon.geometryN(i) instanceof OGCPolygon)) continue;
                count += ((OGCPolygon)polygon.geometryN(i)).numInteriorRing() + 1;
            }
            return count;
        }
        throw new UnsupportedOperationException("The operation " + this.getIdentifier() + " is not supported for the type " + geometry.geometryType());
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ST_N_RINGS;
    }
}

