/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class ArrayIndexUtil {
    public static IAType getSubFieldInArrayType(ARecordType recordType, List<String> subFieldName, List<Integer> arrayDepthIndicators) throws AlgebricksException {
        IAType subType = recordType.getFieldType(subFieldName.get(0));
        for (int i = 1; i < subFieldName.size(); ++i) {
            if (subType == null) {
                return null;
            }
            if (subType.getTypeTag().equals((Object)ATypeTag.UNION) && !(subType = ((AUnionType)subType).getActualType()).getTypeTag().equals((Object)ATypeTag.OBJECT) && !subType.getTypeTag().equals((Object)ATypeTag.ARRAY) && !subType.getTypeTag().equals((Object)ATypeTag.MULTISET)) {
                throw new AsterixException(ErrorCode.COMPILATION_ERROR, new Serializable[]{"Field accessor is not defined for values of type " + subType.getTypeTag()});
            }
            if (subType.getTypeTag().equals((Object)ATypeTag.OBJECT) && arrayDepthIndicators.get(i - 1) == 0) {
                subType = ((ARecordType)subType).getFieldType(subFieldName.get(i));
                continue;
            }
            if ((subType.getTypeTag().equals((Object)ATypeTag.ARRAY) || subType.getTypeTag().equals((Object)ATypeTag.MULTISET)) && arrayDepthIndicators.get(i - 1) > 0) {
                for (int j = 0; j < arrayDepthIndicators.get(i - 1); ++j) {
                    subType = TypeComputeUtils.extractListItemType((IAType)subType);
                }
                subType = subType != null ? ((ARecordType)subType).getFieldType(subFieldName.get(i)) : null;
                continue;
            }
            throw new AsterixException(ErrorCode.COMPILATION_ERROR, new Serializable[]{arrayDepthIndicators.get(i - 1) > 0 ? "Object type given, but array depth indicator is non-zero." : "Array/multiset type given, but array depth indicator is zero."});
        }
        if (subType != null && arrayDepthIndicators.get(arrayDepthIndicators.size() - 1) > 0) {
            for (int j = 0; j < arrayDepthIndicators.get(arrayDepthIndicators.size() - 1); ++j) {
                if (!(subType instanceof AbstractCollectionType)) {
                    throw new AsterixException(ErrorCode.COMPILATION_ERROR, new Serializable[]{"Array type expected for last term, but given: " + (Serializable)(subType != null ? subType.getTypeTag() : "null")});
                }
                subType = TypeComputeUtils.extractListItemType((IAType)subType);
            }
        }
        return subType;
    }

    public static boolean isSubFieldNullable(ARecordType recordType, List<String> subFieldName, List<Integer> arrayIndicators) throws AlgebricksException {
        IAType subType = recordType.getFieldType(subFieldName.get(0));
        for (int i = 1; i < subFieldName.size(); ++i) {
            if (subType == null) {
                return true;
            }
            if (subType.getTypeTag().equals((Object)ATypeTag.UNION)) {
                if (NonTaggedFormatUtil.isOptional((IAType)subType)) {
                    return true;
                }
                if ((subType = ((AUnionType)subType).getActualType()).getTypeTag() != ATypeTag.OBJECT) {
                    throw new AsterixException("Field accessor is not defined for values of type " + subType.getTypeTag());
                }
            }
            if (subType instanceof ARecordType) {
                subType = ((ARecordType)subType).getFieldType(subFieldName.get(i));
                continue;
            }
            if (subType instanceof AbstractCollectionType && arrayIndicators.get(i - 1) > 0) {
                for (int j = 0; j < arrayIndicators.get(i - 1); ++j) {
                    subType = TypeComputeUtils.extractListItemType((IAType)subType);
                }
                subType = subType != null ? ((ARecordType)subType).getFieldType(subFieldName.get(i)) : null;
                continue;
            }
            throw CompilationException.create((ErrorCode)ErrorCode.COMPILATION_ILLEGAL_STATE, (Serializable[])new Serializable[]{"Illegal field type " + subType.getTypeTag() + " when checking field nullability"});
        }
        return subType == null || NonTaggedFormatUtil.isOptional((IAType)subType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Pair<IAType, Boolean> getNonNullableOpenFieldType(IAType fieldType, List<String> fieldName, ARecordType recType, List<Integer> arrayIndicators) throws AlgebricksException {
        Pair<IAType, Boolean> keyPairType = null;
        ARecordType subType = recType;
        boolean nullable = false;
        for (int i = 0; i < fieldName.size(); ++i) {
            if (subType instanceof AUnionType) {
                nullable = nullable || ((AUnionType)subType).isUnknownableType();
                subType = ((AUnionType)subType).getActualType();
            }
            if (subType instanceof ARecordType) {
                subType = subType.getFieldType(fieldName.get(i));
            } else {
                if (!(subType instanceof AOrderedListType) && !(subType instanceof AUnorderedListType) || arrayIndicators.get(i - 1) <= 0) throw AsterixException.create((ErrorCode)ErrorCode.COMPILATION_ILLEGAL_STATE, (Serializable[])new Serializable[]{"Unexpected type " + fieldType});
                for (int j = 0; j < arrayIndicators.get(i - 1); ++j) {
                    subType = TypeComputeUtils.extractListItemType((IAType)subType);
                }
                if (!(subType instanceof ARecordType)) throw AsterixException.create((ErrorCode)ErrorCode.COMPILATION_ILLEGAL_STATE, (Serializable[])new Serializable[]{"Unexpected type " + fieldType});
                subType = subType.getFieldType(fieldName.get(i));
            }
            if (subType != null) continue;
            keyPairType = Index.getNonNullableType(fieldType);
            break;
        }
        if (subType != null) {
            IAType keyType = ArrayIndexUtil.getSubFieldInArrayType(recType, fieldName, arrayIndicators);
            Pair<IAType, Boolean> pair = Index.getNonNullableType(keyType);
            pair.second = (Boolean)pair.second != false || ArrayIndexUtil.isSubFieldNullable(recType, fieldName, arrayIndicators);
            keyPairType = pair;
        }
        keyPairType.second = (Boolean)keyPairType.second != false || nullable;
        return keyPairType;
    }

    public static List<String> getFlattenedKeyFieldNames(List<List<String>> unnestList, List<String> projectList) {
        if (unnestList == null) {
            return projectList;
        }
        ArrayList<String> flattenedKeyNameList = new ArrayList<String>();
        for (List<String> unnestField : unnestList) {
            flattenedKeyNameList.addAll(unnestField);
        }
        if (projectList != null) {
            flattenedKeyNameList.addAll(projectList);
        }
        return flattenedKeyNameList;
    }

    public static List<Integer> getArrayDepthIndicator(List<List<String>> unnestList, List<String> projectList) {
        if (unnestList == null) {
            ArrayList<Integer> depthIndicator = new ArrayList<Integer>();
            for (String ignored : projectList) {
                depthIndicator.add(0);
            }
            return depthIndicator;
        }
        ArrayList<Integer> depthIndicatorPrefix = new ArrayList<Integer>();
        for (List<String> unnestField : unnestList) {
            for (int i = 0; i < unnestField.size() - 1; ++i) {
                depthIndicatorPrefix.add(0);
            }
            depthIndicatorPrefix.add(1);
        }
        if (projectList == null) {
            return depthIndicatorPrefix;
        }
        ArrayList<Integer> depthIndicator = new ArrayList<Integer>(depthIndicatorPrefix);
        for (int i = 0; i < projectList.size(); ++i) {
            depthIndicator.add(0);
        }
        return depthIndicator;
    }

    public static Pair<List<List<String>>, List<Integer>> unnestComplexRecordPath(List<String> fieldName, List<Integer> depthIndicators) {
        ArrayList resultantPaths = new ArrayList();
        ArrayList<Integer> resultantArrayIndicators = new ArrayList<Integer>();
        ArrayList<String> workingRecordPath = new ArrayList<String>();
        for (int i = 0; i < depthIndicators.size(); ++i) {
            workingRecordPath.add(fieldName.get(i));
            if (i != depthIndicators.size() - 1 && depthIndicators.get(i) <= 0) continue;
            resultantArrayIndicators.add(depthIndicators.get(i));
            resultantPaths.add(workingRecordPath);
            workingRecordPath = new ArrayList();
        }
        return new Pair(resultantPaths, resultantArrayIndicators);
    }

    public static void walkArrayPath(ARecordType baseRecordType, List<String> flattenedFieldName, List<Integer> flattenedDepthIndicators, TypeTrackerCommandExecutor commandExecutor) throws AlgebricksException {
        ArrayPath arrayPath = new ArrayPath(flattenedFieldName, flattenedDepthIndicators).invoke();
        List<List<String>> fieldNamesPerArray = arrayPath.fieldNamesPerArray;
        List<Integer> depthOfArraySteps = arrayPath.depthOfArraySteps;
        boolean isTrackingType = baseRecordType != null;
        ARecordType workingType = baseRecordType;
        for (int i = 0; i < fieldNamesPerArray.size(); ++i) {
            ARecordType startingStepRecordType = null;
            if (isTrackingType) {
                if (!workingType.getTypeTag().equals((Object)ATypeTag.OBJECT)) {
                    throw new AsterixException(ErrorCode.COMPILATION_ERROR, new Serializable[]{"Mismatched record type to depth-indicators. Expected record type, but got: " + workingType.getTypeTag()});
                }
                startingStepRecordType = workingType;
                workingType = (IAType)Index.getNonNullableOpenFieldType((IAType)startingStepRecordType.getSubFieldType(fieldNamesPerArray.get((int)i)), fieldNamesPerArray.get((int)i), (ARecordType)startingStepRecordType).first;
            }
            for (int j = 0; j < depthOfArraySteps.get(i); ++j) {
                if (isTrackingType && (workingType = TypeComputeUtils.extractListItemType((IAType)workingType)) == null) {
                    throw new AsterixException(ErrorCode.COMPILATION_ILLEGAL_STATE, new Serializable[]{"Expected list type inside record: " + startingStepRecordType});
                }
                boolean isFirstArrayStep = i == 0;
                boolean isFirstUnnestInStep = j == 0;
                boolean isLastUnnestInIntermediateStep = j == depthOfArraySteps.get(i) - 1 && i < fieldNamesPerArray.size() - 1;
                commandExecutor.executeActionOnEachArrayStep(startingStepRecordType, (IAType)workingType, fieldNamesPerArray.get(i), isFirstArrayStep, isFirstUnnestInStep, isLastUnnestInIntermediateStep);
            }
            if (i != fieldNamesPerArray.size() - 1) continue;
            boolean requiresOnlyOneUnnest = depthOfArraySteps.stream().reduce(0, Integer::sum).equals(1);
            boolean isNonArrayStep = depthOfArraySteps.get(i) == 0;
            commandExecutor.executeActionOnFinalArrayStep(startingStepRecordType, fieldNamesPerArray.get(i), isNonArrayStep, requiresOnlyOneUnnest);
        }
    }

    public static void walkArrayPath(List<String> flattenedFieldName, List<Integer> flattenedDepthIndicators, ActionCounterCommandExecutor commandExecutor) throws AlgebricksException {
        ArrayPath arrayPath = new ArrayPath(flattenedFieldName, flattenedDepthIndicators).invoke();
        List<List<String>> fieldNamesPerArray = arrayPath.fieldNamesPerArray;
        List<Integer> depthOfArraySteps = arrayPath.depthOfArraySteps;
        int numberOfActionsPerformed = 0;
        for (int i = 0; i < fieldNamesPerArray.size(); ++i) {
            int unnestLevel = depthOfArraySteps.get(i);
            if (i == 0) {
                commandExecutor.executeActionOnFirstArrayStep();
                ++numberOfActionsPerformed;
                --unnestLevel;
            }
            for (int j = 0; j < unnestLevel; ++j) {
                commandExecutor.executeActionOnIntermediateArrayStep(numberOfActionsPerformed++);
            }
            if (i != fieldNamesPerArray.size() - 1) continue;
            commandExecutor.executeActionOnFinalArrayStep(numberOfActionsPerformed++);
        }
    }

    private static class ArrayPath {
        private final List<String> flattenedFieldName;
        private final List<Integer> flattenedDepthIndicators;
        private List<List<String>> fieldNamesPerArray;
        private List<Integer> depthOfArraySteps;

        public ArrayPath(List<String> flattenedFieldName, List<Integer> flattenedDepthIndicators) {
            this.flattenedFieldName = flattenedFieldName;
            this.flattenedDepthIndicators = flattenedDepthIndicators;
        }

        public ArrayPath invoke() {
            this.fieldNamesPerArray = new ArrayList<List<String>>();
            this.depthOfArraySteps = new ArrayList<Integer>();
            ArrayList<String> workingRecordPath = new ArrayList<String>();
            for (int i = 0; i < this.flattenedDepthIndicators.size(); ++i) {
                workingRecordPath.add(this.flattenedFieldName.get(i));
                if (i != this.flattenedDepthIndicators.size() - 1 && this.flattenedDepthIndicators.get(i) <= 0) continue;
                this.depthOfArraySteps.add(this.flattenedDepthIndicators.get(i));
                this.fieldNamesPerArray.add(workingRecordPath);
                workingRecordPath = new ArrayList();
            }
            return this;
        }
    }

    public static interface TypeTrackerCommandExecutor {
        public void executeActionOnEachArrayStep(ARecordType var1, IAType var2, List<String> var3, boolean var4, boolean var5, boolean var6) throws AlgebricksException;

        public void executeActionOnFinalArrayStep(ARecordType var1, List<String> var2, boolean var3, boolean var4) throws AlgebricksException;
    }

    public static interface ActionCounterCommandExecutor {
        public void executeActionOnFirstArrayStep() throws AlgebricksException;

        public void executeActionOnIntermediateArrayStep(int var1) throws AlgebricksException;

        public void executeActionOnFinalArrayStep(int var1) throws AlgebricksException;
    }
}

