/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.heartbeat;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryUsage;
import java.util.TimerTask;
import org.apache.hyracks.control.common.heartbeat.HeartbeatData;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.io.profiling.IIOCounter;
import org.apache.hyracks.control.nc.io.profiling.IOCounterFactory;
import org.apache.hyracks.ipc.api.IPCPerformanceCounters;
import org.apache.hyracks.net.protocols.muxdemux.MuxDemuxPerformanceCounters;
import org.apache.hyracks.util.MXHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HeartbeatComputeTask
extends TimerTask {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IIOCounter ioCounter;
    private NodeControllerService ncs;
    private final HeartbeatData hbData;

    public HeartbeatComputeTask(NodeControllerService ncs) {
        this.ncs = ncs;
        this.hbData = new HeartbeatData();
        this.ioCounter = IOCounterFactory.INSTANCE.getIOCounter();
        this.run();
    }

    public HeartbeatData getHeartbeatData() {
        return this.hbData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HeartbeatData heartbeatData = this.hbData;
        synchronized (heartbeatData) {
            MemoryUsage heapUsage = MXHelper.memoryMXBean.getHeapMemoryUsage();
            this.hbData.heapInitSize = heapUsage.getInit();
            this.hbData.heapUsedSize = heapUsage.getUsed();
            this.hbData.heapCommittedSize = heapUsage.getCommitted();
            this.hbData.heapMaxSize = heapUsage.getMax();
            MemoryUsage nonheapUsage = MXHelper.memoryMXBean.getNonHeapMemoryUsage();
            this.hbData.nonheapInitSize = nonheapUsage.getInit();
            this.hbData.nonheapUsedSize = nonheapUsage.getUsed();
            this.hbData.nonheapCommittedSize = nonheapUsage.getCommitted();
            this.hbData.nonheapMaxSize = nonheapUsage.getMax();
            this.hbData.threadCount = MXHelper.threadMXBean.getThreadCount();
            this.hbData.peakThreadCount = MXHelper.threadMXBean.getPeakThreadCount();
            this.hbData.totalStartedThreadCount = MXHelper.threadMXBean.getTotalStartedThreadCount();
            this.hbData.systemLoadAverage = MXHelper.osMXBean.getSystemLoadAverage();
            int gcN = MXHelper.gcMXBeans.size();
            for (int i = 0; i < gcN; ++i) {
                GarbageCollectorMXBean gcMXBean = (GarbageCollectorMXBean)MXHelper.gcMXBeans.get(i);
                this.hbData.gcCollectionCounts[i] = gcMXBean.getCollectionCount();
                this.hbData.gcCollectionTimes[i] = gcMXBean.getCollectionTime();
            }
            MuxDemuxPerformanceCounters netPC = this.ncs.getNetworkManager().getPerformanceCounters();
            this.hbData.netPayloadBytesRead = netPC.getPayloadBytesRead();
            this.hbData.netPayloadBytesWritten = netPC.getPayloadBytesWritten();
            this.hbData.netSignalingBytesRead = netPC.getSignalingBytesRead();
            this.hbData.netSignalingBytesWritten = netPC.getSignalingBytesWritten();
            MuxDemuxPerformanceCounters resultNetPC = this.ncs.getResultNetworkManager().getPerformanceCounters();
            this.hbData.resultNetPayloadBytesRead = resultNetPC.getPayloadBytesRead();
            this.hbData.resultNetPayloadBytesWritten = resultNetPC.getPayloadBytesWritten();
            this.hbData.resultNetSignalingBytesRead = resultNetPC.getSignalingBytesRead();
            this.hbData.resultNetSignalingBytesWritten = resultNetPC.getSignalingBytesWritten();
            IPCPerformanceCounters ipcPC = this.ncs.getIpcSystem().getPerformanceCounters();
            this.hbData.ipcMessagesSent = ipcPC.getMessageSentCount();
            this.hbData.ipcMessageBytesSent = ipcPC.getMessageBytesSent();
            this.hbData.ipcMessagesReceived = ipcPC.getMessageReceivedCount();
            this.hbData.ipcMessageBytesReceived = ipcPC.getMessageBytesReceived();
            this.hbData.diskReads = this.ioCounter.getReads();
            this.hbData.diskWrites = this.ioCounter.getWrites();
            this.hbData.numCores = Runtime.getRuntime().availableProcessors();
            this.ncs.getNodeControllerData().notifyHeartbeat(this.hbData);
        }
        LOGGER.trace("Successfully refreshed heartbeat data");
    }
}

