/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.variablesize;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import org.apache.hyracks.storage.am.common.tuples.TypeAwareTupleWriter;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListTupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.AbstractInvertedListSearchResultFrameTupleAccessor;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.variablesize.VariableSizeInvertedListTupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.util.InvertedIndexUtils;

public class VariableSizeInvertedListSearchResultFrameTupleAccessor
extends AbstractInvertedListSearchResultFrameTupleAccessor {
    private int[] tupleStartOffsets;
    private int tupleCount;
    private int lastTupleLen;
    private IInvertedListTupleReference tupleReference;
    private ITreeIndexTupleWriter tupleWriter;

    public VariableSizeInvertedListSearchResultFrameTupleAccessor(int frameSize, ITypeTraits[] fields) throws HyracksDataException {
        super(frameSize, fields);
        this.tupleWriter = new TypeAwareTupleWriter(fields);
        this.tupleReference = new VariableSizeInvertedListTupleReference(fields);
    }

    @Override
    protected void verifyTypeTraits() throws HyracksDataException {
        InvertedIndexUtils.verifyHasVarSizeTypeTrait(this.fields);
    }

    private int getTupleLengthAtPos(int startPos) {
        this.tupleReference.reset(this.buffer.array(), startPos);
        return this.tupleWriter.bytesRequired((ITupleReference)this.tupleReference);
    }

    @Override
    public void reset(ByteBuffer buffer) {
        super.reset(buffer);
        this.tupleCount = this.getTupleCount();
        this.tupleStartOffsets = new int[this.tupleCount];
        if (this.tupleCount > 0) {
            int firstTupleLen;
            int startOff;
            int pos = startOff = 4;
            this.tupleStartOffsets[0] = 0;
            this.lastTupleLen = firstTupleLen = this.getTupleLengthAtPos(pos);
            for (int i = 1; i < this.tupleCount; ++i) {
                int len = this.getTupleLengthAtPos(pos);
                this.tupleStartOffsets[i] = this.tupleStartOffsets[i - 1] + len;
                if (i == this.tupleCount - 1) {
                    this.lastTupleLen = len;
                }
                pos += len;
            }
        }
    }

    public int getTupleStartOffset(int tupleIndex) {
        return 4 + this.tupleStartOffsets[tupleIndex];
    }

    @Override
    public int getTupleEndOffset(int tupleIndex) {
        if (tupleIndex == this.fields.length - 1) {
            return 4 + this.tupleStartOffsets[tupleIndex] + this.lastTupleLen;
        }
        if (tupleIndex < 0) {
            return 4;
        }
        return 4 + this.tupleStartOffsets[tupleIndex + 1];
    }

    @Override
    public int getTupleLength(int tupleIndex) {
        return this.getTupleEndOffset(tupleIndex) - this.getTupleStartOffset(tupleIndex);
    }

    @Override
    public int getFieldSlotsLength() {
        return 0;
    }

    public int getFieldStartOffset(int tupleIndex, int fIdx) {
        this.tupleReference.reset(this.buffer.array(), this.getTupleStartOffset(tupleIndex));
        return this.tupleReference.getFieldStart(fIdx);
    }

    public int getFieldEndOffset(int tupleIndex, int fIdx) {
        this.tupleReference.reset(this.buffer.array(), this.getTupleStartOffset(tupleIndex));
        return this.tupleReference.getFieldStart(fIdx) + this.tupleReference.getFieldLength(fIdx);
    }

    public int getFieldLength(int tupleIndex, int fIdx) {
        return this.getFieldEndOffset(tupleIndex, fIdx) - this.getFieldStartOffset(tupleIndex, fIdx);
    }

    @Override
    public int getAbsoluteFieldStartOffset(int tupleIndex, int fIdx) {
        return this.getTupleStartOffset(tupleIndex) + this.getFieldSlotsLength() + this.getFieldStartOffset(tupleIndex, fIdx);
    }
}

