/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.group.external;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.io.RunFileWriter;
import org.apache.hyracks.dataflow.std.group.AggregateType;
import org.apache.hyracks.dataflow.std.group.ISpillableTable;
import org.apache.hyracks.dataflow.std.group.external.IRunFileWriterGenerator;

public class ExternalHashGroupBy {
    private final IRunFileWriterGenerator runFileWriterGenerator;
    private FrameTupleAccessor accessor;
    private ISpillableTable table;
    private RunFileWriter[] runWriters;
    private int[] spilledNumTuples;

    public ExternalHashGroupBy(IRunFileWriterGenerator runFileWriterGenerator, ISpillableTable table, RunFileWriter[] runWriters, RecordDescriptor inRecordDescriptor) {
        this.runFileWriterGenerator = runFileWriterGenerator;
        this.table = table;
        this.runWriters = runWriters;
        this.accessor = new FrameTupleAccessor(inRecordDescriptor);
        this.spilledNumTuples = new int[runWriters.length];
    }

    public void insert(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        int tupleCount = this.accessor.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            if (this.table.insert((IFrameTupleAccessor)this.accessor, i)) continue;
            do {
                int partition;
                if ((partition = this.table.findVictimPartition((IFrameTupleAccessor)this.accessor, i)) < 0) {
                    throw new HyracksDataException("Failed to insert a new buffer into the aggregate operator!");
                }
                RunFileWriter writer = this.getPartitionWriterOrCreateOneIfNotExist(partition);
                this.flushPartitionToRun(partition, writer);
            } while (!this.table.insert((IFrameTupleAccessor)this.accessor, i));
        }
    }

    private void flushPartitionToRun(int partition, RunFileWriter writer) throws HyracksDataException {
        try {
            int n = partition;
            this.spilledNumTuples[n] = this.spilledNumTuples[n] + this.table.flushFrames(partition, (IFrameWriter)writer, AggregateType.PARTIAL);
            this.table.clear(partition);
        }
        catch (Exception ex) {
            writer.fail();
            throw HyracksDataException.create((Throwable)ex);
        }
    }

    public void flushSpilledPartitions() throws HyracksDataException {
        int i;
        try {
            for (i = 0; i < this.runWriters.length; ++i) {
                if (this.runWriters[i] == null) continue;
                this.flushPartitionToRun(i, this.runWriters[i]);
            }
        }
        finally {
            for (i = 0; i < this.runWriters.length; ++i) {
                if (this.runWriters[i] == null) continue;
                this.runWriters[i].close();
            }
        }
    }

    private RunFileWriter getPartitionWriterOrCreateOneIfNotExist(int partition) throws HyracksDataException {
        if (this.runWriters[partition] == null) {
            this.runWriters[partition] = this.runFileWriterGenerator.getRunFileWriter();
            this.runWriters[partition].open();
        }
        return this.runWriters[partition];
    }

    public int[] getSpilledNumTuples() {
        return this.spilledNumTuples;
    }
}

