/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.Preconditions;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;

public abstract class WriteSupport<T> {
    public abstract WriteContext init(Configuration var1);

    public abstract void prepareForWrite(RecordConsumer var1);

    public abstract void write(T var1);

    public String getName() {
        return null;
    }

    public FinalizedWriteContext finalizeWrite() {
        return new FinalizedWriteContext(new HashMap<String, String>());
    }

    public static final class FinalizedWriteContext {
        private final Map<String, String> extraMetaData;

        public FinalizedWriteContext(Map<String, String> extraMetaData) {
            this.extraMetaData = Collections.unmodifiableMap((Map)Preconditions.checkNotNull(extraMetaData, (String)"extraMetaData"));
        }

        public Map<String, String> getExtraMetaData() {
            return this.extraMetaData;
        }
    }

    public static final class WriteContext {
        private final MessageType schema;
        private final Map<String, String> extraMetaData;

        public WriteContext(MessageType schema, Map<String, String> extraMetaData) {
            this.schema = (MessageType)Preconditions.checkNotNull((Object)schema, (String)"schema");
            this.extraMetaData = Collections.unmodifiableMap((Map)Preconditions.checkNotNull(extraMetaData, (String)"extraMetaData"));
        }

        public MessageType getSchema() {
            return this.schema;
        }

        public Map<String, String> getExtraMetaData() {
            return this.extraMetaData;
        }
    }
}

