/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.stat;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.message.cluster.GetClusterConfigRequest;
import com.couchbase.client.core.message.cluster.GetClusterConfigResponse;
import com.couchbase.client.core.message.kv.StatRequest;
import com.couchbase.client.core.message.kv.StatResponse;
import com.couchbase.client.core.service.ServiceType;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import rx.Observable;
import rx.functions.Func0;
import rx.functions.Func1;

public class Stat {
    public static Observable<StatResponse> call(ClusterFacade core, String bucket, String key) {
        return Stat.sendStatRequests(core, bucket, key);
    }

    private static Observable<StatResponse> sendStatRequests(final ClusterFacade core, final String bucket, final String key) {
        return Observable.defer((Func0)new Func0<Observable<StatResponse>>(){

            public Observable<StatResponse> call() {
                return core.send(new GetClusterConfigRequest()).map((Func1)new Func1<GetClusterConfigResponse, List<InetAddress>>(){

                    public List<InetAddress> call(GetClusterConfigResponse response) {
                        CouchbaseBucketConfig conf = (CouchbaseBucketConfig)response.config().bucketConfig(bucket);
                        ArrayList<InetAddress> hostnames = new ArrayList<InetAddress>();
                        for (NodeInfo nodeInfo : conf.nodes()) {
                            if (!nodeInfo.services().containsKey((Object)ServiceType.BINARY)) continue;
                            hostnames.add(nodeInfo.hostname());
                        }
                        return hostnames;
                    }
                }).flatMap((Func1)new Func1<List<InetAddress>, Observable<StatResponse>>(){

                    public Observable<StatResponse> call(List<InetAddress> hostnames) {
                        ArrayList stats = new ArrayList();
                        for (InetAddress hostname : hostnames) {
                            stats.add(core.send(new StatRequest(key, hostname, bucket)));
                        }
                        if (stats.size() == 1) {
                            return (Observable)stats.get(0);
                        }
                        return Observable.mergeDelayError((Observable)Observable.from(stats));
                    }
                });
            }
        });
    }
}

