/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.annotations.RangeAnnotation;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.optimizer.rules.util.IntervalJoinUtils;
import org.apache.asterix.optimizer.rules.util.IntervalPartitions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.dataflow.common.data.partition.range.RangeMap;

public class AsterixJoinUtils {
    private static final int LEFT = 0;
    private static final int RIGHT = 1;

    private AsterixJoinUtils() {
    }

    public static void setJoinAlgorithmAndExchangeAlgo(AbstractBinaryJoinOperator op, Boolean topLevelOp, IOptimizationContext context) throws AlgebricksException {
        List varsRight;
        if (!topLevelOp.booleanValue()) {
            return;
        }
        ILogicalExpression conditionLE = (ILogicalExpression)op.getCondition().getValue();
        if (conditionLE.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return;
        }
        ArrayList<LogicalVariable> sideLeft = new ArrayList<LogicalVariable>(1);
        ArrayList<LogicalVariable> sideRight = new ArrayList<LogicalVariable>(1);
        AbstractFunctionCallExpression fexp = (AbstractFunctionCallExpression)conditionLE;
        List varsLeft = ((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue()).getSchema();
        FunctionIdentifier fi = IntervalJoinUtils.isIntervalJoinCondition((ILogicalExpression)fexp, varsLeft, varsRight = ((ILogicalOperator)((Mutable)op.getInputs().get(1)).getValue()).getSchema(), sideLeft, sideRight, 0, 1);
        if (fi == null) {
            return;
        }
        RangeAnnotation rangeAnnotation = IntervalJoinUtils.findRangeAnnotation(fexp);
        if (rangeAnnotation == null) {
            return;
        }
        RangeMap rangeMap = rangeAnnotation.getRangeMap();
        if (rangeMap.getTag(0, 0) != ATypeTag.DATETIME.serialize() && rangeMap.getTag(0, 0) != ATypeTag.DATE.serialize() && rangeMap.getTag(0, 0) != ATypeTag.TIME.serialize()) {
            IWarningCollector warningCollector = context.getWarningCollector();
            if (warningCollector.shouldWarn()) {
                warningCollector.warn(Warning.of((SourceLocation)op.getSourceLocation(), (IError)ErrorCode.INAPPLICABLE_HINT, (Serializable[])new Serializable[]{"Date, DateTime, and Time are only range hints types supported for interval joins"}));
            }
            return;
        }
        IntervalPartitions intervalPartitions = IntervalJoinUtils.createIntervalPartitions(op, fi, sideLeft, sideRight, rangeMap, context, 0, 1);
        IntervalJoinUtils.setSortMergeIntervalJoinOp(op, fi, sideLeft, sideRight, context, intervalPartitions);
    }
}

