/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.asterix.algebra.operators.CommitOperator;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DataSourceIndex;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.utils.ArrayIndexUtil;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.typecomputer.base.TypeCastUtils;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSourceIndex;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.plan.ALogicalPlanImpl;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class IntroduceSecondaryIndexInsertDeleteRule
implements IAlgebraicRewriteRule {
    private IOptimizationContext context;
    private SourceLocation sourceLoc;

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        String datasetName;
        DataverseName dataverseName;
        DelegateOperator eOp;
        AbstractLogicalOperator op0 = (AbstractLogicalOperator)opRef.getValue();
        if (op0.getOperatorTag() != LogicalOperatorTag.DELEGATE_OPERATOR && op0.getOperatorTag() != LogicalOperatorTag.SINK) {
            return false;
        }
        if (op0.getOperatorTag() == LogicalOperatorTag.DELEGATE_OPERATOR && !((eOp = (DelegateOperator)op0).getDelegate() instanceof CommitOperator)) {
            return false;
        }
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)((Mutable)op0.getInputs().get(0)).getValue();
        if (op1.getOperatorTag() != LogicalOperatorTag.INSERT_DELETE_UPSERT) {
            return false;
        }
        InsertDeleteUpsertOperator primaryIndexModificationOp = (InsertDeleteUpsertOperator)((Mutable)op0.getInputs().get(0)).getValue();
        boolean isBulkload = primaryIndexModificationOp.isBulkload();
        ILogicalExpression newRecordExpr = (ILogicalExpression)primaryIndexModificationOp.getPayloadExpression().getValue();
        List newMetaExprs = primaryIndexModificationOp.getAdditionalNonFilteringExpressions();
        LogicalVariable newMetaVar = null;
        this.sourceLoc = primaryIndexModificationOp.getSourceLocation();
        this.context = context;
        AbstractLogicalOperator inputOp = (AbstractLogicalOperator)((Mutable)primaryIndexModificationOp.getInputs().get(0)).getValue();
        LogicalVariable newRecordVar = this.getRecordVar(inputOp, newRecordExpr, 0);
        if (newMetaExprs != null && !newMetaExprs.isEmpty()) {
            if (newMetaExprs.size() > 1) {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, this.sourceLoc, new Serializable[]{"Number of meta records can't be more than 1. Number of meta records found = " + newMetaExprs.size()});
            }
            newMetaVar = this.getRecordVar(inputOp, (ILogicalExpression)((Mutable)newMetaExprs.get(0)).getValue(), 1);
        }
        DataSource datasetSource = (DataSource)primaryIndexModificationOp.getDataSource();
        MetadataProvider mp = (MetadataProvider)context.getMetadataProvider();
        Dataset dataset = mp.findDataset(dataverseName = datasetSource.getId().getDataverseName(), datasetName = datasetSource.getId().getDatasourceName());
        if (dataset == null) {
            throw new CompilationException(ErrorCode.UNKNOWN_DATASET_IN_DATAVERSE, this.sourceLoc, new Serializable[]{datasetName, dataverseName});
        }
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
            return false;
        }
        String itemTypeName = dataset.getItemTypeName();
        IAType itemType = mp.findType(dataset.getItemTypeDataverseName(), itemTypeName);
        if (itemType.getTypeTag() != ATypeTag.OBJECT) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, this.sourceLoc, new Serializable[]{"Only record types can be indexed."});
        }
        ARecordType recType = (ARecordType)itemType;
        ARecordType metaType = null;
        if (dataset.hasMetaPart()) {
            metaType = (ARecordType)mp.findType(dataset.getMetaItemTypeDataverseName(), dataset.getMetaItemTypeName());
        }
        List<Index> indexes = mp.getDatasetIndexes(dataset.getDataverseName(), dataset.getDatasetName());
        if (primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.INSERT && !primaryIndexModificationOp.isBulkload()) {
            indexes = indexes.stream().filter(index -> !index.isPrimaryKeyIndex()).collect(Collectors.toList());
        }
        InsertDeleteUpsertOperator currentTop = primaryIndexModificationOp;
        Collections.sort(indexes, (o1, o2) -> o1.getIndexType().ordinal() - o2.getIndexType().ordinal());
        int secondaryIndexTotalCnt = indexes.size() - 1;
        if (secondaryIndexTotalCnt <= 0) {
            return false;
        }
        op0.getInputs().clear();
        List filteringFields = ((InternalDatasetDetails)dataset.getDatasetDetails()).getFilterField();
        ArrayList<MutableObject> filteringExpressions = null;
        if (filteringFields != null) {
            ArrayList filteringVars = new ArrayList();
            filteringExpressions = new ArrayList<MutableObject>();
            for (Mutable filteringExpression : primaryIndexModificationOp.getAdditionalFilteringExpressions()) {
                ((ILogicalExpression)filteringExpression.getValue()).getUsedVariables(filteringVars);
                for (LogicalVariable var : filteringVars) {
                    VariableReferenceExpression varRef = new VariableReferenceExpression(var);
                    varRef.setSourceLocation(((ILogicalExpression)filteringExpression.getValue()).getSourceLocation());
                    filteringExpressions.add(new MutableObject((Object)varRef));
                }
            }
        }
        ReplicateOperator replicateOp = null;
        if (secondaryIndexTotalCnt > 1 && isBulkload) {
            replicateOp = new ReplicateOperator(secondaryIndexTotalCnt);
            replicateOp.setSourceLocation(this.sourceLoc);
            replicateOp.getInputs().add(new MutableObject((Object)currentTop));
            replicateOp.setExecutionMode(AbstractLogicalOperator.ExecutionMode.PARTITIONED);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)replicateOp);
            currentTop = replicateOp;
        }
        HashMap<IndexFieldId, LogicalVariable> fieldVarsForBeforeOperation = new HashMap<IndexFieldId, LogicalVariable>();
        HashMap<IndexFieldId, LogicalVariable> fieldVarsForNewRecord = new HashMap<IndexFieldId, LogicalVariable>();
        if (primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.INSERT || primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT || primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.DELETE) {
            this.injectFieldAccessesForIndexes(dataset, indexes, fieldVarsForNewRecord, recType, metaType, newRecordVar, newMetaVar, (ILogicalOperator)primaryIndexModificationOp, false);
            if (replicateOp != null) {
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)replicateOp);
            }
        }
        if (primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
            List beforeOpMetaVars = primaryIndexModificationOp.getBeforeOpAdditionalNonFilteringVars();
            LogicalVariable beforeOpMetaVar = beforeOpMetaVars == null ? null : (LogicalVariable)beforeOpMetaVars.get(0);
            currentTop = this.injectFieldAccessesForIndexes(dataset, indexes, fieldVarsForBeforeOperation, recType, metaType, primaryIndexModificationOp.getBeforeOpRecordVar(), beforeOpMetaVar, (ILogicalOperator)currentTop, true);
        }
        block7: for (Index index2 : indexes) {
            IndexInsertDeleteUpsertOperator indexUpdate;
            IndexInsertDeleteUpsertOperator replicateOutput;
            if (!index2.isSecondaryIndex()) continue;
            List secondaryKeyFields = null;
            List secondaryKeyTypes = null;
            List secondaryKeySources = null;
            switch (Index.IndexCategory.of((DatasetConfig.IndexType)index2.getIndexType())) {
                case VALUE: {
                    Index.ValueIndexDetails valueIndexDetails = (Index.ValueIndexDetails)index2.getIndexDetails();
                    secondaryKeyFields = valueIndexDetails.getKeyFieldNames();
                    secondaryKeyTypes = valueIndexDetails.getKeyFieldTypes();
                    secondaryKeySources = valueIndexDetails.getKeyFieldSourceIndicators();
                    break;
                }
                case TEXT: {
                    Index.TextIndexDetails textIndexDetails = (Index.TextIndexDetails)index2.getIndexDetails();
                    secondaryKeyFields = textIndexDetails.getKeyFieldNames();
                    secondaryKeyTypes = textIndexDetails.getKeyFieldTypes();
                    secondaryKeySources = textIndexDetails.getKeyFieldSourceIndicators();
                    break;
                }
                case ARRAY: {
                    break;
                }
                default: {
                    continue block7;
                }
            }
            ArrayList<LogicalVariable> secondaryKeyVars = new ArrayList<LogicalVariable>();
            ArrayList<MutableObject> secondaryExpressions = new ArrayList<MutableObject>();
            ArrayList<MutableObject> beforeOpSecondaryExpressions = new ArrayList<MutableObject>();
            if (!index2.getIndexType().equals((Object)DatasetConfig.IndexType.ARRAY)) {
                for (int i = 0; i < secondaryKeyFields.size(); ++i) {
                    IndexFieldId indexFieldId = new IndexFieldId((Integer)secondaryKeySources.get(i), (List)secondaryKeyFields.get(i), ((IAType)secondaryKeyTypes.get(i)).getTypeTag());
                    LogicalVariable skVar = (LogicalVariable)fieldVarsForNewRecord.get(indexFieldId);
                    secondaryKeyVars.add(skVar);
                    VariableReferenceExpression skVarRef = new VariableReferenceExpression(skVar);
                    skVarRef.setSourceLocation(this.sourceLoc);
                    secondaryExpressions.add(new MutableObject((Object)skVarRef));
                    if (primaryIndexModificationOp.getOperation() != InsertDeleteUpsertOperator.Kind.UPSERT) continue;
                    VariableReferenceExpression varRef = new VariableReferenceExpression((LogicalVariable)fieldVarsForBeforeOperation.get(indexFieldId));
                    varRef.setSourceLocation(this.sourceLoc);
                    beforeOpSecondaryExpressions.add(new MutableObject((Object)varRef));
                }
            }
            if (index2.getIndexType() != DatasetConfig.IndexType.RTREE) {
                Mutable<ILogicalExpression> filterExpression = primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT ? null : this.createFilterExpression(secondaryKeyVars, context.getOutputTypeEnvironment((ILogicalOperator)currentTop), index2.getIndexDetails().isOverridingKeyFieldTypes());
                DataSourceIndex dataSourceIndex = new DataSourceIndex(index2, dataverseName, datasetName, mp);
                if (index2.getIndexType() != DatasetConfig.IndexType.BTREE && index2.getIndexType() != DatasetConfig.IndexType.ARRAY && primaryIndexModificationOp.isBulkload()) {
                    boolean isPartitioned = index2.getIndexType() == DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX || index2.getIndexType() == DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX;
                    ArrayList<LogicalVariable> tokenizeKeyVars = new ArrayList<LogicalVariable>();
                    ArrayList<MutableObject> tokenizeKeyExprs = new ArrayList<MutableObject>();
                    LogicalVariable tokenVar = context.newVar();
                    tokenizeKeyVars.add(tokenVar);
                    VariableReferenceExpression tokenVarRef = new VariableReferenceExpression(tokenVar);
                    tokenVarRef.setSourceLocation(this.sourceLoc);
                    tokenizeKeyExprs.add(new MutableObject((Object)tokenVarRef));
                    Pair keyPairType = Index.getNonNullableOpenFieldType((IAType)((IAType)secondaryKeyTypes.get(0)), (List)((List)secondaryKeyFields.get(0)), (ARecordType)recType);
                    IAType secondaryKeyType = (IAType)keyPairType.first;
                    ArrayList<Object> varTypes = new ArrayList<Object>();
                    varTypes.add(NonTaggedFormatUtil.getTokenType((IAType)secondaryKeyType));
                    if (isPartitioned) {
                        LogicalVariable lengthVar = context.newVar();
                        tokenizeKeyVars.add(lengthVar);
                        VariableReferenceExpression lengthVarRef = new VariableReferenceExpression(lengthVar);
                        lengthVarRef.setSourceLocation(this.sourceLoc);
                        tokenizeKeyExprs.add(new MutableObject((Object)lengthVarRef));
                        varTypes.add(BuiltinType.SHORTWITHOUTTYPEINFO);
                    }
                    TokenizeOperator tokenUpdate = new TokenizeOperator((IDataSourceIndex)dataSourceIndex, OperatorManipulationUtil.cloneExpressions((List)primaryIndexModificationOp.getPrimaryKeyExpressions()), secondaryExpressions, tokenizeKeyVars, (Mutable)(filterExpression != null ? new MutableObject((Object)((ILogicalExpression)filterExpression.getValue()).cloneExpression()) : null), primaryIndexModificationOp.getOperation(), primaryIndexModificationOp.isBulkload(), isPartitioned, varTypes);
                    tokenUpdate.setSourceLocation(this.sourceLoc);
                    tokenUpdate.getInputs().add(new MutableObject((Object)currentTop));
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)tokenUpdate);
                    replicateOutput = tokenUpdate;
                    indexUpdate = new IndexInsertDeleteUpsertOperator((IDataSourceIndex)dataSourceIndex, OperatorManipulationUtil.cloneExpressions((List)primaryIndexModificationOp.getPrimaryKeyExpressions()), tokenizeKeyExprs, filterExpression, primaryIndexModificationOp.getOperation(), primaryIndexModificationOp.isBulkload(), primaryIndexModificationOp.getAdditionalNonFilteringExpressions() == null ? 0 : primaryIndexModificationOp.getAdditionalNonFilteringExpressions().size());
                    indexUpdate.setSourceLocation(this.sourceLoc);
                    indexUpdate.setAdditionalFilteringExpressions(OperatorManipulationUtil.cloneExpressions(filteringExpressions));
                    indexUpdate.getInputs().add(new MutableObject((Object)tokenUpdate));
                } else {
                    indexUpdate = new IndexInsertDeleteUpsertOperator((IDataSourceIndex)dataSourceIndex, OperatorManipulationUtil.cloneExpressions((List)primaryIndexModificationOp.getPrimaryKeyExpressions()), secondaryExpressions, filterExpression, primaryIndexModificationOp.getOperation(), primaryIndexModificationOp.isBulkload(), primaryIndexModificationOp.getAdditionalNonFilteringExpressions() == null ? 0 : primaryIndexModificationOp.getAdditionalNonFilteringExpressions().size());
                    indexUpdate.setSourceLocation(this.sourceLoc);
                    indexUpdate.setAdditionalFilteringExpressions(OperatorManipulationUtil.cloneExpressions(filteringExpressions));
                    replicateOutput = indexUpdate;
                    if (primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
                        indexUpdate.setBeforeOpSecondaryKeyExprs(beforeOpSecondaryExpressions);
                        if (filteringFields != null) {
                            VariableReferenceExpression varRef = new VariableReferenceExpression(primaryIndexModificationOp.getBeforeOpFilterVar());
                            varRef.setSourceLocation(this.sourceLoc);
                            indexUpdate.setBeforeOpAdditionalFilteringExpression((Mutable)new MutableObject((Object)varRef));
                        }
                    }
                    indexUpdate.getInputs().add(new MutableObject((Object)currentTop));
                    if (index2.getIndexType() == DatasetConfig.IndexType.ARRAY && !isBulkload) {
                        NestedTupleSourceOperator unnestSourceOp = new NestedTupleSourceOperator((Mutable)new MutableObject((Object)indexUpdate));
                        unnestSourceOp.setSourceLocation(this.sourceLoc);
                        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)unnestSourceOp);
                        UnnestBranchCreator unnestSIDXBranch = this.buildUnnestBranch((ILogicalOperator)unnestSourceOp, index2, newRecordVar, newMetaVar, recType, metaType, dataset.hasMetaPart());
                        unnestSIDXBranch.applyProjectDistinct(new List[0]);
                        Mutable<ILogicalExpression> mutable = filterExpression = primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT ? null : this.createFilterExpression(unnestSIDXBranch.lastFieldVars, context.getOutputTypeEnvironment(unnestSIDXBranch.currentTop), index2.getIndexDetails().isOverridingKeyFieldTypes());
                        if (filterExpression != null) {
                            unnestSIDXBranch.applyFilteringExpression(filterExpression);
                        }
                        ILogicalPlan unnestPlan = unnestSIDXBranch.buildBranch();
                        indexUpdate.getNestedPlans().add(unnestPlan);
                        if (primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
                            NestedTupleSourceOperator unnestBeforeSourceOp = new NestedTupleSourceOperator((Mutable)new MutableObject((Object)indexUpdate));
                            unnestBeforeSourceOp.setSourceLocation(this.sourceLoc);
                            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)unnestBeforeSourceOp);
                            List beforeOpMetaVars = primaryIndexModificationOp.getBeforeOpAdditionalNonFilteringVars();
                            LogicalVariable beforeOpMetaVar = beforeOpMetaVars == null ? null : (LogicalVariable)beforeOpMetaVars.get(0);
                            UnnestBranchCreator unnestBeforeSIDXBranch = this.buildUnnestBranch((ILogicalOperator)unnestBeforeSourceOp, index2, primaryIndexModificationOp.getBeforeOpRecordVar(), beforeOpMetaVar, recType, metaType, dataset.hasMetaPart());
                            unnestBeforeSIDXBranch.applyProjectDistinct(new List[0]);
                            indexUpdate.getNestedPlans().add(unnestBeforeSIDXBranch.buildBranch());
                        }
                    } else if (index2.getIndexType() == DatasetConfig.IndexType.ARRAY && isBulkload) {
                        UnnestBranchCreator unnestSIDXBranch = this.buildUnnestBranch((ILogicalOperator)currentTop, index2, newRecordVar, newMetaVar, recType, metaType, dataset.hasMetaPart());
                        unnestSIDXBranch.applyProjectDistinct(primaryIndexModificationOp.getPrimaryKeyExpressions(), primaryIndexModificationOp.getAdditionalFilteringExpressions());
                        indexUpdate.getInputs().clear();
                        this.introduceNewOp(unnestSIDXBranch.currentTop, (ILogicalOperator)indexUpdate, true);
                        secondaryExpressions = new ArrayList();
                        for (LogicalVariable var : unnestSIDXBranch.lastFieldVars) {
                            secondaryExpressions.add(new MutableObject((Object)new VariableReferenceExpression(var)));
                        }
                        indexUpdate.setSecondaryKeyExprs(secondaryExpressions);
                        filterExpression = this.createFilterExpression(unnestSIDXBranch.lastFieldVars, context.getOutputTypeEnvironment(unnestSIDXBranch.currentTop), index2.getIndexDetails().isOverridingKeyFieldTypes());
                        indexUpdate.setFilterExpression(filterExpression);
                        if (replicateOp != null) {
                            replicateOp.getOutputs().add(new MutableObject((Object)unnestSIDXBranch.currentBottom));
                            op0.getInputs().add(new MutableObject((Object)indexUpdate));
                            continue;
                        }
                    }
                }
            } else {
                VariableReferenceExpression secondaryKeyVarRef;
                Pair keyPairType = Index.getNonNullableOpenFieldType((IAType)((IAType)secondaryKeyTypes.get(0)), (List)((List)secondaryKeyFields.get(0)), (ARecordType)recType);
                IAType spatialType = (IAType)keyPairType.first;
                boolean isPointMBR = spatialType.getTypeTag() == ATypeTag.POINT || spatialType.getTypeTag() == ATypeTag.POINT3D;
                int dimension = NonTaggedFormatUtil.getNumDimensions((ATypeTag)spatialType.getTypeTag());
                int numKeys = isPointMBR && isBulkload ? dimension : dimension * 2;
                ArrayList<LogicalVariable> keyVarList = new ArrayList<LogicalVariable>();
                ArrayList<MutableObject> keyExprList = new ArrayList<MutableObject>();
                for (int i = 0; i < numKeys; ++i) {
                    LogicalVariable keyVar = context.newVar();
                    keyVarList.add(keyVar);
                    ScalarFunctionCallExpression createMBR = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CREATE_MBR));
                    createMBR.setSourceLocation(this.sourceLoc);
                    VariableReferenceExpression secondaryKeyVarRef2 = new VariableReferenceExpression((LogicalVariable)secondaryKeyVars.get(0));
                    secondaryKeyVarRef2.setSourceLocation(this.sourceLoc);
                    createMBR.getArguments().add(new MutableObject((Object)secondaryKeyVarRef2));
                    createMBR.getArguments().add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(dimension)))));
                    createMBR.getArguments().add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(i)))));
                    keyExprList.add(new MutableObject((Object)createMBR));
                }
                secondaryExpressions.clear();
                for (LogicalVariable secondaryKeyVar : keyVarList) {
                    secondaryKeyVarRef = new VariableReferenceExpression(secondaryKeyVar);
                    secondaryKeyVarRef.setSourceLocation(this.sourceLoc);
                    secondaryExpressions.add(new MutableObject((Object)secondaryKeyVarRef));
                }
                if (isPointMBR && isBulkload) {
                    for (LogicalVariable secondaryKeyVar : keyVarList) {
                        secondaryKeyVarRef = new VariableReferenceExpression(secondaryKeyVar);
                        secondaryKeyVarRef.setSourceLocation(this.sourceLoc);
                        secondaryExpressions.add(new MutableObject((Object)secondaryKeyVarRef));
                    }
                }
                AssignOperator assignCoordinates = new AssignOperator(keyVarList, keyExprList);
                assignCoordinates.setSourceLocation(this.sourceLoc);
                assignCoordinates.getInputs().add(new MutableObject((Object)currentTop));
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignCoordinates);
                replicateOutput = assignCoordinates;
                Mutable<ILogicalExpression> filterExpression = null;
                AssignOperator originalAssignCoordinates = null;
                if (primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
                    ArrayList<LogicalVariable> originalKeyVarList = new ArrayList<LogicalVariable>();
                    ArrayList<MutableObject> originalKeyExprList = new ArrayList<MutableObject>();
                    for (int i = 0; i < numKeys; ++i) {
                        LogicalVariable keyVar = context.newVar();
                        originalKeyVarList.add(keyVar);
                        ScalarFunctionCallExpression createMBR = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CREATE_MBR));
                        createMBR.setSourceLocation(this.sourceLoc);
                        createMBR.getArguments().add(new MutableObject((Object)((ILogicalExpression)((Mutable)beforeOpSecondaryExpressions.get(0)).getValue()).cloneExpression()));
                        createMBR.getArguments().add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(dimension)))));
                        createMBR.getArguments().add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(i)))));
                        originalKeyExprList.add(new MutableObject((Object)createMBR));
                    }
                    beforeOpSecondaryExpressions.clear();
                    for (LogicalVariable secondaryKeyVar : originalKeyVarList) {
                        VariableReferenceExpression secondaryKeyVarRef3 = new VariableReferenceExpression(secondaryKeyVar);
                        secondaryKeyVarRef3.setSourceLocation(this.sourceLoc);
                        beforeOpSecondaryExpressions.add(new MutableObject((Object)secondaryKeyVarRef3));
                    }
                    originalAssignCoordinates = new AssignOperator(originalKeyVarList, originalKeyExprList);
                    originalAssignCoordinates.setSourceLocation(this.sourceLoc);
                    originalAssignCoordinates.getInputs().add(new MutableObject((Object)assignCoordinates));
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)originalAssignCoordinates);
                } else {
                    boolean forceFilter = (Boolean)keyPairType.second;
                    filterExpression = this.createFilterExpression(keyVarList, context.getOutputTypeEnvironment((ILogicalOperator)assignCoordinates), forceFilter);
                }
                DataSourceIndex dataSourceIndex = new DataSourceIndex(index2, dataverseName, datasetName, mp);
                indexUpdate = new IndexInsertDeleteUpsertOperator((IDataSourceIndex)dataSourceIndex, OperatorManipulationUtil.cloneExpressions((List)primaryIndexModificationOp.getPrimaryKeyExpressions()), secondaryExpressions, filterExpression, primaryIndexModificationOp.getOperation(), primaryIndexModificationOp.isBulkload(), primaryIndexModificationOp.getAdditionalNonFilteringExpressions() == null ? 0 : primaryIndexModificationOp.getAdditionalNonFilteringExpressions().size());
                indexUpdate.setSourceLocation(this.sourceLoc);
                indexUpdate.setAdditionalFilteringExpressions(OperatorManipulationUtil.cloneExpressions(filteringExpressions));
                if (primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
                    if (filteringFields != null) {
                        VariableReferenceExpression varRef = new VariableReferenceExpression(primaryIndexModificationOp.getBeforeOpFilterVar());
                        varRef.setSourceLocation(this.sourceLoc);
                        indexUpdate.setBeforeOpAdditionalFilteringExpression((Mutable)new MutableObject((Object)varRef));
                    }
                    indexUpdate.setBeforeOpSecondaryKeyExprs(beforeOpSecondaryExpressions);
                    indexUpdate.getInputs().add(new MutableObject((Object)originalAssignCoordinates));
                } else {
                    indexUpdate.getInputs().add(new MutableObject((Object)assignCoordinates));
                }
            }
            if (primaryIndexModificationOp.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
                indexUpdate.setUpsertIndicatorExpr((Mutable)new MutableObject((Object)new VariableReferenceExpression(primaryIndexModificationOp.getUpsertIndicatorVar())));
            }
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)indexUpdate);
            if (!primaryIndexModificationOp.isBulkload() || secondaryIndexTotalCnt == 1) {
                currentTop = indexUpdate;
            } else {
                replicateOp.getOutputs().add(new MutableObject((Object)replicateOutput));
                if (index2.isPrimaryKeyIndex()) {
                    int positionOfSecondaryPrimaryIndex = replicateOp.getOutputs().size() - 1;
                    replicateOp.getOutputMaterializationFlags()[positionOfSecondaryPrimaryIndex] = true;
                }
            }
            if (!primaryIndexModificationOp.isBulkload()) continue;
            op0.getInputs().add(new MutableObject((Object)indexUpdate));
        }
        if (!primaryIndexModificationOp.isBulkload()) {
            op0.getInputs().clear();
            op0.getInputs().add(new MutableObject((Object)currentTop));
        }
        return true;
    }

    private UnnestBranchCreator buildUnnestBranch(ILogicalOperator unnestSourceOp, Index index, LogicalVariable recordVar, LogicalVariable metaVar, ARecordType recType, ARecordType metaType, boolean hasMetaPart) throws AlgebricksException {
        Index.ArrayIndexDetails arrayIndexDetails = (Index.ArrayIndexDetails)index.getIndexDetails();
        ArrayDeque<Integer> keyPositionQueue = new ArrayDeque<Integer>();
        for (int i = 0; i < arrayIndexDetails.getElementList().size(); ++i) {
            Index.ArrayIndexElement e = (Index.ArrayIndexElement)arrayIndexDetails.getElementList().get(i);
            if (e.getUnnestList().isEmpty()) {
                keyPositionQueue.addLast(i);
                continue;
            }
            keyPositionQueue.addFirst(i);
        }
        Index.ArrayIndexElement workingElement = (Index.ArrayIndexElement)arrayIndexDetails.getElementList().get((Integer)keyPositionQueue.getFirst());
        int sourceIndicatorForBaseRecord = workingElement.getSourceIndicator();
        LogicalVariable sourceVarForBaseRecord = hasMetaPart ? (sourceIndicatorForBaseRecord == 0 ? recordVar : metaVar) : recordVar;
        UnnestBranchCreator branchCreator = new UnnestBranchCreator(sourceVarForBaseRecord, unnestSourceOp);
        int initialKeyPositionQueueSize = keyPositionQueue.size();
        HashSet<LogicalVariable> secondaryKeyVars = new HashSet<LogicalVariable>();
        for (int i = 0; i < initialKeyPositionQueueSize; ++i) {
            boolean isOpenOrNestedField;
            ARecordType recordType;
            int workingKeyPos = (Integer)keyPositionQueue.pollFirst();
            workingElement = (Index.ArrayIndexElement)arrayIndexDetails.getElementList().get(workingKeyPos);
            int sourceIndicator = workingElement.getSourceIndicator();
            ARecordType aRecordType = hasMetaPart ? (sourceIndicator == 0 ? recType : metaType) : (recordType = recType);
            if (workingElement.getUnnestList().isEmpty()) {
                List atomicFieldName = (List)workingElement.getProjectList().get(0);
                isOpenOrNestedField = atomicFieldName.size() != 1 || !recordType.isClosedField((String)atomicFieldName.get(0));
                LogicalVariable newVar = this.context.newVar();
                VariableReferenceExpression varRef = new VariableReferenceExpression(sourceVarForBaseRecord);
                varRef.setSourceLocation(this.sourceLoc);
                AbstractFunctionCallExpression newVarRef = isOpenOrNestedField ? this.getFieldAccessFunction((Mutable<ILogicalExpression>)new MutableObject((Object)varRef), recordType.getFieldIndex((String)atomicFieldName.get(0)), atomicFieldName) : this.getFieldAccessFunction((Mutable<ILogicalExpression>)new MutableObject((Object)varRef), -1, atomicFieldName);
                AssignOperator newAssignOp = new AssignOperator(newVar, (Mutable)new MutableObject((Object)newVarRef));
                newAssignOp.setSourceLocation(this.sourceLoc);
                branchCreator.currentTop = this.introduceNewOp(branchCreator.currentTop, (ILogicalOperator)newAssignOp, true);
                secondaryKeyVars.add(newVar);
            } else {
                isOpenOrNestedField = ((List)workingElement.getUnnestList().get(0)).size() > 1 || !recordType.isClosedField((String)((List)workingElement.getUnnestList().get(0)).get(0));
                List flatFirstFieldName = ArrayIndexUtil.getFlattenedKeyFieldNames((List)workingElement.getUnnestList(), (List)((List)workingElement.getProjectList().get(0)));
                List firstArrayIndicator = ArrayIndexUtil.getArrayDepthIndicator((List)workingElement.getUnnestList(), (List)((List)workingElement.getProjectList().get(0)));
                ArrayIndexUtil.walkArrayPath((ARecordType)(isOpenOrNestedField ? null : recordType), (List)flatFirstFieldName, (List)firstArrayIndicator, (ArrayIndexUtil.TypeTrackerCommandExecutor)branchCreator);
                for (int j = 1; j < workingElement.getProjectList().size(); ++j) {
                    LogicalVariable newVar = this.context.newVar();
                    AbstractFunctionCallExpression newVarRef = this.getFieldAccessFunction((Mutable<ILogicalExpression>)new MutableObject((Object)branchCreator.createLastRecordVarRef()), -1, (List)workingElement.getProjectList().get(j));
                    AssignOperator newAssignOp = new AssignOperator(newVar, (Mutable)new MutableObject((Object)newVarRef));
                    newAssignOp.setSourceLocation(this.sourceLoc);
                    branchCreator.currentTop = this.introduceNewOp(branchCreator.currentTop, (ILogicalOperator)newAssignOp, true);
                    secondaryKeyVars.add(newVar);
                }
            }
            branchCreator.lowerIsFirstWalkFlag();
            secondaryKeyVars.addAll(branchCreator.lastFieldVars);
        }
        branchCreator.lastFieldVars.clear();
        branchCreator.lastFieldVars.addAll(secondaryKeyVars);
        return branchCreator;
    }

    private LogicalVariable getRecordVar(AbstractLogicalOperator inputOp, ILogicalExpression recordExpr, int expectedRecordIndex) throws AlgebricksException {
        if (this.exprIsRecord(this.context.getOutputTypeEnvironment((ILogicalOperator)inputOp), recordExpr)) {
            return ((VariableReferenceExpression)recordExpr).getVariableReference();
        }
        FunctionIdentifier fid = null;
        AbstractLogicalOperator currentInputOp = inputOp;
        while (fid != BuiltinFunctions.OPEN_RECORD_CONSTRUCTOR) {
            AssignOperator assignOp;
            ILogicalExpression assignExpr;
            if (currentInputOp.getInputs().isEmpty()) {
                return null;
            }
            if ((currentInputOp = (AbstractLogicalOperator)((Mutable)currentInputOp.getInputs().get(0)).getValue()).getOperatorTag() != LogicalOperatorTag.ASSIGN || (assignExpr = (ILogicalExpression)((Mutable)(assignOp = (AssignOperator)currentInputOp).getExpressions().get(expectedRecordIndex)).getValue()).getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
            ScalarFunctionCallExpression funcExpr = (ScalarFunctionCallExpression)((Mutable)assignOp.getExpressions().get(expectedRecordIndex)).getValue();
            fid = funcExpr.getFunctionIdentifier();
        }
        return (LogicalVariable)((AssignOperator)currentInputOp).getVariables().get(0);
    }

    private boolean exprIsRecord(IVariableTypeEnvironment typeEnvironment, ILogicalExpression recordExpr) throws AlgebricksException {
        if (recordExpr.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            IAType type = (IAType)typeEnvironment.getType(recordExpr);
            return type != null && type.getTypeTag() == ATypeTag.OBJECT;
        }
        return false;
    }

    private ILogicalOperator injectFieldAccessesForIndexes(Dataset dataset, List<Index> indexes, Map<IndexFieldId, LogicalVariable> fieldAccessVars, ARecordType recType, ARecordType metaType, LogicalVariable recordVar, LogicalVariable metaVar, ILogicalOperator currentTop, boolean afterOp) throws AlgebricksException {
        ArrayList<LogicalVariable> vars = new ArrayList<LogicalVariable>();
        ArrayList<MutableObject> exprs = new ArrayList<MutableObject>();
        SourceLocation sourceLoc = currentTop.getSourceLocation();
        for (Index index : indexes) {
            List indicators;
            List skTypes;
            List skNames;
            if (index.isPrimaryIndex() || index.getIndexType() == DatasetConfig.IndexType.ARRAY) continue;
            switch (Index.IndexCategory.of((DatasetConfig.IndexType)index.getIndexType())) {
                case VALUE: {
                    Index.ValueIndexDetails valueIndexDetails = (Index.ValueIndexDetails)index.getIndexDetails();
                    skNames = valueIndexDetails.getKeyFieldNames();
                    skTypes = valueIndexDetails.getKeyFieldTypes();
                    indicators = valueIndexDetails.getKeyFieldSourceIndicators();
                    break;
                }
                case TEXT: {
                    Index.TextIndexDetails textIndexDetails = (Index.TextIndexDetails)index.getIndexDetails();
                    skNames = textIndexDetails.getKeyFieldNames();
                    skTypes = textIndexDetails.getKeyFieldTypes();
                    indicators = textIndexDetails.getKeyFieldSourceIndicators();
                    break;
                }
                default: {
                    throw new CompilationException(ErrorCode.COMPILATION_UNKNOWN_INDEX_TYPE, new Serializable[]{String.valueOf(index.getIndexType())});
                }
            }
            for (int i = 0; i < skNames.size(); ++i) {
                AbstractFunctionCallExpression theFieldAccessFunc;
                ARecordType sourceType;
                IndexFieldId indexFieldId = new IndexFieldId((Integer)indicators.get(i), (List)skNames.get(i), ((IAType)skTypes.get(i)).getTypeTag());
                if (fieldAccessVars.containsKey(indexFieldId)) continue;
                ARecordType aRecordType = dataset.hasMetaPart() ? ((Integer)indicators.get(i) == 0 ? recType : metaType) : (sourceType = recType);
                LogicalVariable sourceVar = dataset.hasMetaPart() ? ((Integer)indicators.get(i) == 0 ? recordVar : metaVar) : recordVar;
                LogicalVariable fieldVar = this.context.newVar();
                VariableReferenceExpression varRef = new VariableReferenceExpression(sourceVar);
                varRef.setSourceLocation(sourceLoc);
                IAType fieldType = sourceType.getSubFieldType(indexFieldId.fieldName);
                if (fieldType == null) {
                    this.context.addNotToBeInlinedVar(fieldVar);
                    AbstractFunctionCallExpression fieldAccessFunc = this.getFieldAccessFunction((Mutable<ILogicalExpression>)new MutableObject((Object)varRef), -1, indexFieldId.fieldName);
                    theFieldAccessFunc = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)(index.isEnforced() ? BuiltinFunctions.CAST_TYPE : BuiltinFunctions.CAST_TYPE_LAX)));
                    theFieldAccessFunc.setSourceLocation(sourceLoc);
                    theFieldAccessFunc.getArguments().add(new MutableObject((Object)fieldAccessFunc));
                    TypeCastUtils.setRequiredAndInputTypes((AbstractFunctionCallExpression)theFieldAccessFunc, (IAType)((IAType)skTypes.get(i)), (IAType)BuiltinType.ANY);
                } else {
                    int pos = indexFieldId.fieldName.size() > 1 ? -1 : sourceType.getFieldIndex(indexFieldId.fieldName.get(0));
                    theFieldAccessFunc = this.getFieldAccessFunction((Mutable<ILogicalExpression>)new MutableObject((Object)varRef), pos, indexFieldId.fieldName);
                }
                vars.add(fieldVar);
                exprs.add(new MutableObject((Object)theFieldAccessFunc));
                fieldAccessVars.put(indexFieldId, fieldVar);
            }
        }
        if (!vars.isEmpty()) {
            AssignOperator castedFieldAssignOperator = new AssignOperator(vars, exprs);
            castedFieldAssignOperator.setSourceLocation(sourceLoc);
            return this.introduceNewOp(currentTop, (ILogicalOperator)castedFieldAssignOperator, afterOp);
        }
        return currentTop;
    }

    private ILogicalOperator introduceNewOp(ILogicalOperator currentTopOp, ILogicalOperator newOp, boolean afterOp) throws AlgebricksException {
        if (afterOp) {
            newOp.getInputs().add(new MutableObject((Object)currentTopOp));
            this.context.computeAndSetTypeEnvironmentForOperator(newOp);
            return newOp;
        }
        newOp.getInputs().addAll(currentTopOp.getInputs());
        currentTopOp.getInputs().clear();
        currentTopOp.getInputs().add(new MutableObject((Object)newOp));
        this.context.computeAndSetTypeEnvironmentForOperator(newOp);
        this.context.computeAndSetTypeEnvironmentForOperator(currentTopOp);
        return currentTopOp;
    }

    private AbstractFunctionCallExpression getFieldAccessFunction(Mutable<ILogicalExpression> varRef, int fieldPos, List<String> fieldName) {
        ScalarFunctionCallExpression func;
        if (fieldName.size() == 1 && fieldPos != -1) {
            MutableObject indexRef = new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(fieldPos))));
            ScalarFunctionCallExpression fnExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.FIELD_ACCESS_BY_INDEX), new Mutable[]{varRef, indexRef});
            fnExpr.setSourceLocation(this.sourceLoc);
            return fnExpr;
        }
        if (fieldName.size() > 1) {
            AOrderedList fieldList = IntroduceSecondaryIndexInsertDeleteRule.stringListToAOrderedList(fieldName);
            Mutable<ILogicalExpression> fieldRef = IntroduceSecondaryIndexInsertDeleteRule.constantToMutableLogicalExpression((IAObject)fieldList);
            func = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.FIELD_ACCESS_NESTED), new Mutable[]{varRef, fieldRef});
        } else {
            AString fieldList = new AString(fieldName.get(0));
            Mutable<ILogicalExpression> fieldRef = IntroduceSecondaryIndexInsertDeleteRule.constantToMutableLogicalExpression((IAObject)fieldList);
            func = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.FIELD_ACCESS_BY_NAME), new Mutable[]{varRef, fieldRef});
        }
        func.setSourceLocation(this.sourceLoc);
        return func;
    }

    private static AOrderedList stringListToAOrderedList(List<String> fields) {
        AOrderedList fieldList = new AOrderedList(new AOrderedListType((IAType)BuiltinType.ASTRING, null));
        for (int i = 0; i < fields.size(); ++i) {
            fieldList.add((IAObject)new AString(fields.get(i)));
        }
        return fieldList;
    }

    private static Mutable<ILogicalExpression> constantToMutableLogicalExpression(IAObject constantObject) {
        return new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue(constantObject)));
    }

    private Mutable<ILogicalExpression> createFilterExpression(List<LogicalVariable> secondaryKeyVars, IVariableTypeEnvironment typeEnv, boolean forceFilter) throws AlgebricksException {
        Mutable filterExpression;
        ArrayList<MutableObject> filterExpressions = new ArrayList<MutableObject>();
        for (LogicalVariable secondaryKeyVar : secondaryKeyVars) {
            IAType secondaryKeyType = (IAType)typeEnv.getVarType(secondaryKeyVar);
            if (!NonTaggedFormatUtil.isOptional((IAType)secondaryKeyType) && !forceFilter) continue;
            VariableReferenceExpression secondaryKeyVarRef = new VariableReferenceExpression(secondaryKeyVar);
            secondaryKeyVarRef.setSourceLocation(this.sourceLoc);
            ScalarFunctionCallExpression isUnknownFuncExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.IS_UNKNOWN), new Mutable[]{new MutableObject((Object)secondaryKeyVarRef)});
            isUnknownFuncExpr.setSourceLocation(this.sourceLoc);
            ScalarFunctionCallExpression notFuncExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.NOT), new Mutable[]{new MutableObject((Object)isUnknownFuncExpr)});
            notFuncExpr.setSourceLocation(this.sourceLoc);
            filterExpressions.add(new MutableObject((Object)notFuncExpr));
        }
        if (filterExpressions.isEmpty()) {
            return null;
        }
        if (filterExpressions.size() > 1) {
            ScalarFunctionCallExpression andExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.AND), filterExpressions);
            andExpr.setSourceLocation(this.sourceLoc);
            filterExpression = new MutableObject((Object)andExpr);
        } else {
            filterExpression = (Mutable)filterExpressions.get(0);
        }
        return filterExpression;
    }

    private final class IndexFieldId {
        private final int indicator;
        private final List<String> fieldName;
        private final ATypeTag fieldType;

        private IndexFieldId(int indicator, List<String> fieldName, ATypeTag fieldType) {
            this.indicator = indicator;
            this.fieldName = fieldName;
            this.fieldType = fieldType;
        }

        public int hashCode() {
            int result = this.indicator;
            result = 31 * result + this.fieldName.hashCode();
            result = 31 * result + this.fieldType.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexFieldId that = (IndexFieldId)o;
            if (this.indicator != that.indicator) {
                return false;
            }
            if (!this.fieldName.equals(that.fieldName)) {
                return false;
            }
            return this.fieldType == that.fieldType;
        }
    }

    private class UnnestBranchCreator
    implements ArrayIndexUtil.TypeTrackerCommandExecutor {
        private final List<LogicalVariable> lastFieldVars;
        private LogicalVariable lastRecordVar;
        private ILogicalOperator currentTop;
        private ILogicalOperator currentBottom;
        private boolean isFirstWalk = true;

        public UnnestBranchCreator(LogicalVariable recordVar, ILogicalOperator sourceOperator) {
            this.lastRecordVar = recordVar;
            this.currentTop = sourceOperator;
            this.lastFieldVars = new ArrayList<LogicalVariable>();
        }

        public ILogicalPlan buildBranch() {
            return new ALogicalPlanImpl((Mutable)new MutableObject((Object)this.currentTop));
        }

        public void lowerIsFirstWalkFlag() {
            this.isFirstWalk = false;
        }

        public VariableReferenceExpression createLastRecordVarRef() {
            VariableReferenceExpression varRef = new VariableReferenceExpression(this.lastRecordVar);
            varRef.setSourceLocation(IntroduceSecondaryIndexInsertDeleteRule.this.sourceLoc);
            return varRef;
        }

        @SafeVarargs
        public final void applyProjectDistinct(List<Mutable<ILogicalExpression>> ... auxiliaryExpressions) throws AlgebricksException {
            ArrayList<LogicalVariable> projectVars = new ArrayList<LogicalVariable>(this.lastFieldVars);
            List distinctVarRefs = OperatorManipulationUtil.createVariableReferences(projectVars, (SourceLocation)IntroduceSecondaryIndexInsertDeleteRule.this.sourceLoc);
            if (auxiliaryExpressions.length > 0) {
                for (List<Mutable<ILogicalExpression>> exprList : auxiliaryExpressions) {
                    if (exprList == null) continue;
                    if (exprList.stream().anyMatch(e -> !((ILogicalExpression)e.getValue()).getExpressionTag().equals((Object)LogicalExpressionTag.VARIABLE))) {
                        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, IntroduceSecondaryIndexInsertDeleteRule.this.sourceLoc, new Serializable[]{"Given auxiliary expression list contains non-variable reference expressions. We cannot apply DISTINCT to this expression at this stage."});
                    }
                    distinctVarRefs.addAll(OperatorManipulationUtil.cloneExpressions(exprList));
                    for (Mutable e2 : OperatorManipulationUtil.cloneExpressions(exprList)) {
                        projectVars.add(((VariableReferenceExpression)e2.getValue()).getVariableReference());
                    }
                }
            }
            ProjectOperator projectOperator = new ProjectOperator(projectVars);
            projectOperator.setSourceLocation(IntroduceSecondaryIndexInsertDeleteRule.this.sourceLoc);
            this.currentTop = IntroduceSecondaryIndexInsertDeleteRule.this.introduceNewOp(this.currentTop, (ILogicalOperator)projectOperator, true);
            DistinctOperator distinctOperator = new DistinctOperator(distinctVarRefs);
            distinctOperator.setSourceLocation(IntroduceSecondaryIndexInsertDeleteRule.this.sourceLoc);
            this.currentTop = IntroduceSecondaryIndexInsertDeleteRule.this.introduceNewOp(this.currentTop, (ILogicalOperator)distinctOperator, true);
        }

        public void applyFilteringExpression(Mutable<ILogicalExpression> filterExpression) throws AlgebricksException {
            SelectOperator selectOperator = new SelectOperator(filterExpression, false, null);
            selectOperator.setSourceLocation(IntroduceSecondaryIndexInsertDeleteRule.this.sourceLoc);
            this.currentTop = IntroduceSecondaryIndexInsertDeleteRule.this.introduceNewOp(this.currentTop, (ILogicalOperator)selectOperator, true);
        }

        public void executeActionOnEachArrayStep(ARecordType startingStepRecordType, IAType workingType, List<String> fieldName, boolean isFirstArrayStep, boolean isFirstUnnestInStep, boolean isLastUnnestInIntermediateStep) throws AlgebricksException {
            VariableReferenceExpression accessToUnnestVar;
            if (!this.isFirstWalk) {
                return;
            }
            if (isFirstUnnestInStep) {
                accessToUnnestVar = startingStepRecordType != null ? IntroduceSecondaryIndexInsertDeleteRule.this.getFieldAccessFunction((Mutable<ILogicalExpression>)new MutableObject((Object)this.createLastRecordVarRef()), startingStepRecordType.getFieldIndex(fieldName.get(0)), fieldName) : IntroduceSecondaryIndexInsertDeleteRule.this.getFieldAccessFunction((Mutable<ILogicalExpression>)new MutableObject((Object)this.createLastRecordVarRef()), -1, fieldName);
            } else {
                accessToUnnestVar = new VariableReferenceExpression(this.lastFieldVars.get(0));
                this.lastFieldVars.clear();
            }
            UnnestingFunctionCallExpression scanCollection = new UnnestingFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.SCAN_COLLECTION), Collections.singletonList(new MutableObject((Object)accessToUnnestVar)));
            scanCollection.setReturnsUniqueValues(false);
            scanCollection.setSourceLocation(IntroduceSecondaryIndexInsertDeleteRule.this.sourceLoc);
            LogicalVariable unnestVar = IntroduceSecondaryIndexInsertDeleteRule.this.context.newVar();
            this.lastFieldVars.add(unnestVar);
            UnnestOperator unnestOp = new UnnestOperator(unnestVar, (Mutable)new MutableObject((Object)scanCollection));
            unnestOp.setSourceLocation(IntroduceSecondaryIndexInsertDeleteRule.this.sourceLoc);
            this.currentTop = IntroduceSecondaryIndexInsertDeleteRule.this.introduceNewOp(this.currentTop, (ILogicalOperator)unnestOp, true);
            if (isFirstArrayStep) {
                this.currentBottom = unnestOp;
            }
            if (isLastUnnestInIntermediateStep) {
                this.lastRecordVar = unnestVar;
                this.lastFieldVars.clear();
            }
        }

        public void executeActionOnFinalArrayStep(ARecordType startingStepRecordType, List<String> fieldName, boolean isNonArrayStep, boolean requiresOnlyOneUnnest) throws AlgebricksException {
            if (!isNonArrayStep) {
                return;
            }
            AbstractFunctionCallExpression accessToFinalVar = startingStepRecordType != null ? IntroduceSecondaryIndexInsertDeleteRule.this.getFieldAccessFunction((Mutable<ILogicalExpression>)new MutableObject((Object)this.createLastRecordVarRef()), startingStepRecordType.getFieldIndex(fieldName.get(0)), fieldName) : IntroduceSecondaryIndexInsertDeleteRule.this.getFieldAccessFunction((Mutable<ILogicalExpression>)new MutableObject((Object)this.createLastRecordVarRef()), -1, fieldName);
            LogicalVariable finalVar = IntroduceSecondaryIndexInsertDeleteRule.this.context.newVar();
            this.lastFieldVars.add(finalVar);
            AssignOperator assignOperator = new AssignOperator(finalVar, (Mutable)new MutableObject((Object)accessToFinalVar));
            assignOperator.setSourceLocation(IntroduceSecondaryIndexInsertDeleteRule.this.sourceLoc);
            this.currentTop = IntroduceSecondaryIndexInsertDeleteRule.this.introduceNewOp(this.currentTop, (ILogicalOperator)assignOperator, true);
        }
    }
}

