/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.hyracks.bootstrap;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Properties;
import org.apache.asterix.common.config.AsterixProperties;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.hyracks.bootstrap.CCApplication;
import org.apache.asterix.hyracks.bootstrap.NCApplication;
import org.apache.hyracks.api.config.IConfigManager;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.control.common.controllers.CCConfig;
import org.apache.hyracks.control.common.controllers.ControllerConfig;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.util.file.FileUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ApplicationConfigurator {
    private static final Logger LOGGER = LogManager.getLogger();

    private ApplicationConfigurator() {
    }

    static void registerConfigOptions(IConfigManager configManager) {
        AsterixProperties.registerConfigOptions((IConfigManager)configManager);
        ControllerConfig.Option.DEFAULT_DIR.setDefaultValue(FileUtil.joinPath((String[])new String[]{System.getProperty("java.io.tmpdir"), "asterixdb"}));
        NCConfig.Option.APP_CLASS.setDefaultValue((Object)NCApplication.class.getName());
        CCConfig.Option.APP_CLASS.setDefaultValue((Object)CCApplication.class.getName());
        try {
            InputStream propertyStream = ApplicationConfigurator.class.getClassLoader().getResourceAsStream("git.properties");
            if (propertyStream != null) {
                Properties gitProperties = new Properties();
                gitProperties.load(propertyStream);
                StringWriter sw = new StringWriter();
                gitProperties.store(sw, null);
                configManager.setVersionString(sw.toString());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void validateJavaRuntime() throws HyracksDataException {
        String javaVersion = System.getProperty("java.version");
        LOGGER.info("Found JRE version " + javaVersion);
        String[] splits = javaVersion.split("\\.");
        if ("1".equals(splits[0])) {
            switch (splits[1]) {
                case "9": {
                    LOGGER.warn("JRE version \"" + javaVersion + "\" is untested");
                }
                case "8": {
                    return;
                }
            }
            throw RuntimeDataException.create((ErrorCode)ErrorCode.UNSUPPORTED_JRE, (Serializable[])new Serializable[]{"a minimum version of JRE of 1.8 is required, but is currently: \"" + javaVersion + "\""});
        }
        LOGGER.warn("JRE version \"" + javaVersion + "\" is untested");
    }
}

