/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.dataflow.connectors;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hyracks.api.dataflow.connectors.IConnectorPolicy;
import org.apache.hyracks.api.dataflow.connectors.PipeliningConnectorPolicy;
import org.apache.hyracks.api.dataflow.connectors.SendSideMaterializedBlockingConnectorPolicy;
import org.apache.hyracks.api.dataflow.connectors.SendSideMaterializedPipeliningConnectorPolicy;
import org.apache.hyracks.api.dataflow.connectors.SendSideMaterializedReceiveSideMaterializedBlockingConnectorPolicy;
import org.apache.hyracks.api.dataflow.connectors.SendSideMaterializedReceiveSideMaterializedPipeliningConnectorPolicy;
import org.apache.hyracks.api.dataflow.connectors.SendSidePipeliningReceiveSideMaterializedBlockingConnectorPolicy;

public class ConnectorPolicyFactory {
    public static ConnectorPolicyFactory INSTANCE = new ConnectorPolicyFactory();

    private ConnectorPolicyFactory() {
    }

    public IConnectorPolicy getConnectorPolicy(DataInput input) throws IOException {
        int kind = input.readInt();
        switch (kind) {
            case 0: {
                return new PipeliningConnectorPolicy();
            }
            case 1: {
                return new SendSideMaterializedBlockingConnectorPolicy();
            }
            case 2: {
                return new SendSideMaterializedPipeliningConnectorPolicy();
            }
            case 3: {
                return new SendSideMaterializedReceiveSideMaterializedBlockingConnectorPolicy();
            }
            case 4: {
                return new SendSideMaterializedReceiveSideMaterializedPipeliningConnectorPolicy();
            }
            case 5: {
                return new SendSidePipeliningReceiveSideMaterializedBlockingConnectorPolicy();
            }
        }
        return null;
    }

    public void writeConnectorPolicy(IConnectorPolicy policy, DataOutput output) throws IOException {
        if (policy instanceof PipeliningConnectorPolicy) {
            output.writeInt(0);
        } else if (policy instanceof SendSideMaterializedBlockingConnectorPolicy) {
            output.writeInt(1);
        } else if (policy instanceof SendSideMaterializedPipeliningConnectorPolicy) {
            output.writeInt(2);
        } else if (policy instanceof SendSideMaterializedReceiveSideMaterializedBlockingConnectorPolicy) {
            output.writeInt(3);
        } else if (policy instanceof SendSideMaterializedReceiveSideMaterializedPipeliningConnectorPolicy) {
            output.writeInt(4);
        } else if (policy instanceof SendSidePipeliningReceiveSideMaterializedBlockingConnectorPolicy) {
            output.writeInt(5);
        }
    }
}

