/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.ipc.sockets;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.apache.hyracks.ipc.sockets.SslSocketChannel;
import org.apache.hyracks.util.NetworkUtil;

public class SslHandshake {
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final ByteBuffer handshakeOutData;
    private final SocketChannel socketChannel;
    private final SSLEngine engine;
    private SSLEngineResult.HandshakeStatus handshakeStatus;
    private ByteBuffer handshakeInData;
    private ByteBuffer outEncryptedData;
    private ByteBuffer inEncryptedData;

    public SslHandshake(SslSocketChannel sslSocketChannel) {
        this.socketChannel = sslSocketChannel.getSocketChannel();
        this.engine = sslSocketChannel.getSslEngine();
        int pocketBufferSize = this.engine.getSession().getPacketBufferSize();
        this.inEncryptedData = ByteBuffer.allocate(pocketBufferSize);
        this.outEncryptedData = ByteBuffer.allocate(pocketBufferSize);
        int appBufferSize = this.engine.getSession().getApplicationBufferSize() + 50;
        this.handshakeOutData = ByteBuffer.allocate(appBufferSize);
        this.handshakeInData = ByteBuffer.allocate(appBufferSize);
    }

    public boolean handshake() throws IOException {
        this.handshakeStatus = this.engine.getHandshakeStatus();
        block5: while (this.handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED && this.handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            switch (this.handshakeStatus) {
                case NEED_UNWRAP: {
                    if (this.unwrap()) continue block5;
                    return false;
                }
                case NEED_WRAP: {
                    this.wrap();
                    continue block5;
                }
                case NEED_TASK: {
                    Runnable task;
                    while ((task = this.engine.getDelegatedTask()) != null) {
                        this.executor.execute(task);
                    }
                    this.handshakeStatus = this.engine.getHandshakeStatus();
                    continue block5;
                }
            }
            throw new IllegalStateException("Invalid SSL handshake status: " + (Object)((Object)this.handshakeStatus));
        }
        return true;
    }

    private void wrap() throws IOException {
        SSLEngineResult result;
        this.outEncryptedData.clear();
        try {
            result = this.engine.wrap(this.handshakeOutData, this.outEncryptedData);
            this.handshakeStatus = result.getHandshakeStatus();
        }
        catch (SSLException sslException) {
            this.engine.closeOutbound();
            this.handshakeStatus = this.engine.getHandshakeStatus();
            throw sslException;
        }
        switch (result.getStatus()) {
            case OK: {
                this.outEncryptedData.flip();
                while (this.outEncryptedData.hasRemaining()) {
                    this.socketChannel.write(this.outEncryptedData);
                }
                break;
            }
            case BUFFER_OVERFLOW: {
                this.outEncryptedData = NetworkUtil.enlargeSslPacketBuffer((SSLEngine)this.engine, (ByteBuffer)this.outEncryptedData);
                break;
            }
            case CLOSED: {
                this.outEncryptedData.flip();
                while (this.outEncryptedData.hasRemaining()) {
                    this.socketChannel.write(this.outEncryptedData);
                }
                this.inEncryptedData.clear();
                this.handshakeStatus = this.engine.getHandshakeStatus();
                break;
            }
            default: {
                throw new IllegalStateException("Invalid SSL status " + (Object)((Object)result.getStatus()));
            }
        }
    }

    private boolean unwrap() throws IOException {
        SSLEngineResult result;
        int read = this.socketChannel.read(this.inEncryptedData);
        if (read < 0) {
            if (this.engine.isInboundDone() && this.engine.isOutboundDone()) {
                return false;
            }
            this.engine.closeInbound();
            this.engine.closeOutbound();
            return false;
        }
        this.inEncryptedData.flip();
        try {
            result = this.engine.unwrap(this.inEncryptedData, this.handshakeInData);
            this.inEncryptedData.compact();
            this.handshakeStatus = result.getHandshakeStatus();
        }
        catch (SSLException sslException) {
            this.engine.closeOutbound();
            this.handshakeStatus = this.engine.getHandshakeStatus();
            throw sslException;
        }
        switch (result.getStatus()) {
            case OK: {
                break;
            }
            case BUFFER_OVERFLOW: {
                this.handshakeInData = NetworkUtil.enlargeSslApplicationBuffer((SSLEngine)this.engine, (ByteBuffer)this.handshakeInData);
                break;
            }
            case BUFFER_UNDERFLOW: {
                this.inEncryptedData = this.handleBufferUnderflow(this.engine, this.inEncryptedData);
                break;
            }
            case CLOSED: {
                if (this.engine.isOutboundDone()) {
                    return false;
                }
                this.engine.closeOutbound();
                this.handshakeStatus = this.engine.getHandshakeStatus();
                break;
            }
            default: {
                throw new IllegalStateException("Invalid SSL status " + (Object)((Object)result.getStatus()));
            }
        }
        return true;
    }

    private ByteBuffer handleBufferUnderflow(SSLEngine engine, ByteBuffer buffer) {
        if (buffer.capacity() >= engine.getSession().getPacketBufferSize()) {
            return buffer;
        }
        ByteBuffer replaceBuffer = NetworkUtil.enlargeSslPacketBuffer((SSLEngine)engine, (ByteBuffer)buffer);
        buffer.flip();
        replaceBuffer.put(buffer);
        return replaceBuffer;
    }
}

