/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors;

import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.BroadcastExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.StatefulFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;

public class BroadcastSideSwitchingVisitor
implements ILogicalExpressionVisitor<ILogicalExpression, Void> {
    private static BroadcastSideSwitchingVisitor instance = null;

    private BroadcastSideSwitchingVisitor() {
    }

    public static BroadcastSideSwitchingVisitor getInstance() {
        if (instance == null) {
            instance = new BroadcastSideSwitchingVisitor();
        }
        return instance;
    }

    @Override
    public ILogicalExpression visitConstantExpression(ConstantExpression expr, Void arg) {
        return null;
    }

    @Override
    public ILogicalExpression visitVariableReferenceExpression(VariableReferenceExpression expr, Void arg) {
        return null;
    }

    @Override
    public ILogicalExpression visitAggregateFunctionCallExpression(AggregateFunctionCallExpression expr, Void arg) {
        return null;
    }

    @Override
    public ILogicalExpression visitScalarFunctionCallExpression(ScalarFunctionCallExpression expr, Void arg) throws AlgebricksException {
        FunctionIdentifier fi = expr.getFunctionIdentifier();
        if (fi.equals(AlgebricksBuiltinFunctions.AND)) {
            for (Mutable<ILogicalExpression> a : expr.getArguments()) {
                ((ILogicalExpression)a.getValue()).accept(this, null);
            }
        }
        for (Map.Entry<Object, IExpressionAnnotation> pair : expr.getAnnotations().entrySet()) {
            if (!(pair.getKey() instanceof BroadcastExpressionAnnotation)) continue;
            BroadcastExpressionAnnotation.BroadcastSide bSide = (BroadcastExpressionAnnotation.BroadcastSide)((Object)((BroadcastExpressionAnnotation)pair.getValue()).getObject());
            switch (bSide) {
                case RIGHT: {
                    bSide = BroadcastExpressionAnnotation.BroadcastSide.LEFT;
                    break;
                }
                case LEFT: {
                    bSide = BroadcastExpressionAnnotation.BroadcastSide.RIGHT;
                    break;
                }
                default: {
                    bSide = null;
                }
            }
            ((BroadcastExpressionAnnotation)pair.getValue()).setObject((Object)bSide);
        }
        return null;
    }

    @Override
    public ILogicalExpression visitStatefulFunctionCallExpression(StatefulFunctionCallExpression expr, Void arg) {
        return null;
    }

    @Override
    public ILogicalExpression visitUnnestingFunctionCallExpression(UnnestingFunctionCallExpression expr, Void arg) {
        return null;
    }
}

