/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.logging;

import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.asterix.replication.logging.ReplicationLogBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TxnLogReplicator
implements Callable<Boolean> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ReplicationLogBuffer POISON_PILL = new ReplicationLogBuffer(null, 0, 0);
    private final LinkedBlockingQueue<ReplicationLogBuffer> emptyQ;
    private final LinkedBlockingQueue<ReplicationLogBuffer> flushQ;
    private ReplicationLogBuffer flushPage;
    private final AtomicBoolean isStarted;
    private final AtomicBoolean terminateFlag;

    public TxnLogReplicator(LinkedBlockingQueue<ReplicationLogBuffer> emptyQ, LinkedBlockingQueue<ReplicationLogBuffer> flushQ) {
        this.emptyQ = emptyQ;
        this.flushQ = flushQ;
        this.flushPage = null;
        this.isStarted = new AtomicBoolean(false);
        this.terminateFlag = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Object object = this.isStarted;
        synchronized (object) {
            while (!this.isStarted.get()) {
                try {
                    this.isStarted.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.terminateFlag.set(true);
        if (this.flushPage != null) {
            object = this.flushPage;
            synchronized (object) {
                this.flushPage.isStop(true);
                this.flushPage.notify();
            }
        }
        this.flushQ.offer(POISON_PILL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() {
        Thread.currentThread().setName("TxnLog Replicator");
        AtomicBoolean atomicBoolean = this.isStarted;
        synchronized (atomicBoolean) {
            this.isStarted.set(true);
            this.isStarted.notify();
        }
        while (true) {
            try {
                while (true) {
                    if (this.terminateFlag.get()) {
                        return true;
                    }
                    this.flushPage = null;
                    this.flushPage = this.flushQ.take();
                    if (this.flushPage == POISON_PILL) continue;
                    this.flushPage.flush();
                    if (this.flushPage.getLogBufferSize() != this.flushPage.getReplicationManager().getLogPageSize()) continue;
                    this.emptyQ.offer(this.flushPage);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            catch (Exception e) {
                LOGGER.error("TxnLogReplicator is terminating abnormally. Logs Replication Stopped.", (Throwable)e);
                throw e;
            }
            break;
        }
    }
}

