/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.aries.subsystem.core.archive.Attribute;
import org.apache.aries.subsystem.core.archive.Directive;
import org.apache.aries.subsystem.core.archive.Header;
import org.apache.aries.subsystem.core.archive.Parameter;

public class GenericHeader
implements Header<Clause> {
    private final Set<Clause> clauses;
    private final String name;

    public GenericHeader(String name, Collection<Clause> clauses) {
        this.name = name;
        this.clauses = new HashSet<Clause>(clauses);
    }

    public GenericHeader(String name, String value) {
        this(name, Collections.singletonList(new Clause(value)));
    }

    @Override
    public Collection<Clause> getClauses() {
        return Collections.unmodifiableSet(this.clauses);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Clause clause : this.getClauses()) {
            builder.append(clause).append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public static class Clause
    implements org.apache.aries.subsystem.core.archive.Clause {
        private final String path;

        public Clause(String clause) {
            this.path = clause;
        }

        @Override
        public Attribute getAttribute(String name) {
            return null;
        }

        @Override
        public Collection<Attribute> getAttributes() {
            return Collections.emptyList();
        }

        @Override
        public Directive getDirective(String name) {
            return null;
        }

        @Override
        public Collection<Directive> getDirectives() {
            return Collections.emptyList();
        }

        @Override
        public Parameter getParameter(String name) {
            return null;
        }

        @Override
        public Collection<Parameter> getParameters() {
            return Collections.emptyList();
        }

        @Override
        public String getPath() {
            return this.path;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder().append(this.getPath());
            for (Parameter parameter : this.getParameters()) {
                builder.append(';').append(parameter);
            }
            return builder.toString();
        }
    }
}

