/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.shiro.authz.impl;

import java.util.Map;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.apache.shiro.web.jaxrs.ExceptionMapper;
import org.apache.shiro.web.jaxrs.ShiroAnnotationFilterFeature;
import org.apache.shiro.web.jaxrs.SubjectPrincipalRequestFilter;
import org.osgi.annotation.bundle.Capability;
import org.osgi.service.jaxrs.whiteboard.annotations.RequireJaxrsWhiteboard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Capability(attribute={"objectClass:List<String>='javax.ws.rs.core.Feature'", "osgi.jaxrs.name=aries.shiro.authz"}, namespace="osgi.service")
@RequireJaxrsWhiteboard
public class ShiroAuthorizationFeature
implements Feature {
    private static final Logger _LOG = LoggerFactory.getLogger(ShiroAuthorizationFeature.class);

    public boolean configure(FeatureContext fc) {
        Map contracts;
        Configuration configuration = fc.getConfiguration();
        if (_LOG.isInfoEnabled()) {
            Map applicationProps = (Map)configuration.getProperty("osgi.jaxrs.application.serviceProperties");
            _LOG.info("Registering the Shiro Authorization feature with application {}", (Object)applicationProps.getOrDefault("osgi.jaxrs.name", "<No Name found in application configuration>"));
        }
        if ((contracts = configuration.getContracts(ExceptionMapper.class)).isEmpty()) {
            _LOG.debug("Registering the Shiro ExceptionMapper");
            fc.register(ExceptionMapper.class, 2000);
        } else if (2000 < contracts.getOrDefault(javax.ws.rs.ext.ExceptionMapper.class, 5000)) {
            _LOG.debug("Updating the priority of the Shiro ExceptionMapper from {} to {}", (Object)contracts.getOrDefault(javax.ws.rs.ext.ExceptionMapper.class, 5000), (Object)2000);
            contracts.put(javax.ws.rs.ext.ExceptionMapper.class, 2000);
        }
        contracts = configuration.getContracts(SubjectPrincipalRequestFilter.class);
        if (contracts.isEmpty()) {
            _LOG.debug("Registering the Shiro SubjectPrincipalRequestFilter");
            fc.register(SubjectPrincipalRequestFilter.class, 2000);
        } else if (2000 < contracts.getOrDefault(ContainerRequestFilter.class, 5000)) {
            _LOG.debug("Updating the priority of the Shiro SubjectPrincipalRequestFilter from {} to {}", (Object)contracts.getOrDefault(ContainerRequestFilter.class, 5000), (Object)2000);
            contracts.put(ContainerRequestFilter.class, 2000);
        }
        _LOG.debug("Registering the Shiro ShiroAnnotationFilterFeature");
        fc.register(ShiroAnnotationFilterFeature.class, 2000);
        return true;
    }
}

